/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.compat.jade;

import com.yzqdev.mod.jeanmod.datagen.LangDefinition;
import com.yzqdev.mod.jeanmod.inventory.GolemHealTask;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.item.ItemStack;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum VillagerProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;

    private static final ResourceLocation villager;
    private String golemHealCompound = "healIngotNum";

    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        Entity data;
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof IronGolem) {
            IronGolem ironGolem = (IronGolem)entity;
            data = entityAccessor.getServerData();
            boolean createdByPlayer = ironGolem.isPlayerCreated();
            if (createdByPlayer) {
                iTooltip.add((Component)Component.translatable((String)LangDefinition.player_created).withStyle(ChatFormatting.AQUA));
            }
            if (data.contains(this.golemHealCompound)) {
                iTooltip.add((Component)Component.translatable((String)LangDefinition.remains_ingot, (Object[])new Object[]{data.getInt(this.golemHealCompound)}).withStyle(ChatFormatting.AQUA));
            }
        }
        if ((data = entityAccessor.getEntity()) instanceof AbstractVillager) {
            ListTag itemTags;
            AbstractVillager villager = (AbstractVillager)data;
            data = entityAccessor.getServerData();
            if (data.contains("inv") && !(itemTags = data.getList("inv", 10)).isEmpty()) {
                iTooltip.add((Component)Component.translatable((String)LangDefinition.villager_backpack));
                iTooltip.add((Component)Component.literal((String)""));
                itemTags.forEach(item -> {
                    IElementHelper elements = IElementHelper.get();
                    IElement icon = elements.item(ItemStack.parseOptional((HolderLookup.Provider)villager.registryAccess(), (CompoundTag)((CompoundTag)item)), 0.8f);
                    iTooltip.append(icon);
                });
            }
        }
    }

    public void appendServerData(CompoundTag compoundTag, EntityAccessor entityAccessor) {
        IronGolem golem;
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof AbstractVillager) {
            AbstractVillager villager = (AbstractVillager)entity;
            ArrayList itemStacks = new ArrayList();
            SimpleContainer villagerInventory = villager.getInventory();
            ListTag listTag = new ListTag();
            for (int i = 0; i < villagerInventory.getContainerSize(); ++i) {
                ItemStack itemStack = villagerInventory.getItem(i);
                if (itemStack.isEmpty()) continue;
                listTag.add((Object)itemStack.save((HolderLookup.Provider)villager.registryAccess()));
            }
            compoundTag.put("inv", (Tag)listTag);
        }
        if (entity instanceof IronGolem && (golem = (IronGolem)entity) instanceof GolemHealTask) {
            GolemHealTask golemHealTask = (GolemHealTask)golem;
            compoundTag.putInt(this.golemHealCompound, golemHealTask.getIronIngotNum());
        }
    }

    public ResourceLocation getUid() {
        return villager;
    }

    static {
        villager = ResourceLocation.fromNamespaceAndPath((String)"jean", (String)"villager");
    }
}

