/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.datagen;

import com.yzqdev.mod.jeanmod.entity.ModEntities;
import com.yzqdev.mod.jeanmod.item.ModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "jean", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(ModItems.COPY_ID_ITEM);
        this.simpleItem(ModItems.COMMAND_ITEM);
        this.simpleItem(ModItems.BAMBOO_COAL);
        this.simpleItem(ModItems.RELEASE_PET_ITEM);
        this.simpleItem(ModItems.NIGHT_VISION_CARROT);
        this.simpleItem(ModItems.CHAIR_ME_ITEM);
        this.simpleItem(ModItems.EXP_BOTTLE);
        for (DeferredHolder item : ModEntities.SPAWN_EGGS.getEntries()) {
            if (!(item.get() instanceof SpawnEggItem)) continue;
            ((ItemModelBuilder)this.getBuilder(item.getId().getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.parse((String)"item/template_spawn_egg")));
        }
        this.basicItem((Item)ModItems.ORE_CLEANER_ITEM.get());
    }

    private ItemModelBuilder simpleItem(DeferredItem<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"jean", (String)("item/" + item.getId().getPath())));
    }

    private ItemModelBuilder handheldItem(DeferredItem<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"jean", (String)("item/" + item.getId().getPath())));
    }
}

