/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.elf;

import com.yzqdev.mod.jeanmod.JeanMod;
import com.yzqdev.mod.jeanmod.entity.elf.FairyAttackGoal;
import com.yzqdev.mod.jeanmod.entity.elf.FairyType;
import com.yzqdev.mod.jeanmod.entity.elf.projectile.DanmakuShoot;
import com.yzqdev.mod.jeanmod.item.ModTags;
import com.yzqdev.mod.jeanmod.sound.ModSoundEvents;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EntityElf
extends TamableAnimal
implements RangedAttackMob,
FlyingAnimal,
GeoEntity {
    private static final int MAX_FLY_HEIGHT = 150;
    private static final String FAIRY_TYPE_TAG_NAME = "FairyType";
    private static final EntityDataAccessor<Integer> FAIRY_TYPE = SynchedEntityData.defineId(EntityElf.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final double AIMED_SHOT_PROBABILITY = 0.9;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public EntityElf(EntityType<? extends TamableAnimal> type, Level worldIn) {
        super(type, worldIn);
        this.moveControl = new FlyingMoveControl((Mob)this, 15, true);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ModTags.maidFood);
    }

    public static AttributeSupplier.Builder createFairyAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ARMOR, 1.0).add(Attributes.FLYING_SPEED, 0.6);
    }

    public static boolean checkFairySpawnRules(EntityType<EntityElf> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        return true;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 20.0f, 2.0f));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.APPLE)}), false));
        this.goalSelector.addGoal(2, (Goal)new FairyAttackGoal(this, 16.0, 2.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(2, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    public boolean canAttack(LivingEntity pTarget) {
        TamableAnimal tamableAnimal;
        if (pTarget instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)pTarget).getOwnerUUID() != null) {
            return false;
        }
        return super.canAttack(pTarget);
    }

    @NotNull
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.level().isClientSide) {
            boolean flag = this.isOwnedBy((LivingEntity)player) || this.isTame();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.isFood(itemstack) && !this.isTame()) {
            if (itemstack.is(ModTags.maidFood)) {
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                if (this.random.nextInt(3) == 0) {
                    this.tame(player);
                    double newMaxHealth = 60.0;
                    this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(newMaxHealth);
                    this.setHealth(this.getMaxHealth());
                    this.setInSittingPose(true);
                    this.setTarget(null);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && this.isOwnedBy((LivingEntity)player)) {
            if (itemstack.is(ModTags.maidFood)) {
                if (!this.isTame() || !this.isOwnedBy((LivingEntity)player)) {
                    return super.mobInteract(player, hand);
                }
                this.heal(4.0f);
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)10);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionresult = super.mobInteract(player, hand);
            if (!interactionresult.consumesAction() && this.isOwnedBy((LivingEntity)player)) {
                this.setInSittingPose(!this.isInSittingPose());
                this.jumping = false;
                this.navigation.stop();
                return InteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(player, hand);
    }

    public void setInSittingPose(boolean inSittingPose) {
        super.setInSittingPose(inSittingPose);
        this.setOrderedToSit(inSittingPose);
        if (inSittingPose) {
            this.getNavigation().stop();
            this.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
            this.setTarget(null);
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.tickCount % 20 == 0) {
            if (!this.isInCombat()) {
                if (!this.level().isClientSide && this.isAlive() && this.isTame()) {
                    this.heal(1.0f);
                }
            } else if (!this.level().isClientSide && this.isAlive() && this.isTame()) {
                this.heal(2.0f);
            }
        }
    }

    private boolean isInCombat() {
        LivingEntity target = this.getTarget();
        return target != null && target.isAlive();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FAIRY_TYPE, (Object)FairyType.BLACK.ordinal());
    }

    protected void tickDeath() {
        super.tickDeath();
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        float damageBase = 1.0f;
        Difficulty difficulty = target.level().getDifficulty();
        switch (difficulty) {
            case NORMAL: {
                damageBase = 1.5f;
                break;
            }
            case HARD: {
                damageBase = 2.0f;
            }
        }
        List nearbyEntities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(16.0), e -> e instanceof LivingEntity);
        int monsterCount = nearbyEntities.size();
        if (monsterCount <= 4) {
            DanmakuShoot.create().setWorld(this.level()).setThrower((LivingEntity)this).setTarget(target).setRandomColor().setRandomType().setDamage(distanceFactor + damageBase).setGravity(0.0f).setVelocity(0.5f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).setFanNum(1).fanShapedShot();
        } else if (monsterCount <= 16) {
            DanmakuShoot.create().setWorld(this.level()).setThrower((LivingEntity)this).setTarget(target).setRandomColor().setRandomType().setDamage(distanceFactor + damageBase + 0.5f).setGravity(0.0f).setVelocity(0.5f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).setFanNum(5).setYawTotal(0.5235987755982988).fanShapedShot();
        } else {
            DanmakuShoot.create().setWorld(this.level()).setThrower((LivingEntity)this).setTarget(target).setRandomColor().setRandomType().setDamage(distanceFactor + damageBase + 0.5f).setGravity(0.0f).setVelocity(0.5f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).setFanNum(9).setYawTotal(0.5235987755982988).fanShapedShot();
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (super.hurt(source, amount) && !(source.getEntity() instanceof Player)) {
            if (this.isTame()) {
                this.setInSittingPose(false);
                if (this.getY() > 150.0) {
                    this.setDeltaMovement(this.getDeltaMovement().x, 0.0, this.getDeltaMovement().z);
                }
                this.setDeltaMovement(this.getDeltaMovement().x, 3.0, this.getDeltaMovement().z);
                JeanMod.LOGGER.info("movemovemove");
            }
            return true;
        }
        return false;
    }

    protected PathNavigation createNavigation(Level worldIn) {
        FlyingPathNavigation navigator = new FlyingPathNavigation((Mob)this, worldIn);
        navigator.setCanOpenDoors(false);
        navigator.setCanFloat(true);
        navigator.setCanPassDoors(true);
        return navigator;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setFairyTypeOrdinal(this.random.nextInt(FairyType.values().length));
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt(FAIRY_TYPE_TAG_NAME, this.getFairyTypeOrdinal());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains(FAIRY_TYPE_TAG_NAME, 3)) {
            this.setFairyTypeOrdinal(compound.getInt(FAIRY_TYPE_TAG_NAME));
        }
    }

    public int getFairyTypeOrdinal() {
        return (Integer)this.entityData.get(FAIRY_TYPE);
    }

    public void setFairyTypeOrdinal(int ordinal) {
        this.entityData.set(FAIRY_TYPE, (Object)ordinal);
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    @javax.annotation.Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.FAIRY_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return (SoundEvent)ModSoundEvents.FAIRY_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.FAIRY_DEATH.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "sit", 0, state -> ((EntityElf)state.getAnimatable()).isInSittingPose() ? state.setAndContinue(DefaultAnimations.SIT) : PlayState.STOP));
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate));
    }

    private PlayState predicate(AnimationState animationState) {
        animationState.getController().setAnimation(RawAnimation.begin().then("misc.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState state) {
        if (this.swinging && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("attack.strike", Animation.LoopType.PLAY_ONCE));
            this.swinging = false;
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

