/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.elf;

import com.yzqdev.mod.jeanmod.entity.elf.EntityElf;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class FairyAttackGoal
extends Goal {
    private static final int MAX_WITH_IN_RANGE_TIME = 10;
    private final EntityElf entityElf;
    private final double minDistance;
    private final double speedIn;
    private Path path;
    private int withInRangeTime;

    public FairyAttackGoal(EntityElf entityElf, double minDistance, double speedIn) {
        this.entityElf = entityElf;
        this.minDistance = minDistance;
        this.speedIn = speedIn;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        LivingEntity target = this.entityElf.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        this.path = this.entityElf.getNavigation().createPath((Entity)target, 0);
        return this.path != null;
    }

    public void start() {
        this.entityElf.getNavigation().moveTo(this.path, this.speedIn);
    }

    public void tick() {
        LivingEntity target = this.entityElf.getTarget();
        if (target == null || !target.isAlive()) {
            return;
        }
        this.entityElf.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        double distance = this.entityElf.distanceTo((Entity)target);
        if (this.entityElf.getSensing().hasLineOfSight((Entity)target) && distance >= this.minDistance) {
            this.entityElf.getNavigation().moveTo((Entity)target, this.speedIn);
            this.withInRangeTime = 0;
        } else if (distance < this.minDistance) {
            this.entityElf.getNavigation().stop();
            ++this.withInRangeTime;
            Vec3 motion = this.entityElf.getDeltaMovement();
            this.entityElf.setDeltaMovement(motion.x, 0.0, motion.z);
            this.entityElf.setNoGravity(true);
            if (this.withInRangeTime > 10) {
                float percent = (float)(distance / this.minDistance);
                this.entityElf.performRangedAttack(target, 1.0f - percent);
                this.withInRangeTime = 0;
            }
        } else {
            this.withInRangeTime = 0;
        }
    }

    public boolean canContinueToUse() {
        LivingEntity target = this.entityElf.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        boolean isPlayerAndCanNotBeAttacked = target instanceof Player && (target.isSpectator() || ((Player)target).isCreative());
        return !isPlayerAndCanNotBeAttacked;
    }

    public void stop() {
        boolean isPlayerAndCanNotBeAttacked;
        LivingEntity target = this.entityElf.getTarget();
        boolean bl = isPlayerAndCanNotBeAttacked = target instanceof Player && (target.isSpectator() || ((Player)target).isCreative());
        if (isPlayerAndCanNotBeAttacked) {
            this.entityElf.setTarget(null);
        }
        this.entityElf.getNavigation().stop();
        this.withInRangeTime = 0;
    }
}

