/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.gangster;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.yzqdev.mod.jeanmod.entity.ModSensorTypes;
import com.yzqdev.mod.jeanmod.entity.gangster.GangsterAi;
import com.yzqdev.mod.jeanmod.entity.gangster.GangsterHit;
import com.yzqdev.mod.jeanmod.util.ItemUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Gangster
extends Animal
implements Enemy,
GangsterHit,
GeoEntity,
InventoryCarrier {
    private static final EntityDataAccessor<Boolean> DATA_IMMUNE_TO_ZOMBIFICATION = SynchedEntityData.defineId(Gangster.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final float PROBABILITY_OF_SPAWNING_AS_BABY = 0.2f;
    private static final int MAX_HEALTH = 40;
    private static final float MOVEMENT_SPEED_WHEN_FIGHTING = 0.3f;
    private static final int ATTACK_KNOCKBACK = 1;
    private static final float KNOCKBACK_RESISTANCE = 0.6f;
    private static final int ATTACK_DAMAGE = 6;
    private static final float BABY_ATTACK_DAMAGE = 0.5f;
    private static final int CONVERSION_TIME = 300;
    private int attackAnimationRemainingTicks;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int timeInOverworld;
    private boolean cannotBeHunted;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Gangster>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.HURT_BY, (Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_ITEMS, (Object)((SensorType)ModSensorTypes.GANGSTER_PICKUP_ENTITIES_SENSOR_SENSOR_TYPE.get()), (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.NEAREST_ADULT);
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.BREED_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLIN, (Object[])new MemoryModuleType[]{MemoryModuleType.AVOID_TARGET, MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, MemoryModuleType.NEAREST_VISIBLE_ADULT_HOGLINS, MemoryModuleType.NEAREST_VISIBLE_ADULT, MemoryModuleType.NEAREST_REPELLENT, (MemoryModuleType)ModSensorTypes.VISIBLE_PICKUP_ENTITIES.get(), MemoryModuleType.PACIFIED});
    private final SimpleContainer inventory = new SimpleContainer(21);

    public Gangster(EntityType<? extends Gangster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.xpReward = 5;
    }

    public boolean canBeLeashed(Player pPlayer) {
        return !this.isLeashed();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.6f).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.ATTACK_DAMAGE, 6.0);
    }

    public boolean doHurtTarget(Entity pEntity) {
        if (!(pEntity instanceof LivingEntity)) {
            return false;
        }
        this.attackAnimationRemainingTicks = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound(SoundEvents.HOGLIN_ATTACK, 1.0f, this.getVoicePitch());
        GangsterAi.onHitTarget(this, (LivingEntity)pEntity);
        return GangsterHit.hurtAndThrowTarget((LivingEntity)this, (LivingEntity)pEntity);
    }

    protected void blockedByShield(LivingEntity pEntity) {
        if (this.isAdult()) {
            GangsterHit.throwTarget((LivingEntity)this, pEntity);
        }
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        this.triggerAnim("attacked_controller", "attacked");
        boolean flag = super.hurt(pSource, pAmount);
        if (this.level().isClientSide) {
            return false;
        }
        if (flag && pSource.getEntity() instanceof LivingEntity) {
            GangsterAi.wasHurtBy(this, (LivingEntity)pSource.getEntity());
        }
        return flag;
    }

    protected Brain.Provider<Gangster> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> pDynamic) {
        return GangsterAi.makeBrain((Brain<Gangster>)this.brainProvider().makeBrain(pDynamic));
    }

    public Brain<Gangster> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep() {
        this.level().getProfiler().push("hoglinBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().pop();
        GangsterAi.updateActivity(this);
    }

    public void aiStep() {
        if (this.attackAnimationRemainingTicks > 0) {
            --this.attackAnimationRemainingTicks;
        }
        super.aiStep();
    }

    protected void ageBoundaryReached() {
        if (this.isBaby()) {
            this.xpReward = 3;
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(0.5);
        } else {
            this.xpReward = 5;
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(6.0);
        }
    }

    public static boolean checkHoglinSpawnRules(EntityType<Gangster> pHoglin, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return !pLevel.getBlockState(pPos.below()).is(Blocks.NETHER_WART_BLOCK);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return !this.isPersistenceRequired();
    }

    public float getWalkTargetValue(BlockPos pPos, LevelReader pLevel) {
        if (GangsterAi.isPosNearNearestRepellent(this, pPos)) {
            return -1.0f;
        }
        return pLevel.getBlockState(pPos.below()).is(Blocks.CRIMSON_NYLIUM) ? 10.0f : 0.0f;
    }

    public double getPassengersRidingOffset() {
        return (double)this.getBbHeight() - (this.isBaby() ? 0.2 : 0.15);
    }

    public InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        Player player = pPlayer;
        InteractionHand hand = pHand;
        ItemStack stack = player.getItemInHand(hand);
        if (this.level().isClientSide() || stack.isEmpty()) {
            return super.mobInteract(player, hand);
        }
        EquipmentSlot slot = this.getEquipmentSlotForItem(stack);
        if (player.isShiftKeyDown()) {
            this.setItemSlot(EquipmentSlot.OFFHAND, stack.copy());
        } else {
            this.setItemSlot(slot, stack.copy());
        }
        InteractionResult interactionresult = super.mobInteract(pPlayer, pHand);
        if (interactionresult.consumesAction()) {
            this.setPersistenceRequired();
        }
        return interactionresult;
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 4) {
            this.attackAnimationRemainingTicks = 10;
            this.playSound(SoundEvents.HOGLIN_ATTACK, 1.0f, this.getVoicePitch());
        } else {
            super.handleEntityEvent(pId);
        }
    }

    @Override
    public int getAttackAnimationRemainingTicks() {
        return this.attackAnimationRemainingTicks;
    }

    public boolean shouldDropExperience() {
        return true;
    }

    protected void dropEquipment() {
        super.dropEquipment();
        BlockPos pos = this.blockPosition();
        Level world = this.level();
        if (!this.inventory.isEmpty()) {
            if (world.isEmptyBlock(pos)) {
                world.setBlockAndUpdate(pos, Blocks.CHEST.defaultBlockState());
                IItemHandler containerHandler = (IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)Direction.NORTH);
                if (containerHandler != null) {
                    this.getHandSlots().forEach(i -> ItemUtil.transferItem(i, containerHandler));
                    this.inventory.getItems().forEach(i -> ItemUtil.transferItem(i, containerHandler));
                }
            } else {
                this.getHandSlots().forEach(i -> ItemUtil.dropItem(this.level(), i, (LivingEntity)this));
                this.inventory.getItems().forEach(i -> ItemUtil.dropItem(this.level(), i, (LivingEntity)this));
            }
        }
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    protected void pushEntities() {
        super.pushEntities();
        List entityList = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.5, 0.0, 0.5), i -> true);
        if (!entityList.isEmpty() && this.isAlive()) {
            for (Entity entity : entityList) {
                if (!(entity instanceof ItemEntity)) continue;
                ItemEntity itemEntity = (ItemEntity)entity;
                this.pickupItem(itemEntity, false);
            }
        }
    }

    public boolean pickupItem(ItemEntity entityItem, boolean simulate) {
        if (!this.level().isClientSide && entityItem.isAlive() && !entityItem.hasPickUpDelay()) {
            ItemStack itemstack = entityItem.getItem();
            int count = itemstack.getCount();
            if (count == (itemstack = this.inventory.addItem(itemstack)).getCount()) {
                return false;
            }
            if (!simulate) {
                this.take((Entity)entityItem, count - itemstack.getCount());
                if (itemstack.isEmpty()) {
                    entityItem.discard();
                } else {
                    entityItem.setItem(itemstack);
                }
            }
            return true;
        }
        return false;
    }

    public boolean isFood(ItemStack pStack) {
        return pStack.is(Items.CRIMSON_FUNGUS);
    }

    public boolean isAdult() {
        return !this.isBaby();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IMMUNE_TO_ZOMBIFICATION, (Object)false);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.readInventoryFromTag(compound, (HolderLookup.Provider)this.registryAccess());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.writeInventoryToTag(compound, (HolderLookup.Provider)this.registryAccess());
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public boolean canFallInLove() {
        return !GangsterAi.isPacified(this) && super.canFallInLove();
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent getAmbientSound() {
        return this.level().isClientSide ? null : GangsterAi.getSoundForCurrentActivity(this).orElse(null);
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.HOGLIN_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.HOGLIN_DEATH;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.HOSTILE_SWIM;
    }

    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.HOSTILE_SPLASH;
    }

    protected void playStepSound(BlockPos pPos, BlockState pBlock) {
        this.playSound(SoundEvents.HOGLIN_STEP, 0.15f, 1.0f);
    }

    protected void playSoundEvent(SoundEvent pSoundEvent) {
        this.playSound(pSoundEvent, this.getSoundVolume(), this.getVoicePitch());
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    private PlayState predicate(AnimationState animationState) {
        if (animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("move.walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        animationState.getController().setAnimation(RawAnimation.begin().then("misc.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState state) {
        if (this.swinging && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("attack.strike", Animation.LoopType.PLAY_ONCE));
            this.swinging = false;
        }
        return PlayState.CONTINUE;
    }

    private PlayState diePredicate(AnimationState state) {
        if (this.isDeadOrDying()) {
            return state.setAndContinue(DefaultAnimations.DIE);
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private PlayState jumpPredicate(AnimationState state) {
        if (this.isInWater() || this.onGround() || this.isPassenger() || this.hurtTime > 0) {
            return PlayState.STOP;
        }
        state.getController().setAnimation(RawAnimation.begin().then("jump", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "jumpController", 0, this::jumpPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attacked_controller", event -> PlayState.STOP).triggerableAnim("attacked", RawAnimation.begin().then("attacked", Animation.LoopType.PLAY_ONCE)));
        controllers.add(new AnimationController((GeoAnimatable)this, "die", 0, this::diePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static boolean checkGangsterSpawnRules(EntityType<Gangster> gangsterEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return true;
    }

    public static boolean canSpawn(EntityType<Gangster> gangsterEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return true;
    }
}

