/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.gangster;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.yzqdev.mod.jeanmod.entity.gangster.Gangster;
import com.yzqdev.mod.jeanmod.entity.gangster.GangsterPickupEntitiesTask;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.BecomePassiveIfMemoryPresent;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.schedule.Activity;

public class GangsterAi {
    public static final int REPELLENT_DETECTION_RANGE_HORIZONTAL = 8;
    public static final int REPELLENT_DETECTION_RANGE_VERTICAL = 4;
    private static final UniformInt RETREAT_DURATION = TimeUtil.rangeOfSeconds((int)5, (int)20);
    private static final int ATTACK_DURATION = 200;
    private static final int DESIRED_DISTANCE_FROM_PIGLIN_WHEN_IDLING = 8;
    private static final int DESIRED_DISTANCE_FROM_PIGLIN_WHEN_RETREATING = 15;
    private static final int ATTACK_INTERVAL = 40;
    private static final int BABY_ATTACK_INTERVAL = 15;
    private static final int REPELLENT_PACIFY_TIME = 200;
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of((int)5, (int)16);
    private static final float SPEED_MULTIPLIER_WHEN_AVOIDING_REPELLENT = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_RETREATING = 1.3f;
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 0.6f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.4f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_ADULT = 0.6f;

    protected static Brain<?> makeBrain(Brain<Gangster> pBrain) {
        GangsterAi.initCoreActivity(pBrain);
        GangsterAi.initIdleActivity(pBrain);
        GangsterAi.initFightActivity(pBrain);
        GangsterAi.initRetreatActivity(pBrain);
        pBrain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        pBrain.setDefaultActivity(Activity.IDLE);
        pBrain.useDefaultActivity();
        return pBrain;
    }

    private static void initCoreActivity(Brain<Gangster> pBrain) {
        pBrain.addActivity(Activity.CORE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new Swim(0.8f)), (Object)Pair.of((Object)4, (Object)((Object)new GangsterPickupEntitiesTask(1.2f))), (Object)Pair.of((Object)1, (Object)new LookAtTargetSink(45, 90)), (Object)Pair.of((Object)2, (Object)new MoveToTargetSink())));
    }

    private static void initIdleActivity(Brain<Gangster> pBrain) {
        pBrain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)1, (Object)BecomePassiveIfMemoryPresent.create((MemoryModuleType)MemoryModuleType.NEAREST_REPELLENT, (int)200)), (Object)Pair.of((Object)2, (Object)GangsterAi.randomStroll()), (Object)Pair.of((Object)3, (Object)SetWalkTargetAwayFrom.pos((MemoryModuleType)MemoryModuleType.NEAREST_REPELLENT, (float)1.0f, (int)8, (boolean)true)), (Object)Pair.of((Object)5, (Object)StartAttacking.create(GangsterAi::findNearestValidAttackTarget)), (Object)Pair.of((Object)6, (Object)SetEntityLookTargetSometimes.create((float)8.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)7, (Object)BabyFollowAdult.create((UniformInt)ADULT_FOLLOW_RANGE, (float)0.6f))));
    }

    private static void initFightActivity(Brain<Gangster> pBrain) {
        pBrain.addActivityAndRemoveMemoriesWhenStopped(Activity.FIGHT, ImmutableList.of((Object)Pair.of((Object)1, (Object)BecomePassiveIfMemoryPresent.create((MemoryModuleType)MemoryModuleType.NEAREST_REPELLENT, (int)200)), (Object)Pair.of((Object)1, (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.0f)), (Object)Pair.of((Object)1, (Object)BehaviorBuilder.triggerIf(Gangster::isAdult, (OneShot)MeleeAttack.create((int)40))), (Object)Pair.of((Object)1, (Object)BehaviorBuilder.triggerIf(AgeableMob::isBaby, (OneShot)MeleeAttack.create((int)15))), (Object)Pair.of((Object)1, (Object)StopAttackingIfTargetInvalid.create()), (Object)Pair.of((Object)1, (Object)EraseMemoryIf.create(GangsterAi::isBreeding, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT)), (Set)ImmutableSet.of((Object)MemoryModuleType.ATTACK_TARGET));
    }

    private static void initRetreatActivity(Brain<Gangster> pBrain) {
        pBrain.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.3f, (int)15, (boolean)false), (Object)SetEntityLookTargetSometimes.create((float)8.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)EraseMemoryIf.create(GangsterAi::wantsToStopFleeing, (MemoryModuleType)MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    private static RunOne<Gangster> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)0.4f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)0.4f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    protected static void updateActivity(Gangster pGangster) {
        Activity activity1;
        Brain<Gangster> brain = pGangster.getBrain();
        Activity activity = brain.getActiveNonCoreActivity().orElse(null);
        brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.AVOID, (Object)Activity.IDLE));
        if (LocalDateTime.now().getSecond() % 5 == 0) {
            // empty if block
        }
        if (activity != (activity1 = brain.getActiveNonCoreActivity().orElse(null))) {
            GangsterAi.getSoundForCurrentActivity(pGangster).ifPresent(pGangster::playSoundEvent);
        }
        pGangster.setAggressive(brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
    }

    private static RunOne randomStroll() {
        Pair walkRandomly = Pair.of((Object)RandomStroll.stroll((float)1.0f, (int)5, (int)3), (Object)1);
        Pair noLook = Pair.of((Object)new DoNothing(30, 60), (Object)2);
        return new RunOne((List)ImmutableList.of((Object)walkRandomly, (Object)noLook));
    }

    protected static void onHitTarget(Gangster pGangster, LivingEntity pTarget) {
        if (!pGangster.isBaby()) {
            if (pTarget.getType() == EntityType.PIGLIN && GangsterAi.piglinsOutnumberHoglins(pGangster)) {
                GangsterAi.setAvoidTarget(pGangster, pTarget);
                GangsterAi.broadcastRetreat(pGangster, pTarget);
            } else {
                GangsterAi.broadcastAttackTarget(pGangster, pTarget);
            }
        }
    }

    private static void broadcastRetreat(Gangster pGangster, LivingEntity pTarget) {
        GangsterAi.retreatFromNearestTarget(pGangster, pTarget);
    }

    private static void retreatFromNearestTarget(Gangster pGangster, LivingEntity pTarget) {
        Brain<Gangster> brain = pGangster.getBrain();
        LivingEntity $$2 = BehaviorUtils.getNearestTarget((LivingEntity)pGangster, (Optional)brain.getMemory(MemoryModuleType.AVOID_TARGET), (LivingEntity)pTarget);
        $$2 = BehaviorUtils.getNearestTarget((LivingEntity)pGangster, (Optional)brain.getMemory(MemoryModuleType.ATTACK_TARGET), (LivingEntity)$$2);
        GangsterAi.setAvoidTarget(pGangster, $$2);
    }

    private static void setAvoidTarget(Gangster pGangster, LivingEntity pTarget) {
        pGangster.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        pGangster.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        pGangster.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)pTarget, (long)RETREAT_DURATION.sample(pGangster.level().random));
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Gangster gangster) {
        Optional living = gangster.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
        Optional attackable = living.flatMap(m -> m.findClosest(v -> v.isAlive() && !(v instanceof Creeper)));
        if (attackable.isPresent() && !(attackable.get() instanceof Gangster)) {
            return !GangsterAi.isPacified(gangster) && !GangsterAi.isBreeding(gangster) ? attackable : Optional.empty();
        }
        return Optional.empty();
    }

    static boolean isPosNearNearestRepellent(Gangster pGangster, BlockPos pPos) {
        Optional optional = pGangster.getBrain().getMemory(MemoryModuleType.NEAREST_REPELLENT);
        return optional.isPresent() && ((BlockPos)optional.get()).closerThan((Vec3i)pPos, 8.0);
    }

    private static boolean wantsToStopFleeing(Gangster p_34618_) {
        return p_34618_.isAdult() && !GangsterAi.piglinsOutnumberHoglins(p_34618_);
    }

    private static boolean piglinsOutnumberHoglins(Gangster pGangster) {
        int j;
        if (pGangster.isBaby()) {
            return false;
        }
        int i = pGangster.getBrain().getMemory(MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT).orElse(0);
        return i > (j = pGangster.getBrain().getMemory(MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT).orElse(0) + 1);
    }

    protected static void wasHurtBy(Gangster pGangster, LivingEntity pLivingEntity) {
        Brain<Gangster> brain = pGangster.getBrain();
        brain.eraseMemory(MemoryModuleType.PACIFIED);
        brain.eraseMemory(MemoryModuleType.BREED_TARGET);
        if (pGangster.isBaby()) {
            GangsterAi.retreatFromNearestTarget(pGangster, pLivingEntity);
        } else {
            GangsterAi.maybeRetaliate(pGangster, pLivingEntity);
        }
    }

    private static void maybeRetaliate(Gangster pGangster, LivingEntity pLivingEntity) {
        if (!(pGangster.getBrain().isActive(Activity.AVOID) && pLivingEntity.getType() == EntityType.PIGLIN || pLivingEntity.getType() == EntityType.HOGLIN || BehaviorUtils.isOtherTargetMuchFurtherAwayThanCurrentAttackTarget((LivingEntity)pGangster, (LivingEntity)pLivingEntity, (double)4.0) || !Sensor.isEntityAttackable((LivingEntity)pGangster, (LivingEntity)pLivingEntity))) {
            GangsterAi.setAttackTarget(pGangster, pLivingEntity);
            GangsterAi.broadcastAttackTarget(pGangster, pLivingEntity);
        }
    }

    private static void setAttackTarget(Gangster pGangster, LivingEntity pTarget) {
        Brain<Gangster> brain = pGangster.getBrain();
        brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        brain.eraseMemory(MemoryModuleType.BREED_TARGET);
        brain.setMemoryWithExpiry(MemoryModuleType.ATTACK_TARGET, (Object)pTarget, 200L);
    }

    private static void broadcastAttackTarget(Gangster pGangster, LivingEntity pTarget) {
        GangsterAi.setAttackTargetIfCloserThanCurrent(pGangster, pTarget);
    }

    private static void setAttackTargetIfCloserThanCurrent(Gangster pGangster, LivingEntity pTarget) {
        if (!GangsterAi.isPacified(pGangster)) {
            Optional optional = pGangster.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
            LivingEntity livingentity = BehaviorUtils.getNearestTarget((LivingEntity)pGangster, (Optional)optional, (LivingEntity)pTarget);
            GangsterAi.setAttackTarget(pGangster, livingentity);
        }
    }

    public static Optional<SoundEvent> getSoundForCurrentActivity(Gangster pGangster) {
        return pGangster.getBrain().getActiveNonCoreActivity().map(p_34600_ -> GangsterAi.getSoundForActivity(pGangster, p_34600_));
    }

    private static SoundEvent getSoundForActivity(Gangster pGangster, Activity pActivity) {
        if (pActivity != Activity.AVOID) {
            if (pActivity == Activity.FIGHT) {
                return SoundEvents.HOGLIN_ANGRY;
            }
            return GangsterAi.isNearRepellent(pGangster) ? SoundEvents.HOGLIN_RETREAT : SoundEvents.HOGLIN_AMBIENT;
        }
        return SoundEvents.HOGLIN_RETREAT;
    }

    private static boolean isNearRepellent(Gangster pGangster) {
        return pGangster.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_REPELLENT);
    }

    private static boolean isBreeding(Gangster p_34638_) {
        return p_34638_.getBrain().hasMemoryValue(MemoryModuleType.BREED_TARGET);
    }

    protected static boolean isPacified(Gangster pGangster) {
        return pGangster.getBrain().hasMemoryValue(MemoryModuleType.PACIFIED);
    }
}

