/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.gangster;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public interface GangsterHit {
    public static final int ATTACK_ANIMATION_DURATION = 10;

    public int getAttackAnimationRemainingTicks();

    public static boolean hurtAndThrowTarget(LivingEntity hoglin, LivingEntity target) {
        float f1 = (float)hoglin.getAttributeValue(Attributes.ATTACK_DAMAGE);
        float f = !hoglin.isBaby() && (int)f1 > 0 ? f1 / 2.0f + (float)hoglin.level().random.nextInt((int)f1) : f1;
        DamageSource damagesource = hoglin.damageSources().mobAttack(hoglin);
        boolean flag = target.hurt(damagesource, f);
        if (flag) {
            Level level = hoglin.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)target, (DamageSource)damagesource);
            }
            if (!hoglin.isBaby()) {
                GangsterHit.throwTarget(hoglin, target);
            }
        }
        return flag;
    }

    public static void throwTarget(LivingEntity pHoglin, LivingEntity pTarget) {
        double d1;
        double d0 = pHoglin.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
        double d2 = d0 - (d1 = pTarget.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
        if (!(d2 <= 0.0)) {
            double d3 = pTarget.getX() - pHoglin.getX();
            double d4 = pTarget.getZ() - pHoglin.getZ();
            float f = pHoglin.level().random.nextInt(21) - 10;
            double d5 = d2 * (double)(pHoglin.level().random.nextFloat() * 0.5f + 0.2f);
            Vec3 vec3 = new Vec3(d3, 0.0, d4).normalize().scale(d5).yRot(f);
            double d6 = d2 * (double)pHoglin.level().random.nextFloat() * 0.5;
            pTarget.push(vec3.x, d6, vec3.z);
            pTarget.hurtMarked = true;
        }
    }
}

