/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.gangster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.yzqdev.mod.jeanmod.entity.gangster.Gangster;
import com.yzqdev.mod.jeanmod.entity.gangster.GangsterModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;
import software.bernie.geckolib.renderer.specialty.DynamicGeoEntityRenderer;

public class GangsterRender
extends DynamicGeoEntityRenderer<Gangster> {
    private static final String LEFT_HAND = "left_hand";
    private static final String RIGHT_HAND = "right_hand";
    private static final String LEFT_BOOT = "left_foot";
    private static final String RIGHT_BOOT = "right_foot";
    private static final String LEFT_ARMOR_LEG = "armor_left_leg";
    private static final String RIGHT_ARMOR_LEG = "armor_right_leg";
    private static final String CHESTPLATE = "armor_body";
    private static final String RIGHT_SLEEVE = "armor_right_arm";
    private static final String LEFT_SLEEVE = "armor_left_arm";
    private static final String HELMET = "armor_head";
    protected ItemStack mainHandItem;
    protected ItemStack offhandItem;

    public GangsterRender(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new GangsterModel(ResourceLocation.fromNamespaceAndPath((String)"jean", (String)"gangster")));
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<Gangster>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, Gangster animatable) {
                return switch (bone.getName()) {
                    case GangsterRender.LEFT_BOOT, GangsterRender.RIGHT_BOOT -> this.bootsStack;
                    case GangsterRender.LEFT_ARMOR_LEG, GangsterRender.RIGHT_ARMOR_LEG -> this.leggingsStack;
                    case GangsterRender.CHESTPLATE, GangsterRender.RIGHT_SLEEVE, GangsterRender.LEFT_SLEEVE -> this.chestplateStack;
                    case GangsterRender.HELMET -> this.helmetStack;
                    default -> null;
                };
            }

            @NotNull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, Gangster animatable) {
                return switch (bone.getName()) {
                    case GangsterRender.LEFT_BOOT, GangsterRender.RIGHT_BOOT -> EquipmentSlot.FEET;
                    case GangsterRender.LEFT_ARMOR_LEG, GangsterRender.RIGHT_ARMOR_LEG -> EquipmentSlot.LEGS;
                    case GangsterRender.RIGHT_SLEEVE -> {
                        if (!animatable.isLeftHanded()) {
                            yield EquipmentSlot.MAINHAND;
                        }
                        yield EquipmentSlot.OFFHAND;
                    }
                    case GangsterRender.LEFT_SLEEVE -> {
                        if (animatable.isLeftHanded()) {
                            yield EquipmentSlot.OFFHAND;
                        }
                        yield EquipmentSlot.MAINHAND;
                    }
                    case GangsterRender.CHESTPLATE -> EquipmentSlot.CHEST;
                    case GangsterRender.HELMET -> EquipmentSlot.HEAD;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @NotNull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, Gangster animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case GangsterRender.LEFT_BOOT, GangsterRender.LEFT_ARMOR_LEG -> baseModel.leftLeg;
                    case GangsterRender.RIGHT_BOOT, GangsterRender.RIGHT_ARMOR_LEG -> baseModel.rightLeg;
                    case GangsterRender.RIGHT_SLEEVE -> baseModel.rightArm;
                    case GangsterRender.LEFT_SLEEVE -> baseModel.leftArm;
                    case GangsterRender.CHESTPLATE -> baseModel.body;
                    case GangsterRender.HELMET -> baseModel.head;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<Gangster>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, Gangster animatable) {
                return switch (bone.getName()) {
                    case GangsterRender.LEFT_HAND -> {
                        if (animatable.isLeftHanded()) {
                            yield GangsterRender.this.mainHandItem;
                        }
                        yield GangsterRender.this.offhandItem;
                    }
                    case GangsterRender.RIGHT_HAND -> {
                        if (animatable.isLeftHanded()) {
                            yield GangsterRender.this.offhandItem;
                        }
                        yield GangsterRender.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, Gangster animatable) {
                return switch (bone.getName()) {
                    case GangsterRender.LEFT_HAND, GangsterRender.RIGHT_HAND -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, Gangster animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == GangsterRender.this.mainHandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(0.0, 0.125, -0.25);
                    }
                } else if (stack == GangsterRender.this.offhandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(0.0, 0.125, 0.25);
                        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    }
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    protected float getDeathMaxRotation(Gangster animatable) {
        return 0.0f;
    }

    public void preRender(PoseStack poseStack, Gangster animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        this.mainHandItem = animatable.getMainHandItem();
        this.offhandItem = animatable.getOffhandItem();
    }
}

