/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.human;

import com.mojang.serialization.Dynamic;
import com.yzqdev.mod.jeanmod.entity.ModEntities;
import com.yzqdev.mod.jeanmod.entity.ModSensorTypes;
import com.yzqdev.mod.jeanmod.entity.human.HumanAI;
import com.yzqdev.mod.jeanmod.network.NetworkHandler;
import com.yzqdev.mod.jeanmod.network.PlayHumanSoundPackage;
import com.yzqdev.mod.jeanmod.sound.ModSoundEvents;
import com.yzqdev.mod.jeanmod.sound.human.HumanSoundLoader;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Human
extends TamableAnimal
implements GeoEntity {
    private int lowerHeadTick;
    private int eatAnimationTick;
    private static final EntityDataAccessor<String> DATA_SOUND_PACK_ID = SynchedEntityData.defineId(Human.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private String DataSoundPack = "sound_pack_id";
    protected static final List<SensorType<? extends Sensor<? super Human>>> SENSOR_TYPES = List.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_PLAYERS, SensorType.NEAREST_ITEMS, (SensorType)ModSensorTypes.HUMAN_TEMPTATIONS.get(), SensorType.HURT_BY);
    protected static final List<MemoryModuleType<?>> MEMORY_TYPES = List.of(MemoryModuleType.LOOK_TARGET, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.PATH, MemoryModuleType.ANGRY_AT, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.ATE_RECENTLY, MemoryModuleType.BREED_TARGET, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ADULT, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.IS_PANICKING);
    private int infestationCounter = 0;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Human(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.getNavigation().setCanFloat(true);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.HUMAN_HURT.get();
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        if (sound.getLocation().getPath().contains("human")) {
            NetworkHandler.sendToNearby((Entity)this, new PlayHumanSoundPackage(sound.getLocation(), this.getSoundPackId(), this.getId()), 16);
        } else {
            super.playSound(sound, volume, pitch);
        }
    }

    public String getSoundPackId() {
        return (String)this.entityData.get(DATA_SOUND_PACK_ID);
    }

    public void setSoundPackId(String soundPackId) {
        this.entityData.set(DATA_SOUND_PACK_ID, (Object)soundPackId);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        List<String> sounds = HumanSoundLoader.getSoundIds();
        if (!sounds.isEmpty()) {
            String id = sounds.get(this.random.nextInt(sounds.size()));
            builder.define(DATA_SOUND_PACK_ID, (Object)id);
        } else {
            builder.define(DATA_SOUND_PACK_ID, (Object)"nilu");
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains(this.DataSoundPack)) {
            this.setSoundPackId(compound.getString(this.DataSoundPack));
        } else {
            List<String> sounds = HumanSoundLoader.getSoundIds();
            if (!sounds.isEmpty()) {
                this.setSoundPackId(sounds.get(this.random.nextInt(sounds.size())));
            } else {
                this.setSoundPackId("nilu");
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString(this.DataSoundPack, this.getSoundPackId());
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        boolean flag = super.hurt(pSource, pAmount);
        if (this.level().isClientSide) {
            return false;
        }
        if (flag && pSource.getEntity() instanceof LivingEntity) {
            HumanAI.hurtBy(this, (LivingEntity)pSource.getEntity());
        }
        return flag;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return (AgeableMob)((EntityType)ModEntities.HUMAN.get()).create((Level)level);
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    protected Brain.Provider<Human> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    @NotNull
    protected Brain<Human> makeBrain(Dynamic<?> dynamic) {
        return HumanAI.makeBrain(this, (Brain<Human>)this.brainProvider().makeBrain(dynamic));
    }

    @NotNull
    public Brain<Human> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep() {
        Level level = this.level();
        this.level().getProfiler().push("humanBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().pop();
        HumanAI.updateActivity(this);
    }

    public void aiStep() {
        if (this.level().isClientSide) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.aiStep();
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.ROTTEN_FLESH);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        RandomSource randomSource = level.getRandom();
        if (!StringUtil.isBlank((String)this.getSoundPackId())) {
            this.setCustomName((Component)Component.literal((String)this.getSoundPackId()));
        }
        HumanAI.initMemories(this, randomSource);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 1.5).add(Attributes.ARMOR, 1.0);
    }

    private PlayState predicate(AnimationState animationState) {
        if (animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("move.walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        animationState.getController().setAnimation(RawAnimation.begin().then("misc.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState state) {
        if (this.swinging && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("attack.strike", Animation.LoopType.PLAY_ONCE));
            this.swinging = false;
        }
        return PlayState.CONTINUE;
    }

    public int getMaxHeadYRot() {
        return 15;
    }

    public void setYHeadRot(float yHeadRot) {
        int i = this.getMaxHeadYRot();
        float f = Mth.degreesDifference((float)this.yBodyRot, (float)yHeadRot);
        float g = Mth.clamp((float)f, (float)(-i), (float)i);
        super.setYHeadRot(this.yBodyRot + g);
    }

    public float getHeadEatPositionScale(float partialTick) {
        if (this.eatAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return 1.0f;
        }
        return this.eatAnimationTick < 4 ? ((float)this.eatAnimationTick - partialTick) / 4.0f : -((float)(this.eatAnimationTick - 40) - partialTick) / 4.0f;
    }

    public float getHeadEatAngleScale(float partialTick) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float f = ((float)(this.eatAnimationTick - 4) - partialTick) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.sin((float)(f * 28.7f));
        }
        if (this.eatAnimationTick > 0) {
            return 0.62831855f;
        }
        return this.getViewXRot(partialTick) * ((float)Math.PI / 180);
    }

    public boolean checkSpawnRules(LevelAccessor accessor, MobSpawnType reason) {
        List giantsNearby = accessor.getEntitiesOfClass(Human.class, this.getBoundingBox().inflate(100.0, 10.0, 100.0));
        return giantsNearby.size() < 3;
    }

    public static boolean canSpawn(EntityType<Human> type, ServerLevelAccessor accessor, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static boolean checkHumanSpawnRules(EntityType<Human> humanEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return true;
    }
}

