/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.human;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.yzqdev.mod.jeanmod.entity.ModEntities;
import com.yzqdev.mod.jeanmod.entity.human.Human;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BecomePassiveIfMemoryPresent;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class HumanAI {
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of((int)5, (int)16);
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_ADULT = 1.25f;
    private static final float SPEED_MULTIPLIER_WHEN_TEMPTED = 1.25f;
    private static final float SPEED_MULTIPLIER_WHEN_PANICKING = 2.0f;
    private static final float SPEED_MULTIPLIER_WHEN_PREPARING_TO_RAM = 1.25f;
    private static final UniformInt TIME_BETWEEN_LONG_JUMPS = UniformInt.of((int)60, (int)120);
    public static final int MAX_LONG_JUMP_HEIGHT = 3;
    public static final int MAX_LONG_JUMP_WIDTH = 4;
    public static final float MAX_JUMP_VELOCITY = 1.5f;

    protected static void initMemories(Human goat, RandomSource random) {
    }

    protected static Brain<Human> makeBrain(Human human, Brain<Human> brain) {
        HumanAI.initCoreActivity(brain);
        HumanAI.initIdleActivity(brain);
        HumanAI.initFightActivity(human, brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initFightActivity(Human human, Brain<Human> pBrain) {
        pBrain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)BecomePassiveIfMemoryPresent.create((MemoryModuleType)MemoryModuleType.NEAREST_REPELLENT, (int)200), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.0f), (Object)BehaviorBuilder.triggerIf(maid -> true, (OneShot)MeleeAttack.create((int)5)), (Object)StopAttackingIfTargetInvalid.create(livingEntity -> false, (mob, livingEntity) -> {}, (boolean)false)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initCoreActivity(Brain<Human> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new AnimalMakeLove((EntityType)ModEntities.HUMAN.get()), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(Brain<Human> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new FollowTemptation(i -> Float.valueOf(1.2f))), (Object)Pair.of((Object)1, (Object)SetWalkTargetAwayFrom.pos((MemoryModuleType)MemoryModuleType.NEAREST_REPELLENT, (float)1.0f, (int)8, (boolean)true)), (Object)Pair.of((Object)1, (Object)StartAttacking.create(HumanAI::findNearestValidAttackTarget)), (Object)Pair.of((Object)1, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))));
    }

    public static void hurtBy(Human human, LivingEntity target) {
        if (Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)human, (LivingEntity)target) && !BehaviorUtils.isOtherTargetMuchFurtherAwayThanCurrentAttackTarget((LivingEntity)human, (LivingEntity)target, (double)1.0)) {
            HumanAI.setAngryTarget(human, target);
        }
    }

    public static void setAngryTarget(Human human, LivingEntity target) {
        human.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        human.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_TARGET, (Object)target, 200L);
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Human human) {
        Optional optional = BehaviorUtils.getLivingEntityFromUUIDMemory((LivingEntity)human, (MemoryModuleType)MemoryModuleType.ANGRY_AT);
        if (optional.isPresent() && Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)human, (LivingEntity)((LivingEntity)optional.get()))) {
            return optional;
        }
        Optional optionalLivingEntity = HumanAI.getTargetLivings(human);
        return optionalLivingEntity.isPresent() ? optionalLivingEntity : human.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_NEMESIS);
    }

    private static Optional<LivingEntity> getTargetLivings(Human human) {
        Optional livings = human.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
        return livings.flatMap(i -> i.findClosest(v -> v instanceof Zombie));
    }

    private static Optional<? extends LivingEntity> getTargetIfWithinRange(Human human, MemoryModuleType<? extends LivingEntity> pMemoryType) {
        return human.getBrain().getMemory(pMemoryType).filter(livingEntity -> livingEntity.closerThan((Entity)human, 12.0));
    }

    public static void updateActivity(Human human) {
        Brain<Human> brains = human.getBrain();
        if (LocalDateTime.now().getSecond() % 5 == 0) {
            // empty if block
        }
        brains.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
        human.setAggressive(brains.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
    }

    public static Ingredient getTemptations() {
        return Ingredient.of((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH});
    }
}

