/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.human;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;

public class HumanEatGrassBehavior
extends Behavior<Animal> {
    private static final int EAT_ANIMATION_TICKS = 40;
    private static final Predicate<BlockState> IS_TALL_GRASS = BlockStatePredicate.forBlock((Block)Blocks.TALL_GRASS);
    private static final Predicate<BlockState> IS_GRASS_BLOCK = BlockStatePredicate.forBlock((Block)Blocks.GRASS_BLOCK);
    private static final int MAX_DURATION = 110;
    private int eatAnimationTick;

    public HumanEatGrassBehavior() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED), 110);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Animal owner) {
        if (owner.getRandom().nextInt(owner.isBaby() ? 50 : 1000) != 0) {
            return false;
        }
        BlockPos blockPos = owner.blockPosition();
        if (IS_TALL_GRASS.test(level.getBlockState(blockPos))) {
            return true;
        }
        return IS_GRASS_BLOCK.test(level.getBlockState(blockPos.below()));
    }

    protected void start(ServerLevel level, Animal entity, long gameTime) {
        this.eatAnimationTick = 40;
        level.broadcastEntityEvent((Entity)entity, (byte)10);
        entity.getNavigation().stop();
        entity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }

    protected boolean canStillUse(ServerLevel level, Animal entity, long gameTime) {
        return this.eatAnimationTick > 0;
    }

    protected void tick(ServerLevel level, Animal owner, long gameTime) {
        owner.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        if (this.eatAnimationTick == 4) {
            BlockPos blockPos = owner.blockPosition();
            if (IS_TALL_GRASS.test(level.getBlockState(blockPos))) {
                if (level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                    level.destroyBlock(blockPos, false);
                }
                owner.ate();
            } else {
                BlockPos below = blockPos.below();
                BlockState belowState = level.getBlockState(below);
                if (IS_GRASS_BLOCK.test(belowState)) {
                    if (level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                        level.levelEvent(2001, below, Block.getId((BlockState)belowState));
                        level.setBlock(below, Blocks.DIRT.defaultBlockState(), 2);
                    }
                    owner.ate();
                }
            }
        }
    }

    protected void stop(ServerLevel level, Animal entity, long gameTime) {
        this.eatAnimationTick = 0;
    }
}

