/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.maid;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.yzqdev.mod.jeanmod.entity.ModEntities;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import com.yzqdev.mod.jeanmod.entity.maid.MaidBegTask;
import com.yzqdev.mod.jeanmod.entity.maid.MaidFollowOwnerTask;
import com.yzqdev.mod.jeanmod.entity.maid.MaidHealSelfTask;
import com.yzqdev.mod.jeanmod.entity.maid.MaidPickupEntitiesTask;
import com.yzqdev.mod.jeanmod.item.ModTags;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BecomePassiveIfMemoryPresent;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;

public class MaidAi {
    public static Brain<?> makeBrain(Maid maid, Brain<Maid> maidBrain) {
        MaidAi.initCoreActivity(maidBrain);
        MaidAi.initIdleActivity(maidBrain);
        MaidAi.initFightActivity(maid, maidBrain);
        maidBrain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        maidBrain.setDefaultActivity(Activity.IDLE);
        maidBrain.useDefaultActivity();
        return maidBrain;
    }

    public static void initCoreActivity(Brain<Maid> brain) {
        brain.addActivity(Activity.CORE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new Swim(0.8f)), (Object)Pair.of((Object)0, (Object)new AnimalMakeLove((EntityType)ModEntities.MAID_ENTITY_TYPE.get())), (Object)Pair.of((Object)0, (Object)new LookAtTargetSink(45, 90)), (Object)Pair.of((Object)3, (Object)((Object)new MaidPickupEntitiesTask(1.2f))), (Object)Pair.of((Object)2, (Object)new MoveToTargetSink()), (Object)Pair.of((Object)3, (Object)((Object)new MaidFollowOwnerTask(1.2f, 2))), (Object)Pair.of((Object)3, (Object)((Object)new MaidHealSelfTask())), (Object)Pair.of((Object)4, (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS))));
    }

    public static void initIdleActivity(Brain<Maid> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)1, (Object)new FollowTemptation(i -> Float.valueOf(1.2f))), (Object)Pair.of((Object)2, (Object)StartAttacking.create(maid -> true, MaidAi::findNearestValidAttackTarget)), (Object)Pair.of((Object)3, (Object)((Object)new MaidBegTask())), (Object)Pair.of((Object)4, (Object)MaidAi.getLookAndRandomWalk())));
    }

    private static RunOne getLookAndRandomWalk() {
        Pair lookToPlayer = Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.PLAYER, (float)5.0f), (Object)1);
        Pair lookToEntity = Pair.of((Object)SetEntityLookTargetSometimes.create((float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)1);
        Pair lookToMaid = Pair.of((Object)SetEntityLookTarget.create((EntityType)((EntityType)ModEntities.MAID_ENTITY_TYPE.get()), (float)5.0f), (Object)1);
        Pair lookToWolf = Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.WOLF, (float)5.0f), (Object)1);
        Pair lookToCat = Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.CAT, (float)5.0f), (Object)1);
        Pair lookToParrot = Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.PARROT, (float)5.0f), (Object)1);
        Pair walkRandomly = Pair.of((Object)RandomStroll.stroll((float)0.6f, (int)5, (int)3), (Object)1);
        Pair noLook = Pair.of((Object)new DoNothing(30, 60), (Object)2);
        return new RunOne((List)ImmutableList.of((Object)lookToEntity, (Object)lookToPlayer, (Object)lookToMaid, (Object)lookToWolf, (Object)lookToCat, (Object)lookToParrot, (Object)walkRandomly, (Object)noLook));
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Maid maid) {
        Optional livings = maid.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
        Optional attackTarget = maid.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        if (attackTarget.isPresent()) {
            return attackTarget;
        }
        return livings.flatMap(i -> i.findClosest(v -> maid.canAttack((LivingEntity)v)));
    }

    public static void initFightActivity(Maid maid, Brain<Maid> brain) {
        brain.addActivityAndRemoveMemoriesWhenStopped(Activity.FIGHT, ImmutableList.of((Object)Pair.of((Object)2, (Object)BecomePassiveIfMemoryPresent.create((MemoryModuleType)MemoryModuleType.NEAREST_REPELLENT, (int)200)), (Object)Pair.of((Object)2, (Object)BehaviorBuilder.triggerIf(i -> true, (OneShot)MeleeAttack.create((int)10))), (Object)Pair.of((Object)3, (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.2f)), (Object)Pair.of((Object)4, (Object)StopAttackingIfTargetInvalid.create(target -> maid.distanceTo((Entity)target) > 8.0f, (mob, livingEntity) -> {}, (boolean)false)), (Object)Pair.of((Object)5, (Object)EraseMemoryIf.create(MaidAi::attackTargetTooFar, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT)), (Set)ImmutableSet.of((Object)MemoryModuleType.ATTACK_TARGET));
    }

    public static boolean attackTargetTooFar(Maid maid) {
        Optional attackTarget = maid.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        return attackTarget.map(livingEntity -> maid.distanceToSqr(livingEntity.position()) > 4.0).orElse(true);
    }

    private static RunOne<Maid> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)0.25f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)0.3f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void broadcastUniversalAnger(Maid maid, LivingEntity entity) {
        Optional livings = maid.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES);
        livings.ifPresent(v -> v.stream().filter(live -> {
            Maid maidEntity;
            return live instanceof Maid && !(maidEntity = (Maid)((Object)((Object)live))).isTame();
        }).forEach(i -> MaidAi.setAttackTarget((Maid)((Object)((Object)i)), entity)));
    }

    public static void updateActivity(Maid maid) {
        if (maid.isInSittingPose()) {
            maid.getNavigation().stop();
            maid.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
            maid.setTarget(null);
        }
        Brain<Maid> brain = maid.getBrain();
        List running = brain.getRunningBehaviors();
        if (LocalDateTime.now().getSecond() % 5 == 0) {
            // empty if block
        }
        brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
        maid.setAggressive(brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
    }

    private static void setAttackTarget(Maid maid, LivingEntity pTarget) {
        Brain<Maid> brain = maid.getBrain();
        brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        brain.setMemory(MemoryModuleType.ATTACK_TARGET, (Object)pTarget);
    }

    public static void wasHurtBy(Maid maid, LivingEntity entity) {
        Brain<Maid> brain = maid.getBrain();
        brain.eraseMemory(MemoryModuleType.PACIFIED);
        brain.eraseMemory(MemoryModuleType.BREED_TARGET);
        if (!BehaviorUtils.isOtherTargetMuchFurtherAwayThanCurrentAttackTarget((LivingEntity)maid, (LivingEntity)entity, (double)4.0) && Sensor.isEntityAttackable((LivingEntity)maid, (LivingEntity)entity)) {
            MaidAi.setAttackTarget(maid, entity);
            if (!maid.isTame()) {
                MaidAi.broadcastUniversalAnger(maid, entity);
            }
        }
    }

    public static Ingredient getTemptations() {
        return Ingredient.of(ModTags.maidFood);
    }
}

