/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.maid;

import com.google.common.collect.ImmutableMap;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import com.yzqdev.mod.jeanmod.entity.maid.MaidAi;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;

public class MaidBegTask
extends Behavior<Maid> {
    private static final int BEG_DISTANCE = 6;
    private static final int CLOSED_DISTANCE = 2;

    public MaidBegTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, Maid owner) {
        return owner.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).map(list -> list.find(i -> i instanceof Player).filter(LivingEntity::isAlive).filter(e -> e.closerThan((Entity)owner, 6.0)).filter(e -> owner.isWithinRestriction(e.blockPosition())).anyMatch(e -> this.holdTemptationItem(owner, (LivingEntity)e))).orElse(false);
    }

    protected boolean canStillUse(ServerLevel worldIn, Maid entityIn, long gameTimeIn) {
        return this.checkExtraStartConditions(worldIn, entityIn);
    }

    protected boolean timedOut(long gameTime) {
        return false;
    }

    protected void tick(ServerLevel worldIn, Maid maid, long gameTime) {
        Optional flag = maid.getBrain().getMemory(MemoryModuleType.IS_TEMPTED);
        if (flag.isPresent()) {
            maid.setBegging(true);
        }
    }

    protected void stop(ServerLevel worldIn, Maid entityIn, long gameTimeIn) {
        entityIn.setBegging(false);
    }

    private boolean holdTemptationItem(Maid owner, LivingEntity e) {
        return MaidAi.getTemptations().test(e.getMainHandItem());
    }
}

