/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.maid;

import com.google.common.collect.ImmutableMap;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import org.jetbrains.annotations.Nullable;

public class MaidFollowOwnerTask
extends Behavior<Maid> {
    private static final int MAX_TELEPORT_ATTEMPTS_TIMES = 10;
    private final float speedModifier;
    private final int stopDistance;

    public MaidFollowOwnerTask(float speedModifier, int stopDistance) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED));
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
    }

    protected void start(ServerLevel worldIn, Maid maid, long gameTimeIn) {
        LivingEntity owner = maid.getOwner();
        int startDistance = (int)maid.getRestrictRadius() - 2;
        int minTeleportDistance = startDistance + 4;
        if (this.ownerStateConditions(owner) && !maid.closerThan((Entity)owner, startDistance)) {
            if (!maid.closerThan((Entity)owner, minTeleportDistance) && !maid.isInSittingPose()) {
                this.teleportToOwner(maid, owner);
            } else if (!this.ownerIsWalkTarget(maid, owner)) {
                BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (Entity)owner, (float)this.speedModifier, (int)this.stopDistance);
            }
        }
    }

    private void teleportToOwner(Maid maid, LivingEntity owner) {
        BlockPos blockPos = owner.blockPosition();
        for (int i = 0; i < 10; ++i) {
            int x = this.randomIntInclusive(maid.getRandom(), -3, 3);
            int y = this.randomIntInclusive(maid.getRandom(), -1, 1);
            int z = this.randomIntInclusive(maid.getRandom(), -3, 3);
            if (!this.maybeTeleportTo(maid, owner, blockPos.getX() + x, blockPos.getY() + y, blockPos.getZ() + z)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(Maid maid, LivingEntity owner, int x, int y, int z) {
        if (this.teleportTooClosed(owner, x, z)) {
            return false;
        }
        if (!this.canTeleportTo(maid, new BlockPos(x, y, z))) {
            return false;
        }
        maid.moveTo((double)x + 0.5, y, (double)z + 0.5, maid.getYRot(), maid.getXRot());
        maid.getNavigation().stop();
        maid.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        maid.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        maid.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        maid.getBrain().eraseMemory(MemoryModuleType.PATH);
        return true;
    }

    private boolean teleportTooClosed(LivingEntity owner, int x, int z) {
        return Math.abs((double)x - owner.getX()) < 2.0 && Math.abs((double)z - owner.getZ()) < 2.0;
    }

    private boolean canTeleportTo(Maid maid, BlockPos pos) {
        PathType pathNodeType = WalkNodeEvaluator.getPathTypeStatic((Mob)maid, (BlockPos)pos.mutable());
        if (pathNodeType == PathType.WALKABLE) {
            BlockPos blockPos = pos.subtract((Vec3i)maid.blockPosition());
            return maid.level().noCollision((Entity)maid, maid.getBoundingBox().move(blockPos));
        }
        return false;
    }

    private int randomIntInclusive(RandomSource random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    private boolean ownerStateConditions(@Nullable LivingEntity owner) {
        return owner != null && !owner.isSpectator() && !owner.isDeadOrDying();
    }

    private boolean ownerIsWalkTarget(Maid maid, LivingEntity owner) {
        return maid.getBrain().getMemory(MemoryModuleType.WALK_TARGET).map(target -> {
            if (target.getTarget() instanceof EntityTracker) {
                return ((EntityTracker)target.getTarget()).getEntity().equals((Object)owner);
            }
            return false;
        }).orElse(false);
    }
}

