/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.maid;

import com.google.common.collect.ImmutableMap;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import com.yzqdev.mod.jeanmod.entity.maid.MaidCheckRateTask;
import com.yzqdev.mod.jeanmod.item.ModTags;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.common.Tags;

public class MaidHealSelfTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 50;
    private static final int MAX_CHECK_MISSING_HEATH = 2;
    private static final int MAX_PROBABILITY = 5;

    public MaidHealSelfTask() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of());
        this.setMaxCheckRate(50);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Maid maid) {
        if (super.checkExtraStartConditions(serverLevel, maid)) {
            float missingHealth = maid.getMaxHealth() - maid.getHealth();
            return !maid.isSleeping() && missingHealth >= 2.0f;
        }
        return false;
    }

    protected void start(ServerLevel serverLevel, Maid maid, long gameTime) {
        for (InteractionHand hand : InteractionHand.values()) {
            FoodProperties foodProperties;
            ItemStack itemInHand = maid.getItemInHand(hand);
            if (itemInHand.isEmpty() || !itemInHand.is(Tags.Items.FOODS) || (foodProperties = itemInHand.getFoodProperties((LivingEntity)maid)) == null) continue;
            if (hand == InteractionHand.MAIN_HAND) {
                maid.triggerAnim("eat_mainhand_controller", "use_mainhand:eat");
            } else {
                maid.triggerAnim("eat_controller", "use_offhand:eat");
            }
            maid.startUsingItem(hand);
            int nutrition = foodProperties.nutrition();
            float saturation = foodProperties.saturation();
            float total = (float)nutrition + saturation;
            maid.heal(total);
            if (maid.isTame()) {
                maid.addExp(maid, 1);
            }
            return;
        }
        InteractionHand eanHand = InteractionHand.OFF_HAND;
        for (InteractionHand hand : InteractionHand.values()) {
            if (!maid.getItemInHand(hand).isEmpty()) continue;
            eanHand = hand;
            break;
        }
        ItemStack itemInHand = maid.getItemInHand(eanHand);
        boolean hasFood = false;
        SimpleContainer backpackInv = maid.getInventory();
        for (int i = 0; i < backpackInv.getContainerSize(); ++i) {
            ItemStack stack = backpackInv.getItem(i);
            if (stack.isEmpty() || !stack.is(Tags.Items.FOODS)) continue;
            ItemStack handStack = itemInHand.copy();
            maid.setItemInHand(eanHand, stack);
            itemInHand = maid.getItemInHand(eanHand);
            backpackInv.setItem(i, Items.AIR.getDefaultInstance());
            hasFood = true;
            break;
        }
        if (hasFood && itemInHand.is(ModTags.maidFood)) {
            FoodProperties foodProperties = itemInHand.getFoodProperties((LivingEntity)maid);
            if (foodProperties != null) {
                if (eanHand == InteractionHand.MAIN_HAND) {
                    maid.triggerAnim("eat_mainhand_controller", "use_mainhand:eat");
                } else {
                    maid.triggerAnim("eat_controller", "use_offhand:eat");
                }
                maid.startUsingItem(eanHand);
                int nutrition = foodProperties.nutrition();
                float saturation = foodProperties.saturation();
                float total = (float)nutrition + saturation;
                maid.heal(total);
                if (maid.isTame()) {
                    maid.addExp(maid, 1);
                }
            }
            return;
        }
    }
}

