/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.maid;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class MaidHostilesSensor
extends Sensor<LivingEntity> {
    private static final ImmutableMap<EntityType<?>, Float> ACCEPTABLE_DISTANCE_FROM_HOSTILES = ImmutableMap.builder().put((Object)EntityType.CREEPER, (Object)Float.valueOf(8.0f)).build();

    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)MemoryModuleType.NEAREST_HOSTILE);
    }

    protected void doTick(ServerLevel worldIn, LivingEntity entityIn) {
        entityIn.getBrain().setMemory(MemoryModuleType.NEAREST_HOSTILE, this.getNearestHostile(entityIn));
    }

    private Optional<LivingEntity> getNearestHostile(LivingEntity livingEntity) {
        return this.getVisibleEntities(livingEntity).flatMap(entities -> entities.find(enemy -> this.isHostile((LivingEntity)enemy) && this.isClose(livingEntity, (LivingEntity)enemy)).min((enemy1, enemy2) -> this.compareMobDistance(livingEntity, (LivingEntity)enemy1, (LivingEntity)enemy2)));
    }

    private Optional<NearestVisibleLivingEntities> getVisibleEntities(LivingEntity livingEntity) {
        return livingEntity.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }

    private int compareMobDistance(LivingEntity livingEntity, LivingEntity target1, LivingEntity target2) {
        return Mth.floor((double)(target1.distanceToSqr((Entity)livingEntity) - target2.distanceToSqr((Entity)livingEntity)));
    }

    private boolean isClose(LivingEntity livingEntity, LivingEntity target) {
        float distance = ((Float)ACCEPTABLE_DISTANCE_FROM_HOSTILES.get((Object)target.getType())).floatValue();
        return target.closerThan((Entity)livingEntity, (double)distance);
    }

    private boolean isHostile(LivingEntity livingEntity) {
        return ACCEPTABLE_DISTANCE_FROM_HOSTILES.containsKey((Object)livingEntity.getType());
    }
}

