/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.maid;

import com.google.common.collect.ImmutableSet;
import com.yzqdev.mod.jeanmod.entity.ModSensorTypes;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.phys.AABB;

public class MaidPickupEntitiesSensor
extends Sensor<Maid> {
    private static final int VERTICAL_SEARCH_RANGE = 4;

    public MaidPickupEntitiesSensor() {
        super(30);
    }

    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)((MemoryModuleType)ModSensorTypes.VISIBLE_PICKUP_ENTITIES.get()));
    }

    protected void doTick(ServerLevel worldIn, Maid maid) {
        float radius = maid.getRestrictRadius();
        AABB aabb = maid.hasRestriction() ? new AABB(maid.getRestrictCenter()).inflate((double)radius, 4.0, (double)radius) : maid.getBoundingBox().inflate((double)radius, 4.0, (double)radius);
        List allEntities = worldIn.getEntitiesOfClass(Entity.class, aabb, Entity::isAlive);
        allEntities.sort(Comparator.comparingDouble(arg_0 -> ((Maid)maid).distanceToSqr(arg_0)));
        List optional = allEntities.stream().filter(e -> e.closerThan((Entity)maid, (double)(radius + 1.0f))).filter(e -> maid.isWithinRestriction(e.blockPosition())).filter(arg_0 -> ((Maid)maid).hasLineOfSight(arg_0)).collect(Collectors.toList());
        maid.getBrain().setMemory((MemoryModuleType)ModSensorTypes.VISIBLE_PICKUP_ENTITIES.get(), optional);
    }
}

