/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.maid;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.yzqdev.mod.jeanmod.entity.ModSensorTypes;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.ItemEntity;

public class MaidPickupEntitiesTask
extends Behavior<Maid> {
    private final Predicate<Maid> predicate;
    private final float speedModifier;

    public MaidPickupEntitiesTask(float speedModifier) {
        this((Predicate<Maid>)Predicates.alwaysTrue(), speedModifier);
    }

    public MaidPickupEntitiesTask(Predicate<Maid> predicate, float speedModifier) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)ModSensorTypes.VISIBLE_PICKUP_ENTITIES.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
        this.predicate = predicate;
        this.speedModifier = speedModifier;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, Maid owner) {
        return this.predicate.test(owner);
    }

    protected void start(ServerLevel worldIn, Maid maid, long gameTimeIn) {
        this.getItems(maid).stream().filter(e -> maid.isWithinRestriction(e.blockPosition()) && e instanceof ItemEntity && !e.isInWater()).findFirst().ifPresent(e -> BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (Entity)e, (float)this.speedModifier, (int)0));
    }

    private List<Entity> getItems(Maid maid) {
        return maid.getBrain().getMemory((MemoryModuleType)ModSensorTypes.VISIBLE_PICKUP_ENTITIES.get()).orElse(Lists.newArrayList());
    }
}

