/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.event;

import com.github.tartaricacid.touhoulittlemaid.entity.monster.EntityFairy;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.blaze3d.audio.SoundBuffer;
import com.mojang.brigadier.CommandDispatcher;
import com.yzqdev.mod.jeanmod.command.RootCommand;
import com.yzqdev.mod.jeanmod.datagen.LangDefinition;
import com.yzqdev.mod.jeanmod.entity.elf.EntityElf;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import com.yzqdev.mod.jeanmod.inventory.golem.GolemInventoryScreenHandler;
import com.yzqdev.mod.jeanmod.item.ModItems;
import com.yzqdev.mod.jeanmod.sound.MaidSoundInstance;
import com.yzqdev.mod.jeanmod.sound.human.HumanSoundInstance;
import com.yzqdev.mod.jeanmod.util.GlobalHelper;
import com.yzqdev.mod.jeanmod.util.SlimeEvent;
import com.yzqdev.mod.jeanmod.worldgen.VillageStructures;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.sound.PlaySoundSourceEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="jean")
public class GameEvent {
    @SubscribeEvent
    public static void addNewVillageBuilding(ServerAboutToStartEvent event) {
        List<ResourceLocation> VILLAGE_REPLACEMENT_POOLS = List.of(ResourceLocation.parse((String)"minecraft:village/plains/houses"), ResourceLocation.parse((String)"minecraft:village/desert/houses"), ResourceLocation.parse((String)"minecraft:village/savanna/houses"), ResourceLocation.parse((String)"minecraft:village/snowy/houses"), ResourceLocation.parse((String)"minecraft:village/taiga/houses"));
        Registry templatePools = (Registry)event.getServer().registryAccess().registry(Registries.TEMPLATE_POOL).get();
        Registry processorLists = (Registry)event.getServer().registryAccess().registry(Registries.PROCESSOR_LIST).get();
        VILLAGE_REPLACEMENT_POOLS.forEach(i -> VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, i, "jean:maid_enchant", 3));
    }

    @SubscribeEvent
    public static void onCanPlayerSleep(CanPlayerSleepEvent event) {
        if (event.getProblem() != Player.BedSleepingProblem.NOT_SAFE) {
            return;
        }
        ServerPlayer serverPlayer = event.getEntity();
        ServerLevel serverLevel = serverPlayer.serverLevel();
        Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)event.getPos());
        double hRadius = 8.0;
        double yRadius = 5.0;
        List monsters = serverLevel.getEntitiesOfClass(Monster.class, new AABB(vec3.x() - hRadius, vec3.y() - yRadius, vec3.z() - hRadius, vec3.x() + hRadius, vec3.y() + yRadius, vec3.z() + hRadius), monster -> monster.isPreventingPlayerRest((Player)serverPlayer));
        if (monsters != null && !monsters.isEmpty()) {
            int ticks = 200;
            for (Monster monster2 : monsters) {
                monster2.addEffect(new MobEffectInstance(MobEffects.GLOWING, ticks));
            }
        }
    }

    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        CommandBuildContext context = event.getBuildContext();
        RootCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), context);
    }

    @SubscribeEvent
    public static void smeltingItem(FurnaceFuelBurnTimeEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.getItem().equals(ModItems.BAMBOO_COAL.get())) {
            event.setBurnTime(200);
        }
    }

    @SubscribeEvent
    public static void notRain(ServerTickEvent.Post event) {
        if (GlobalHelper.isDevelopmentEnvironment()) {
            event.getServer().getAllLevels().forEach(level -> {
                if (level.isRaining()) {
                    level.setWeatherParameters(0, 0, false, false);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onWorldJoin(EntityJoinLevelEvent e) {
        Player player;
        Entity entity = e.getEntity();
        if (entity instanceof Player) {
            player = (Player)entity;
            int duration = 86400000;
            if (GlobalHelper.isDevelopmentEnvironment()) {
                player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, duration));
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, duration, 255));
                player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, duration, 2));
                player.addEffect(new MobEffectInstance(MobEffects.SATURATION, duration, 255));
            }
        }
        if (!SlimeEvent.onWorldJoin(e.getLevel(), e.getEntity())) {
            e.setCanceled(true);
        }
        if ((entity = e.getEntity()) instanceof Zombie) {
            player = (Zombie)entity;
        }
        if ((entity = e.getEntity()) instanceof EntityFairy) {
            EntityFairy entityFairy = (EntityFairy)entity;
            entityFairy.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)entityFairy, new Class[0]));
        }
        if (e.getEntity() instanceof EntityElf) {
            e.getEntity().sendSystemMessage((Component)Component.translatable((String)LangDefinition.elf_appear));
        }
    }

    @SubscribeEvent
    public static void EntityDieEvt(LivingDeathEvent event) {
        Maid animal;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Maid) {
            Maid maid = (Maid)livingEntity;
        }
        if ((livingEntity = event.getSource().getEntity()) instanceof Maid && (animal = (Maid)livingEntity).isTame()) {
            LivingEntity target = event.getEntity();
            int exp = (int)target.getMaxHealth() / 20;
            animal.addExp(animal, exp);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onEntityAttack(LivingIncomingDamageEvent event) {
        LivingEntity target = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        if (attacker instanceof TamableAnimal && target instanceof TamableAnimal) {
            TamableAnimal attackerTame = (TamableAnimal)attacker;
            TamableAnimal targetTame = (TamableAnimal)target;
            if (attackerTame.isTame() && targetTame.isTame() && attackerTame.getOwner() == targetTame.getOwner()) {
                event.setCanceled(true);
            }
        }
        if (attacker instanceof Player) {
            ResourceLocation key;
            Player player = (Player)attacker;
            Item item = player.getMainHandItem().getItem();
            if (item == ModItems.COPY_ID_ITEM.get()) {
                key = BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getType());
                if (key == null) {
                    return;
                }
                Minecraft.getInstance().keyboardHandler.setClipboard(key.toString());
                player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.get_entity_id).append((Component)Component.literal((String)key.toString())));
            }
            if (player.level().isClientSide && FMLEnvironment.dist == Dist.CLIENT && item == ModItems.COPY_ID_ITEM.get()) {
                key = BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getType());
                if (key == null) {
                    return;
                }
                Minecraft.getInstance().keyboardHandler.setClipboard(key.toString());
                player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.get_entity_id).append((Component)Component.literal((String)key.toString())));
            }
        }
    }

    @SubscribeEvent
    public static void clickItem(LivingEntityUseItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            boolean flag;
            Player player = (Player)livingEntity;
            boolean bl = flag = player.getMainHandItem().getItem() == ModItems.COPY_ID_ITEM.get();
            if (flag) {
                // empty if block
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractBlock(PlayerInteractEvent.RightClickBlock event) {
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        HitResult result = player.pick(5.0, 0.0f, false);
        if (result.getType() == HitResult.Type.ENTITY || result.getType() == HitResult.Type.BLOCK) {
            if (event.getItemStack().is(ModItems.CHAIR_ME_ITEM)) {
                event.setCanceled(true);
            }
        } else {
            System.out.println(result.getType().toString());
            ItemStack itemStack = event.getItemStack();
        }
    }

    @SubscribeEvent
    public static void leftClick(PlayerInteractEvent.LeftClickEmpty event) {
        Player player = event.getEntity();
        ItemStack itemStack = player.getMainHandItem();
        if (itemStack.getItem() == ModItems.COPY_ID_ITEM.get()) {
            System.out.println(player.getName().getString() + " left-clicked with the item!");
        }
    }

    @SubscribeEvent
    public static void copyEntityId(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        Entity target = event.getTarget();
        Level level = player.level();
        ItemStack item = event.getItemStack();
        Player user = event.getEntity();
        if (player.getItemInHand(hand).is((Item)ModItems.COPY_ID_ITEM.get())) {
            if (player.level().isClientSide && FMLEnvironment.dist == Dist.CLIENT) {
                Minecraft.getInstance().execute(() -> GameEvent.copyEntityId(player, target));
            }
            event.setCanceled(true);
        }
        if (!player.level().isClientSide()) {
            ServerPlayer serverPlayer;
            Object maid;
            if (target instanceof EntityMaid) {
                maid = (EntityMaid)target;
                if (item.is(ModItems.EXP_BOTTLE)) {
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.PASS);
                    int exp = maid.getExperience();
                    player.giveExperiencePoints(exp);
                    maid.setExperience(0);
                }
            }
            if (!player.isSpectator() && !target.isRemoved() && target instanceof IronGolem) {
                IronGolem ironGolem = (IronGolem)target;
                if (player.isShiftKeyDown() && player.getItemInHand(hand).is(Items.IRON_INGOT) && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer2 = (ServerPlayer)player;
                    System.out.println("\u70b9\u51fb\u94c1\u5080\u5121");
                    serverPlayer2.openMenu(GolemInventoryScreenHandler.createMenuProvider(ironGolem), buf -> buf.writeInt(ironGolem.getId()));
                    event.setCanceled(true);
                }
            }
            if (player.getItemInHand(hand).is((Item)ModItems.RELEASE_PET_ITEM.get()) && target instanceof TamableAnimal) {
                TamableAnimal tamableAnimal = (TamableAnimal)target;
                tamableAnimal.setTame(false, false);
                tamableAnimal.setOwnerUUID(null);
                tamableAnimal.setOrderedToSit(false);
                tamableAnimal.setInSittingPose(false);
                event.setCanceled(true);
            }
            if (player.getItemInHand(hand).is(ModItems.CHAIR_ME_ITEM) && player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                boolean success = target.startRiding((Entity)serverPlayer, true);
                player.swing(hand);
                serverPlayer.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)serverPlayer));
                event.setCanceled(true);
            }
            if (player.getItemInHand(hand).is(Items.SADDLE) && player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                serverPlayer.startRiding(target, true);
                serverPlayer.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)serverPlayer));
                event.setCanceled(true);
            }
            if (GlobalHelper.isDevelopmentEnvironment() && target instanceof Maid) {
                maid = (Maid)target;
                if (item.is(Items.STICK)) {
                    ((Maid)((Object)maid)).addExp((TamableAnimal)maid, 50);
                }
                if (item.is(Items.COPPER_INGOT)) {
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.PASS);
                    ((Maid)((Object)maid)).hurt(maid.damageSources().generic(), maid.getHealth() / 2.0f);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void copyEntityId(Player player, Entity target) {
        String uuid = target.getStringUUID();
        Minecraft.getInstance().keyboardHandler.setClipboard(uuid);
        player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.get_entity_uuid).append((Component)Component.literal((String)uuid)));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onPlaySoundSource(PlaySoundSourceEvent event) {
        AbstractTickableSoundInstance instance;
        SoundInstance soundBuffer;
        SoundInstance soundInstance = event.getSound();
        if (soundInstance instanceof MaidSoundInstance && (soundBuffer = (instance = (MaidSoundInstance)soundInstance).getSoundBuffer()) != null) {
            event.getChannel().attachStaticBuffer((SoundBuffer)soundBuffer);
            event.getChannel().play();
        }
        if ((soundBuffer = event.getSound()) instanceof HumanSoundInstance && (soundBuffer = (instance = (HumanSoundInstance)soundBuffer).getSoundBuffer()) != null) {
            event.getChannel().attachStaticBuffer((SoundBuffer)soundBuffer);
            event.getChannel().play();
        }
    }
}

