/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.event;

import com.yzqdev.mod.jeanmod.event.TextIcons;
import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public class TagInstance
implements Comparable<TagInstance> {
    public final ResourceLocation tag;
    public final Set<Type> registries;

    public TagInstance(ResourceLocation tag) {
        this.tag = tag;
        this.registries = new LinkedHashSet<Type>(2);
    }

    public Component toText() {
        StringBuilder sb = new StringBuilder(this.registries.size() + 1);
        sb.append('.');
        for (Type type : this.registries) {
            sb.append(type.character);
        }
        return Component.empty().append((Component)TextIcons.icon(Component.literal((String)"T."))).append((Component)Component.literal((String)("#" + String.valueOf(this.tag))).withStyle(ChatFormatting.DARK_GRAY)).append((Component)TextIcons.icon(Component.literal((String)sb.toString())));
    }

    @Override
    public int compareTo(@NotNull TagInstance o) {
        return this.tag.compareNamespaced(o.tag);
    }

    public static enum Type {
        BLOCK('B'),
        ITEM('J'),
        FLUID('F'),
        ENTITY('E');

        public final char character;

        private Type(char c) {
            this.character = c;
        }

        public void append(Map<ResourceLocation, TagInstance> map, Stream<? extends TagKey<?>> tags) {
            tags.forEach(tag -> map.computeIfAbsent(tag.location(), (Function<ResourceLocation, TagInstance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lcom/yzqdev/mod/jeanmod/event/TagInstance;)()).registries.add(this));
        }
    }
}

