/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.inventory;

import com.yzqdev.mod.jeanmod.inventory.ISwingAttack;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;

public class SwingAttackGoal<T extends Mob>
extends Goal {
    private static final Predicate<Entity> iMobTarget = p_213685_0_ -> !(p_213685_0_ instanceof IronGolem);
    private final T mobEntity;
    private int attackingTimer;
    private int cooldownTimer = -1;

    public SwingAttackGoal(T mobEntity) {
        this.mobEntity = mobEntity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity livingEntity;
        if (this.cooldownTimer > 0) {
            --this.cooldownTimer;
        }
        if ((livingEntity = this.mobEntity.getTarget()) != null && livingEntity.isAlive() && this.cooldownTimer <= 0 && livingEntity.distanceToSqr(this.mobEntity) < 32.0 && livingEntity.onGround()) {
            this.cooldownTimer = 100 + this.mobEntity.getRandom().nextInt(100);
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return (float)this.attackingTimer < 25.0f;
    }

    public void start() {
        super.start();
        ((ISwingAttack)this.mobEntity).setSwingAttack(true);
        this.attackingTimer = 0;
        this.mobEntity.level().broadcastEntityEvent(this.mobEntity, (byte)64);
    }

    public void stop() {
        super.stop();
        ((ISwingAttack)this.mobEntity).setSwingAttack(false);
    }

    public void tick() {
        super.tick();
        ++this.attackingTimer;
        if ((float)this.attackingTimer == 5.0f) {
            this.groundAttack();
        }
    }

    private void groundAttack() {
        LivingEntity livingEntity = this.mobEntity.getTarget();
        if (this.mobEntity.onGround()) {
            this.mobEntity.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 1.4f, 1.4f);
            this.mobEntity.playSound(SoundEvents.IRON_GOLEM_ATTACK, 1.0f, 1.0f);
            for (Entity entity : this.mobEntity.level().getEntitiesOfClass(LivingEntity.class, this.mobEntity.getBoundingBox().inflate(8.0), iMobTarget)) {
                boolean flag;
                if (entity instanceof Creeper || !(entity instanceof Enemy) && (livingEntity == null || livingEntity != entity)) continue;
                if (entity.onGround() && (flag = entity.hurt(this.mobEntity.damageSources().mobAttack(this.mobEntity), (float)this.mobEntity.getAttributeValue(Attributes.ATTACK_DAMAGE) * 0.75f))) {
                    entity.getDeltaMovement().add(0.0, (double)0.4f, 0.0);
                }
                this.launch(entity);
            }
        }
    }

    private void launch(Entity p_33340_) {
        double d0 = p_33340_.getX() - this.mobEntity.getX();
        double d1 = p_33340_.getZ() - this.mobEntity.getZ();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        p_33340_.push(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

