/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.inventory.golem;

import com.yzqdev.mod.jeanmod.inventory.golem.GolemInventoryScreenHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class GolemInventoryScreen
extends AbstractContainerScreen<GolemInventoryScreenHandler> {
    private static final ResourceLocation VILLAGER_INVENTORY_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/container/horse.png");
    private static final ResourceLocation CHEST_SLOTS_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/horse/chest_slots");
    private final IronGolem ironGolem;
    private float xMouse;
    private float yMouse;

    public GolemInventoryScreen(GolemInventoryScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, handler.ironGolem.getDisplayName());
        this.ironGolem = handler.ironGolem;
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        context.blit(VILLAGER_INVENTORY_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
        int s = ((GolemInventoryScreenHandler)this.menu).ironGolemInventory.getContainerSize();
        int inventoryColumns = 4;
        context.blitSprite(CHEST_SLOTS_SPRITE, 90, 54, 0, 0, i + 88, j + 26, inventoryColumns * 18, 36);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)context, (int)(i + 26), (int)(j + 18), (int)(i + 78), (int)(j + 70), (int)17, (float)0.25f, (float)this.xMouse, (float)this.yMouse, (LivingEntity)this.ironGolem);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        this.xMouse = mouseX;
        this.yMouse = mouseY;
        super.render(context, mouseX, mouseY, delta);
        this.renderTooltip(context, mouseX, mouseY);
    }
}

