/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.inventory.maid;

import com.mojang.datafixers.util.Pair;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import com.yzqdev.mod.jeanmod.inventory.ModMenus;
import com.yzqdev.mod.jeanmod.inventory.maid.MaidInventoryScreen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaidScreenHandler
extends AbstractContainerMenu {
    public Maid maid;
    public double attackDamage;
    private static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS, InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS, InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE, InventoryMenu.EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public MaidScreenHandler(int syncId, Inventory inventory, FriendlyByteBuf buf) {
        this(syncId, inventory, buf.readInt(), buf.readDouble());
    }

    public MaidScreenHandler(int syncId, Inventory playerInventory, int maidId, double attackDamage) {
        super((MenuType)ModMenus.MaidInventory.get(), syncId);
        Entity entity = playerInventory.player.level().getEntity(maidId);
        this.maid = (Maid)entity;
        this.attackDamage = attackDamage;
        SimpleContainer armorInventory = this.maid.getArmorInv();
        this.addSlot(new MaidHeldItemSlot(this, -53, 18));
        int rightBorder = -35;
        this.addSlot(new MaidOffhandSlot(this, rightBorder, 18));
        int leftMove = -61;
        this.addSlot(new MaidEquipSlot((Container)armorInventory, 0, leftMove + 8, 35, EquipmentSlot.HEAD));
        this.addSlot(new MaidEquipSlot((Container)armorInventory, 1, leftMove + 8 + 18, 35, EquipmentSlot.CHEST));
        this.addSlot(new MaidEquipSlot((Container)armorInventory, 2, leftMove + 8, 53, EquipmentSlot.LEGS));
        this.addSlot(new MaidEquipSlot((Container)armorInventory, 3, leftMove + 8 + 18, 53, EquipmentSlot.FEET));
        for (int i = 0; i < 4; ++i) {
            EquipmentSlot equipmentSlot = SLOT_IDS[i];
        }
        SimpleContainer inventory2 = this.maid.getInventory();
        int size = inventory2.getContainerSize();
        for (int i = 0; i < 8 && (i + 1) * 9 <= size; ++i) {
            for (int j = 0; j < 9 && i * 9 + j + 1 <= size; ++j) {
                this.addSlot(new Slot((Container)inventory2, i * 9 + j, 12 + j * 18, -36 + i * 18));
            }
        }
        for (int m = 0; m < 3; ++m) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + m * 9 + 9, 12 + l * 18, 120 + m * 18));
            }
        }
        for (int var14 = 0; var14 < 9; ++var14) {
            this.addSlot(new Slot((Container)playerInventory, var14, 12 + var14 * 18, 178));
        }
        this.addSlotListener(new ContainerListener(){

            public void slotChanged(AbstractContainerMenu handler, int slotId, ItemStack itemStack) {
                switch (slotId) {
                    case 0: {
                        MaidScreenHandler.this.maid.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
                        break;
                    }
                    case 1: {
                        MaidScreenHandler.this.maid.setItemSlot(EquipmentSlot.OFFHAND, itemStack);
                        break;
                    }
                    case 5: {
                        MaidScreenHandler.this.maid.setItemSlot(EquipmentSlot.FEET, itemStack);
                        break;
                    }
                    case 2: {
                        MaidScreenHandler.this.maid.setItemSlot(EquipmentSlot.HEAD, itemStack);
                        break;
                    }
                    case 3: {
                        MaidScreenHandler.this.maid.setItemSlot(EquipmentSlot.CHEST, itemStack);
                        break;
                    }
                    case 4: {
                        MaidScreenHandler.this.maid.setItemSlot(EquipmentSlot.LEGS, itemStack);
                    }
                }
            }

            public void dataChanged(AbstractContainerMenu handler, int property, int value) {
            }
        });
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack clickedStack = slot.getItem();
            itemStack = clickedStack.copy();
            int inventorySize = this.maid.getInventory().getContainerSize();
            int armorSize = this.maid.getArmorInv().getContainerSize();
            int maidSize = inventorySize + armorSize + 2;
            if (index >= 0 && index < maidSize) {
                if (!this.moveItemStackTo(clickedStack, 78, 113, false)) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (index >= 78 && index <= 113 && !this.moveItemStackTo(clickedStack, 6, 78, false)) {
                if (index < 105 && !this.moveItemStackTo(clickedStack, 105, 113, false)) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(clickedStack, 105, 113, false)) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (clickedStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public boolean stillValid(Player player) {
        return this.maid.getInventory().stillValid(player) && this.maid.isAlive() && this.maid.distanceTo((Entity)player) < 8.0f;
    }

    private class MaidHeldItemSlot
    extends Slot {
        public MaidHeldItemSlot(MaidScreenHandler maidScreenHandler, int x, int y) {
            super((Container)new SimpleContainer(1), 0, x, y);
            this.setByPlayer(maidScreenHandler.maid.getMainHandItem());
        }

        @OnlyIn(value=Dist.CLIENT)
        @Nullable
        public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
            return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)MaidInventoryScreen.EMPTY_HELD_SLOT_TEXTURE);
        }
    }

    private class MaidOffhandSlot
    extends Slot {
        public MaidOffhandSlot(MaidScreenHandler maidScreenHandler, int x, int y) {
            super((Container)new SimpleContainer(1), 0, x, y);
            this.setByPlayer(maidScreenHandler.maid.getOffhandItem());
        }

        @OnlyIn(value=Dist.CLIENT)
        @Nullable
        public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
            return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
        }
    }

    private class MaidEquipSlot
    extends Slot {
        private EquipmentSlot equipmentSlot;

        public MaidEquipSlot(Container container, int slot, int x, int y, EquipmentSlot equipmentSlot) {
            super(container, slot, x, y);
            this.equipmentSlot = equipmentSlot;
            this.setByPlayer(MaidScreenHandler.this.maid.getItemBySlot(equipmentSlot));
        }

        public int getMaxStackSize() {
            return 1;
        }

        public boolean mayPlace(ItemStack itemStack) {
            return itemStack.canEquip(this.equipmentSlot, (LivingEntity)MaidScreenHandler.this.maid) && itemStack.getItem().canFitInsideContainerItems();
        }

        public boolean mayPickup(Player playerIn) {
            ItemStack itemstack = this.getItem();
            boolean curseEnchant = !itemstack.isEmpty() && !playerIn.isCreative() && EnchantmentHelper.hasTag((ItemStack)itemstack, (TagKey)EnchantmentTags.CURSE);
            return !curseEnchant && super.mayPickup(playerIn);
        }

        public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
            return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)TEXTURE_EMPTY_SLOTS[this.equipmentSlot.getIndex()]);
        }
    }
}

