/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.item;

import com.yzqdev.mod.jeanmod.datagen.LangDefinition;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;

public class CopyIdItem
extends Item {
    public CopyIdItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        HitResult target = this.getEntityHitResult(player, level);
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player.level().isClientSide && FMLEnvironment.dist == Dist.CLIENT) {
            ItemStack itemStack = context.getItemInHand();
            if (player == null) {
                return InteractionResult.FAIL;
            }
            BlockState blockState = level.getBlockState(context.getClickedPos());
            Block block = blockState.getBlock();
            ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
            Minecraft.getInstance().keyboardHandler.setClipboard(blockId.toString());
            player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.get_block_id).append((Component)Component.literal((String)blockId.toString())));
        }
        return InteractionResult.SUCCESS;
    }

    private HitResult getEntityHitResult(Player player, Level level) {
        Vec3 playerPosition = player.getEyePosition();
        Vec3 lookDirection = player.getViewVector(1.0f);
        double range = 5.0;
        return player.pick(range, 1.0f, false);
    }
}

