/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.item;

import com.yzqdev.mod.jeanmod.Config;
import com.yzqdev.mod.jeanmod.datagen.LangDefinition;
import com.yzqdev.mod.jeanmod.util.GlobalHelper;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;

public class OreCleanerItem
extends Item {
    private static final int COOLDOWN_TICKS = 5;
    private static final List<TagKey<Block>> PROTECTED_TAGS = List.of(BlockTags.BEDS, BlockTags.DOORS, BlockTags.ANVIL, Tags.Blocks.CHESTS);
    private static final Set<Block> PROTECTED_BLOCKS = Set.of(Blocks.SPAWNER, Blocks.BEACON, Blocks.ENDER_CHEST, Blocks.BEDROCK, Blocks.BONE_BLOCK, Blocks.AMETHYST_BLOCK);

    public OreCleanerItem() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        int CLEAR_RADIUS = Config.oreCleanRadius;
        if (!level.isClientSide() && player.isCreative() && GlobalHelper.isDevelopmentEnvironment()) {
            BlockPos playerPos = player.blockPosition();
            BlockPos minPos = playerPos.offset(-CLEAR_RADIUS, -CLEAR_RADIUS, -CLEAR_RADIUS);
            BlockPos maxPos = playerPos.offset(CLEAR_RADIUS, CLEAR_RADIUS, CLEAR_RADIUS);
            TagKey oreTag = Tags.Blocks.ORES;
            int blocksCleared = 0;
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos)) {
                BlockState state = level.getBlockState(pos);
                if (state.isAir() || this.isOreBlock(state, (TagKey<Block>)oreTag) || this.isProtectedBlock(state)) continue;
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                ++blocksCleared;
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                this.addCleaningParticles(serverLevel, pos);
            }
            player.getCooldowns().addCooldown((Item)this, 5);
            if (!player.isCreative()) {
                itemStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.block_cleard, (Object[])new Object[]{blocksCleared}));
        }
        level.playSound(null, player.getOnPos(), SoundEvents.ENDER_EYE_LAUNCH, SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    private boolean isOreBlock(BlockState state, TagKey<Block> oreTag) {
        return state.is(oreTag) || state.is(Tags.Blocks.ORES) || BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).getPath().contains("ore");
    }

    private boolean isProtectedBlock(BlockState state) {
        return PROTECTED_TAGS.stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0)) || PROTECTED_BLOCKS.contains(state.getBlock());
    }

    private void addCleaningParticles(ServerLevel level, BlockPos pos) {
        if (level.isClientSide) {
            RandomSource random = level.random;
            for (int i = 0; i < 5; ++i) {
                level.sendParticles((ParticleOptions)ParticleTypes.CLOUD, (double)pos.getX() + 0.5 + random.nextDouble() - 0.5, (double)pos.getY() + 0.5 + random.nextDouble() - 0.5, (double)pos.getZ() + 0.5 + random.nextDouble() - 0.5, 1, 0.05, 0.0, 0.0, 0.05);
            }
        }
    }
}

