/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.mixin;

import com.yzqdev.mod.jeanmod.inventory.GolemHealGoal;
import com.yzqdev.mod.jeanmod.inventory.GolemHealTask;
import com.yzqdev.mod.jeanmod.inventory.ISwingAttack;
import com.yzqdev.mod.jeanmod.inventory.SwingAttackGoal;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={IronGolem.class})
public abstract class MixinIronGolemEntity
extends AbstractGolem
implements ISwingAttack,
InventoryCarrier,
GolemHealTask {
    @Unique
    private final SimpleContainer inventory = new SimpleContainer(8);
    @Unique
    private boolean swingAttack;
    @Unique
    private AnimationState slamAnimationState = new AnimationState();

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public MixinIronGolemEntity(EntityType<? extends AbstractGolem> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    protected void registerGoals(CallbackInfo callbackInfo) {
        this.goalSelector.addGoal(0, new SwingAttackGoal<MixinIronGolemEntity>(this));
        this.goalSelector.addGoal(0, (Goal)new GolemHealGoal(this));
    }

    public void tick() {
        super.tick();
    }

    @Override
    public void setSwingAttack(boolean attack) {
        this.swingAttack = attack;
    }

    @Override
    public boolean isSwingAttack() {
        return this.swingAttack;
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="HEAD")}, cancellable=true)
    public void handleEntityEvent(byte p_28844_, CallbackInfo ci) {
        if (p_28844_ == 64) {
            this.slamAnimationState().start(this.tickCount);
            ci.cancel();
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    public void defineSynchedDatamixin(SynchedEntityData.Builder builder, CallbackInfo ci) {
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAddData(CompoundTag compound, CallbackInfo ci) {
        this.readInventoryFromTag(compound, (HolderLookup.Provider)this.registryAccess());
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void writeAddData(CompoundTag compound, CallbackInfo ci) {
        this.writeInventoryToTag(compound, (HolderLookup.Provider)this.registryAccess());
    }

    @Override
    public int getIronIngotNum() {
        int ingotNum = 0;
        for (int i = 0; i < this.getInventory().getContainerSize(); ++i) {
            ItemStack itemStack = this.getInventory().getItem(i);
            if (itemStack.isEmpty()) continue;
            ingotNum += itemStack.getCount();
        }
        return ingotNum;
    }

    @Override
    public void golemHealSelf() {
        this.heal(25.0f);
        this.inventory.removeItemType(Items.IRON_INGOT, 1);
        this.playSound(SoundEvents.IRON_GOLEM_REPAIR, 1.0f, 1.0f);
        this.swing(InteractionHand.MAIN_HAND);
    }

    @Override
    public AnimationState slamAnimationState() {
        return this.slamAnimationState;
    }
}

