/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.network;

import com.yzqdev.mod.jeanmod.entity.human.Human;
import com.yzqdev.mod.jeanmod.sound.human.HumanSoundInstance;
import com.yzqdev.mod.jeanmod.util.GlobalHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PlayHumanSoundPackage(ResourceLocation soundEvent, String id, int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayHumanSoundPackage> TYPE = new CustomPacketPayload.Type(GlobalHelper.id("play_human_sound"));
    public static final StreamCodec<ByteBuf, PlayHumanSoundPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, PlayHumanSoundPackage::soundEvent, (StreamCodec)ByteBufCodecs.STRING_UTF8, PlayHumanSoundPackage::id, (StreamCodec)ByteBufCodecs.VAR_INT, PlayHumanSoundPackage::entityId, PlayHumanSoundPackage::new);

    public static void handle(PlayHumanSoundPackage message, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> PlayHumanSoundPackage.playSound(message));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void playSound(PlayHumanSoundPackage message) {
        Entity entity;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && (entity = mc.level.getEntity(message.entityId)) instanceof Human) {
            Human human = (Human)entity;
            SoundEvent event = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(message.soundEvent);
            if (event != null) {
                mc.getSoundManager().play((SoundInstance)new HumanSoundInstance(message.id, human));
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

