/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.sound;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.yzqdev.mod.jeanmod.JeanMod;
import com.yzqdev.mod.jeanmod.sound.MaidSoundLoader;
import com.yzqdev.mod.jeanmod.util.GetJarResources;
import com.yzqdev.mod.jeanmod.util.ZipFileCheck;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class MaidPackLoader {
    private static final String CUSTOM_PACK_DIR_NAME = "tlm_custom_pack";
    public static final Path PACK_FOLDER = Paths.get(Minecraft.getInstance().gameDirectory.toURI()).resolve("tlm_custom_pack");
    private static final String DEFAULT_PACK_NAME = "atri_sound_pack-1.0.0.zip";
    private static final Pattern DOMAIN = Pattern.compile("^assets/([\\w.]+)/$");
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();

    public static void initPacks() {
        File packFolder = PACK_FOLDER.toFile();
        if (!packFolder.isDirectory()) {
            try {
                Files.createDirectories(packFolder.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        MaidPackLoader.checkDefaultPack();
        MaidPackLoader.loadPacks(packFolder);
        MaidSoundLoader.sortSoundPack();
    }

    private static void loadPacks(File packFolder) {
        File[] files = packFolder.listFiles((dir, name) -> true);
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.isFile() || !file.getName().endsWith(".zip")) continue;
            try {
                if (ZipFileCheck.isZipFile(file)) {
                    MaidPackLoader.readModelFromZipFile(file);
                    continue;
                }
                JeanMod.LOGGER.error("{} file is corrupt and cannot be loaded.", (Object)file.getName());
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
    }

    public static void readModelFromZipFile(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> iteration = zipFile.entries();
            while (iteration.hasMoreElements()) {
                String filePath = iteration.nextElement().getName();
                Matcher matcher = DOMAIN.matcher(filePath);
                if (!matcher.find()) continue;
                String domain = matcher.group(1);
                MaidSoundLoader.loadSoundPack(zipFile, domain);
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    private static void packName(String zipFileName) {
        String jarDefaultPackPath = String.format("/assets/%s/%s/%s", "jean", CUSTOM_PACK_DIR_NAME, zipFileName);
        GetJarResources.copyTouhouLittleMaidFile(jarDefaultPackPath, PACK_FOLDER, zipFileName);
    }

    private static void checkDefaultPack() {
        MaidPackLoader.packName(DEFAULT_PACK_NAME);
        MaidPackLoader.packName("zhiban-model.zip");
    }
}

