/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.sound;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.yzqdev.mod.jeanmod.JeanMod;
import com.yzqdev.mod.jeanmod.sound.DefaultPackConstant;
import com.yzqdev.mod.jeanmod.sound.MaidPackLoader;
import com.yzqdev.mod.jeanmod.sound.ModSoundEvents;
import com.yzqdev.mod.jeanmod.sound.SoundCache;
import com.yzqdev.mod.jeanmod.sound.SoundConstant;
import com.yzqdev.mod.jeanmod.sound.SoundData;
import com.yzqdev.mod.jeanmod.sound.SoundPackInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.sounds.JOrbisAudioStream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;

public class MaidSoundLoader {
    public static final Map<String, SoundCache> CACHE = Maps.newLinkedHashMap();
    private static final Marker MARKER = MarkerManager.getMarker((String)"CustomSoundLoader");
    private static final String JSON_FILE_NAME = "maid_sound.json";

    public static void clear() {
        CACHE.clear();
    }

    public static SoundCache getSoundCache(String id) {
        return CACHE.get(id);
    }

    public static void sortSoundPack() {
        LinkedHashMap sortPacks = Maps.newLinkedHashMap();
        for (String id2 : DefaultPackConstant.SOUND_SORT) {
            if (!CACHE.containsKey(id2)) continue;
            sortPacks.put(id2, CACHE.get(id2));
        }
        CACHE.keySet().stream().filter(id -> !DefaultPackConstant.SOUND_SORT.contains(id)).sorted(String::compareTo).forEach(key -> sortPacks.put(key, CACHE.get(key)));
        CACHE.clear();
        CACHE.putAll(sortPacks);
    }

    public static void loadSoundPack(Path rootPath, String id) {
        File file = rootPath.resolve("assets").resolve(id).resolve(JSON_FILE_NAME).toFile();
        if (!file.isFile()) {
            return;
        }
        JeanMod.LOGGER.debug("Loading {} sound pack: ", (Object)id);
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            SoundPackInfo info = (SoundPackInfo)MaidPackLoader.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), new TypeToken<SoundPackInfo>(){}.getType());
            info.decorate();
            Path soundsFolder = rootPath.resolve("assets").resolve(id).resolve("sounds").resolve("maid");
            SoundCache soundCache = new SoundCache(MaidSoundLoader.loadSoundEvent(soundsFolder));
            CACHE.put(id, soundCache);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            JeanMod.LOGGER.warn("Fail to parse sound pack in id {}", (Object)id);
            e.printStackTrace();
        }
        JeanMod.LOGGER.debug("Loaded {} sound pack.", (Object)id);
    }

    private static Map<ResourceLocation, List<SoundData>> loadSoundEvent(Path rootPath) {
        LinkedHashMap buffers = Maps.newLinkedHashMap();
        buffers.put(((SoundEvent)ModSoundEvents.MAID_IDLE.get()).getLocation(), MaidSoundLoader.loadSounds(rootPath.resolve("mode"), "idle"));
        return buffers;
    }

    private static List<SoundData> loadSounds(Path rootPath, String fileName) {
        ArrayList sounds = Lists.newArrayList();
        File[] files = rootPath.toFile().listFiles((dir, name) -> SoundConstant.checkFileName(fileName, name));
        if (files == null) {
            return sounds;
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);
                 JOrbisAudioStream audioStream = new JOrbisAudioStream(stream);){
                ByteBuffer bytebuffer = audioStream.readAll();
                sounds.add(new SoundData(bytebuffer, audioStream.getFormat()));
                JeanMod.LOGGER.debug(MARKER, "sound: {}", (Object)file.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sounds;
    }

    private static void reuseSounds(Map<ResourceLocation, List<SoundData>> buffers, SoundEvent from, SoundEvent to) {
        List<SoundData> fromBuffers = buffers.get(from.getLocation());
        buffers.get(to.getLocation()).addAll(fromBuffers);
    }

    public static void loadSoundPack(ZipFile zipFile, String id) {
        ZipEntry entry = zipFile.getEntry(String.format("assets/%s/%s", id, JSON_FILE_NAME));
        if (entry == null) {
            return;
        }
        JeanMod.LOGGER.debug("Loading {} sound pack: ", (Object)id);
        try (InputStream stream = zipFile.getInputStream(entry);){
            SoundPackInfo info = (SoundPackInfo)MaidPackLoader.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), new TypeToken<SoundPackInfo>(){}.getType());
            info.decorate();
            SoundCache soundCache = new SoundCache(MaidSoundLoader.loadSoundEvent(zipFile, id));
            CACHE.put(id, soundCache);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            JeanMod.LOGGER.warn("Fail to parse sound pack in id {}", (Object)id);
            e.printStackTrace();
        }
        JeanMod.LOGGER.debug("Loaded {} sound pack.", (Object)id);
    }

    @NotNull
    private static Map<ResourceLocation, List<SoundData>> loadSoundEvent(ZipFile zipFile, String id) {
        LinkedHashMap buffers = Maps.newLinkedHashMap();
        Pattern pattern = Pattern.compile(String.format("assets/%s/sounds/maid/(.*?)/(.*?\\.ogg)", id));
        zipFile.stream().forEach(zipEntry -> {
            String path;
            Matcher matcher;
            if (!zipEntry.isDirectory() && (matcher = pattern.matcher(path = zipEntry.getName())).find()) {
                String subDir = matcher.group(1);
                String fileName = matcher.group(2);
                MaidSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)ModSoundEvents.MAID_IDLE.get(), "mode", "idle");
                MaidSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)ModSoundEvents.MAID_HURT.get(), "ai", "hurt");
                MaidSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)ModSoundEvents.MAID_HURT.get(), "ai", "hurt_fire");
                MaidSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)ModSoundEvents.MAID_PLAYER.get(), "ai", "hurt_player");
                MaidSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)ModSoundEvents.MAID_DEATH.get(), "ai", "death");
                MaidSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)ModSoundEvents.MAID_ITEM_GET.get(), "ai", "item_get");
                MaidSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)ModSoundEvents.MAID_FIND_TARGET.get(), "ai", "find_target");
                MaidSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)ModSoundEvents.MAID_FIND_TARGET.get(), "mode", "attack");
                MaidSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)ModSoundEvents.MAID_FIND_TARGET.get(), "environment", "morning");
                MaidSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)ModSoundEvents.MAID_FIND_TARGET.get(), "environment", "night");
                MaidSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)ModSoundEvents.MAID_FIND_TARGET.get(), "environment", "rain");
                MaidSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)ModSoundEvents.MAID_FIND_TARGET.get(), "environment", "snow");
                MaidSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)ModSoundEvents.MAID_FIND_TARGET.get(), "environment", "code");
                MaidSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)ModSoundEvents.MAID_FIND_TARGET.get(), "environment", "hot");
            }
        });
        return buffers;
    }

    private static void loadSounds(ZipFile zipFile, Map<ResourceLocation, List<SoundData>> buffers, ZipEntry zipEntry, String subDir, String fileName, SoundEvent soundEvent, String checkSubDir, String checkFileName) {
        List sounds = buffers.computeIfAbsent(soundEvent.getLocation(), res -> Lists.newArrayList());
        if (checkSubDir.equals(subDir) && SoundConstant.checkFileName(checkFileName, fileName)) {
            try (InputStream zipEntryStream = zipFile.getInputStream(zipEntry);
                 JOrbisAudioStream audioStream = new JOrbisAudioStream(zipEntryStream);){
                ByteBuffer bytebuffer = audioStream.readAll();
                sounds.add(new SoundData(bytebuffer, audioStream.getFormat()));
                JeanMod.LOGGER.debug(MARKER, "sound: {}", (Object)fileName);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

