/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.util;

import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import java.util.Comparator;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class MobUtil {
    public static Maid getNearestPlayerMaid(Player player, int radius) {
        Level level = player.level();
        return level.getEntitiesOfClass(Maid.class, player.getBoundingBox().inflate((double)radius)).stream().filter(entity -> entity.isAlive() && !entity.isRemoved()).min(Comparator.comparingDouble(maid -> maid.distanceToSqr((Entity)player))).orElse(null);
    }

    public static <T extends Mob> T getNearestMob(LivingEntity hurtMob, double radius, Class<T> mob, LivingEntity maid) {
        Level world = hurtMob.level();
        return (T)((Mob)world.getEntitiesOfClass(mob, hurtMob.getBoundingBox().inflate(radius)).stream().filter(entity -> entity.isAlive() && !entity.isRemoved() && entity != hurtMob && !MobUtil.isSameEntityType((Entity)entity, (Entity)maid)).min(Comparator.comparingDouble(zombie -> zombie.distanceToSqr((Entity)hurtMob))).orElse(null));
    }

    public static boolean isSameEntityType(Entity entity1, Entity entity2) {
        if (entity1 == null || entity2 == null) {
            return false;
        }
        boolean flag = entity1.getType() == entity2.getType();
        return flag;
    }
}

