/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyansethome.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.aeldit.cyansethome.CyanSHCore;
import fr.aeldit.cyansethome.commands.arguments.ArgumentSuggestion;
import fr.aeldit.cyansethome.config.CyanLibConfigImpl;
import fr.aeldit.cyansethome.homes.Home;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class HomeOfCommands {
    public static void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"set-home-of").then(class_2170.method_9244((String)"player_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getTrustingPlayersName(builder, ((class_2168)context.getSource()).method_44023())).then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.string()).executes(HomeOfCommands::setHomeOf))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"sho").then(class_2170.method_9244((String)"player_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getTrustingPlayersName(builder, ((class_2168)context.getSource()).method_44023())).then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.string()).executes(HomeOfCommands::setHomeOf))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"remove-home-of").then(class_2170.method_9244((String)"player_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getTrustingPlayersName(builder, ((class_2168)context.getSource()).method_44023())).then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getHomesOf(builder, ((class_2168)context.getSource()).method_44023(), context.getInput().split(" ")[1])).executes(HomeOfCommands::removeHomeOf))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"rho").then(class_2170.method_9244((String)"player_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getTrustingPlayersName(builder, ((class_2168)context.getSource()).method_44023())).then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getHomesOf(builder, ((class_2168)context.getSource()).method_44023(), context.getInput().split(" ")[1])).executes(HomeOfCommands::removeHomeOf))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"remove-all-homes-of").then(class_2170.method_9244((String)"player_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getTrustingPlayersName(builder, ((class_2168)context.getSource()).method_44023())).executes(HomeOfCommands::removeAllHomesOf)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"rename-home-of").then(class_2170.method_9244((String)"player_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getTrustingPlayersName(builder, ((class_2168)context.getSource()).method_44023())).then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getHomesOf(builder, ((class_2168)context.getSource()).method_44023(), context.getInput().split(" ")[1])).then(class_2170.method_9244((String)"new_home_name", (ArgumentType)StringArgumentType.string()).executes(HomeOfCommands::renameHomeOf)))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"home-of").then(class_2170.method_9244((String)"player_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getTrustingPlayersName(builder, ((class_2168)context.getSource()).method_44023())).then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getHomesOf(builder, ((class_2168)context.getSource()).method_44023(), context.getInput().split(" ")[1])).executes(HomeOfCommands::goToHomeOf))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"ho").then(class_2170.method_9244((String)"player_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getTrustingPlayersName(builder, ((class_2168)context.getSource()).method_44023())).then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getHomesOf(builder, ((class_2168)context.getSource()).method_44023(), context.getInput().split(" ")[1])).executes(HomeOfCommands::goToHomeOf))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"get-homes-of").then(class_2170.method_9244((String)"player_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getTrustingPlayersName(builder, ((class_2168)context.getSource()).method_44023())).executes(HomeOfCommands::getHomesOfList)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"gho").then(class_2170.method_9244((String)"player_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getTrustingPlayersName(builder, ((class_2168)context.getSource()).method_44023())).executes(HomeOfCommands::getHomesOfList)));
    }

    public static int setHomeOf(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (!(player != null && player.method_5687(CyanLibConfigImpl.MIN_OP_LVL_BYPASS.getValue().intValue()) && CyanSHCore.CYANSH_LIB_UTILS.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_HOMES.getValue().booleanValue(), "homesDisabled") && CyanSHCore.CYANSH_LIB_UTILS.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_BYPASS.getValue().booleanValue(), "bypassDisabled"))) {
            return 0;
        }
        String trustingPlayer = StringArgumentType.getString(context, (String)"player_name");
        String playerKey = CyanSHCore.HOMES_OBJ.getKeyFromName(trustingPlayer);
        if (playerKey == null) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.playerNotFound", new Object[]{String.valueOf(class_124.field_1075) + trustingPlayer});
            return 0;
        }
        if (CyanSHCore.HOMES_OBJ.maxHomesReached(playerKey)) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.maxHomesReached", new Object[]{CyanLibConfigImpl.MAX_HOMES.getValue()});
            return 0;
        }
        String homeName = StringArgumentType.getString(context, (String)"home_name");
        if (!CyanSHCore.HOMES_OBJ.addHome(playerKey, new Home(homeName, player.method_37908().method_40134().method_55840().replace("minecraft:", "").replace("the_", ""), player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455(), new SimpleDateFormat("dd/MM/yyyy HH:mm").format(Calendar.getInstance().getTime())))) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.homeAlreadyExists", new Object[0]);
            return 0;
        }
        CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "msg.setHomeOf", new Object[]{String.valueOf(class_124.field_1054) + homeName, String.valueOf(class_124.field_1075) + trustingPlayer});
        return 1;
    }

    public static int removeHomeOf(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (!(player != null && player.method_5687(CyanLibConfigImpl.MIN_OP_LVL_BYPASS.getValue().intValue()) && CyanSHCore.CYANSH_LIB_UTILS.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_HOMES.getValue().booleanValue(), "homesDisabled") && CyanSHCore.CYANSH_LIB_UTILS.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_BYPASS.getValue().booleanValue(), "bypassDisabled"))) {
            return 0;
        }
        String trustingPlayer = StringArgumentType.getString(context, (String)"player_name");
        String playerKey = CyanSHCore.HOMES_OBJ.getKeyFromName(trustingPlayer);
        if (playerKey == null) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.playerNotFound", new Object[]{String.valueOf(class_124.field_1075) + trustingPlayer});
            return 0;
        }
        String homeName = StringArgumentType.getString(context, (String)"home_name");
        if (!CyanSHCore.HOMES_OBJ.removeHome(playerKey, homeName)) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.homeNotFound", new Object[]{String.valueOf(class_124.field_1054) + homeName});
            return 0;
        }
        CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "msg.removeHomeOf", new Object[]{String.valueOf(class_124.field_1054) + homeName, String.valueOf(class_124.field_1075) + trustingPlayer});
        return 1;
    }

    public static int removeAllHomesOf(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (!(player != null && player.method_5687(CyanLibConfigImpl.MIN_OP_LVL_BYPASS.getValue().intValue()) && CyanSHCore.CYANSH_LIB_UTILS.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_HOMES.getValue().booleanValue(), "homesDisabled") && CyanSHCore.CYANSH_LIB_UTILS.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_BYPASS.getValue().booleanValue(), "bypassDisabled"))) {
            return 0;
        }
        String trustingPlayer = StringArgumentType.getString(context, (String)"player_name");
        String playerKey = CyanSHCore.HOMES_OBJ.getKeyFromName(trustingPlayer);
        if (playerKey == null) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.playerNotFound", new Object[]{String.valueOf(class_124.field_1075) + trustingPlayer});
            return 0;
        }
        if (!CyanSHCore.HOMES_OBJ.removeAll(playerKey)) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.noHomesOf", new Object[0]);
            return 0;
        }
        CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "msg.removeAllHomesOf", new Object[]{String.valueOf(class_124.field_1075) + trustingPlayer});
        return 1;
    }

    public static int renameHomeOf(@NotNull CommandContext<class_2168> context) {
        String newHomeName;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (!(player != null && player.method_5687(CyanLibConfigImpl.MIN_OP_LVL_BYPASS.getValue().intValue()) && CyanSHCore.CYANSH_LIB_UTILS.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_HOMES.getValue().booleanValue(), "homesDisabled") && CyanSHCore.CYANSH_LIB_UTILS.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_BYPASS.getValue().booleanValue(), "bypassDisabled"))) {
            return 0;
        }
        String trustingPlayer = StringArgumentType.getString(context, (String)"player_name");
        String playerKey = CyanSHCore.HOMES_OBJ.getKeyFromName(trustingPlayer);
        if (playerKey == null) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.playerNotFound", new Object[]{String.valueOf(class_124.field_1075) + trustingPlayer});
            return 0;
        }
        String homeName = StringArgumentType.getString(context, (String)"home_name");
        if (!CyanSHCore.HOMES_OBJ.rename(playerKey, homeName, newHomeName = StringArgumentType.getString(context, (String)"new_home_name"))) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.homeNotFoundOrExists", new Object[]{homeName});
            return 0;
        }
        CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "msg.renameHomeOf", new Object[]{String.valueOf(class_124.field_1054) + homeName, String.valueOf(class_124.field_1054) + newHomeName, String.valueOf(class_124.field_1075) + trustingPlayer});
        return 1;
    }

    public static int goToHomeOf(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanSHCore.CYANSH_LIB_UTILS.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_HOMES.getValue().booleanValue(), "homesDisabled")) {
            return 0;
        }
        String trustingPlayer = StringArgumentType.getString(context, (String)"player_name");
        String playerKey = CyanSHCore.HOMES_OBJ.getKeyFromName(trustingPlayer);
        if (playerKey == null) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.playerNotFound", new Object[]{String.valueOf(class_124.field_1075) + trustingPlayer});
            return 0;
        }
        if (!(CyanLibConfigImpl.ALLOW_BYPASS.getValue().booleanValue() && player.method_5687(CyanLibConfigImpl.MIN_OP_LVL_BYPASS.getValue().intValue()) || CyanSHCore.TRUSTS_OBJ.isPlayerTrustingFromName(trustingPlayer, player.method_5477().getString()))) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.notOpOrTrusted", new Object[0]);
            return 0;
        }
        String homeName = StringArgumentType.getString(context, (String)"home_name");
        Home home = CyanSHCore.HOMES_OBJ.getHome(playerKey, homeName);
        if (home == null) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.homeNotFound", new Object[]{String.valueOf(class_124.field_1054) + homeName});
            return 0;
        }
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return 0;
        }
        int requiredXpLevelOrPoints = 0;
        if (CyanLibConfigImpl.USE_XP_TO_TP_HOME.getValue().booleanValue() && !player.method_7337()) {
            requiredXpLevelOrPoints = home.getRequiredXpLevelsToTp(player);
            if ((CyanLibConfigImpl.XP_USE_POINTS.getValue() != false ? player.field_7495 : player.field_7520) < requiredXpLevelOrPoints) {
                CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.notEnoughXp", new Object[]{String.valueOf(class_124.field_1065) + String.valueOf(requiredXpLevelOrPoints), String.valueOf(class_124.field_1061) + (CyanLibConfigImpl.XP_USE_POINTS.getValue() != false ? "points" : "levels")});
                return 0;
            }
        }
        home.teleport(server, player);
        if (CyanLibConfigImpl.XP_USE_POINTS.getValue().booleanValue()) {
            player.method_7255(-1 * requiredXpLevelOrPoints);
        } else {
            player.method_7316(-1 * requiredXpLevelOrPoints);
        }
        CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "msg.goToHome", new Object[]{String.valueOf(class_124.field_1054) + homeName});
        return 1;
    }

    public static int getHomesOfList(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanSHCore.CYANSH_LIB_UTILS.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_HOMES.getValue().booleanValue(), "homesDisabled")) {
            return 0;
        }
        String trustingPlayer = StringArgumentType.getString(context, (String)"player_name");
        if (player.method_5477().getString().equals(trustingPlayer)) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.useSelfHomes", new Object[0]);
            return 0;
        }
        if (!(CyanLibConfigImpl.ALLOW_BYPASS.getValue().booleanValue() && player.method_5687(CyanLibConfigImpl.MIN_OP_LVL_BYPASS.getValue().intValue()) || CyanSHCore.TRUSTS_OBJ.isPlayerTrustingFromName(trustingPlayer, player.method_5477().getString()))) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.notOpOrTrusted", new Object[0]);
            return 0;
        }
        String playerKey = CyanSHCore.HOMES_OBJ.getKeyFromName(trustingPlayer);
        if (playerKey == null) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.playerNotFound", new Object[]{String.valueOf(class_124.field_1075) + trustingPlayer});
            return 0;
        }
        List<Home> homes = CyanSHCore.HOMES_OBJ.getPlayerHomes(playerKey);
        if (homes == null) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.noHomesOf", new Object[0]);
            return 0;
        }
        player.method_7353(class_2561.method_30163((String)"\u00a76------------------------------------"), false);
        CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessageActionBar(player, "msg.listHomesOf", false, new Object[]{String.valueOf(class_124.field_1075) + trustingPlayer});
        homes.forEach(home -> home.sendFormatedMessage(player));
        player.method_7353(class_2561.method_30163((String)"\u00a76------------------------------------"), false);
        return 1;
    }
}

