/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyansethome.homes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.aeldit.cyansethome.CyanSHCore;
import fr.aeldit.cyansethome.config.CyanLibConfigImpl;
import fr.aeldit.cyansethome.homes.Home;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Homes {
    private final ConcurrentHashMap<String, List<Home>> playerHomes = new ConcurrentHashMap();
    public static Path HOMES_PATH = Path.of("%s/homes".formatted(CyanSHCore.MOD_PATH), new String[0]);

    public void addPlayerHomes(String playerKey, List<Home> playerHomes) {
        this.playerHomes.put(playerKey, playerHomes);
        this.writeHomes(playerKey);
    }

    public boolean addHome(String playerKey, @NotNull Home home) {
        if (this.getHome(playerKey, home.name()) == null) {
            if (!this.playerHomes.containsKey(playerKey)) {
                this.playerHomes.put(playerKey, Collections.synchronizedList(new ArrayList<Home>(Collections.singleton(home))));
            } else {
                this.playerHomes.get(playerKey).add(home);
            }
            this.writeHomes(playerKey);
            return true;
        }
        return false;
    }

    public boolean removeHome(@NotNull String playerKey, String homeName) {
        Home home = this.getHome(playerKey, homeName);
        if (home != null) {
            this.playerHomes.get(playerKey).remove(home);
            if (this.playerHomes.get(playerKey).isEmpty()) {
                this.playerHomes.remove(playerKey);
            }
            this.writeHomes(playerKey);
            return true;
        }
        return false;
    }

    public boolean removeAll(String playerKey) {
        if (this.playerHomes.containsKey(playerKey) && !this.playerHomes.get(playerKey).isEmpty()) {
            this.playerHomes.get(playerKey).clear();
            this.playerHomes.remove(playerKey);
            this.writeHomes(playerKey);
            return true;
        }
        return false;
    }

    public boolean rename(String playerKey, String homeName, String newHomeName) {
        Home home = this.getHome(playerKey, homeName);
        if (home != null) {
            this.playerHomes.get(playerKey).remove(home);
            this.playerHomes.get(playerKey).add(home.getRenamed(newHomeName));
            this.writeHomes(playerKey);
            return true;
        }
        return false;
    }

    @Nullable
    public List<Home> getPlayerHomes(String playerKey) {
        if (!this.playerHomes.containsKey(playerKey) || this.playerHomes.get(playerKey).isEmpty()) {
            return null;
        }
        return this.playerHomes.get(playerKey);
    }

    public List<String> getPlayersWithHomes(String excludedPlayer) {
        return this.playerHomes.keySet().stream().filter(key -> !key.split(" ")[1].equals(excludedPlayer)).map(key -> key.split(" ")[1]).toList();
    }

    @Nullable
    public List<String> getHomesNames(String playerKey) {
        return this.playerHomes.containsKey(playerKey) ? this.playerHomes.get(playerKey).stream().map(Home::name).toList() : null;
    }

    @Nullable
    public List<String> getHomesNamesOf(String playerName) {
        return this.playerHomes.keySet().stream().filter(key -> key.split(" ")[1].equals(playerName)).findFirst().map(key -> this.playerHomes.get(key).stream().map(Home::name).toList()).orElse(null);
    }

    @Nullable
    public String getKeyFromName(String playerName) {
        return this.playerHomes.keySet().stream().filter(key -> key.split(" ")[1].equals(playerName)).findFirst().orElse(null);
    }

    public boolean maxHomesReached(String playerKey) {
        return this.playerHomes.containsKey(playerKey) && this.playerHomes.get(playerKey).size() >= CyanLibConfigImpl.MAX_HOMES.getValue();
    }

    @Nullable
    public Home getHome(String playerKey, String homeName) {
        if (this.playerHomes.containsKey(playerKey)) {
            return this.playerHomes.get(playerKey).stream().filter(home -> home.name().equals(homeName)).findFirst().orElse(null);
        }
        return null;
    }

    public void renameChangedUsernames(String playerUUID, String playerName) {
        if (!Files.exists(HOMES_PATH, new LinkOption[0])) {
            return;
        }
        File[] listOfFiles = new File(HOMES_PATH.toUri()).listFiles();
        if (listOfFiles == null) {
            return;
        }
        String playerKey = "%s %s".formatted(playerUUID, playerName);
        for (File file : listOfFiles) {
            if (!file.isFile()) continue;
            String[] splitFileName = file.getName().split(" ");
            String[] splitFileNameOld = file.getName().split("_");
            if ((!splitFileName[0].equals(playerUUID) || splitFileName[1].equals("%s.json".formatted(playerName))) && (splitFileNameOld.length != 2 || !splitFileNameOld[0].equals(playerUUID) || splitFileNameOld[1].equals("%s.json".formatted(playerName)))) continue;
            try {
                Files.move(file.toPath(), Path.of("%s/%s.json".formatted(HOMES_PATH, playerKey), new String[0]).resolveSibling("%s.json".formatted(playerKey)), new CopyOption[0]);
                CyanSHCore.CYANSH_LOGGER.info("[CyanSetHome] Rename the file '{}' to '{}' because the player changed its pseudo", (Object)file.getName(), (Object)(playerKey + ".json"));
                break;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void readServer() {
        File[] listOfFiles = new File(HOMES_PATH.toUri()).listFiles();
        if (listOfFiles == null) {
            return;
        }
        Gson gson = new Gson();
        Arrays.stream(listOfFiles).filter(File::isFile).forEach(file -> {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
                this.addPlayerHomes(file.getName().split("\\.")[0], Collections.synchronizedList(List.of((Home[])gson.fromJson((Reader)reader, Home[].class))));
            }
            catch (IOException e) {
                CyanSHCore.CYANSH_LOGGER.error("Could not open the file '{}' to read homes (readServer)", (Object)file.getPath());
                throw new RuntimeException(e);
            }
        });
    }

    public void readClient(String saveName) {
        HOMES_PATH = Path.of("%s/%s".formatted(CyanSHCore.MOD_PATH, saveName), new String[0]);
        CyanSHCore.checkOrCreateHomesDir();
        File[] listOfFiles = new File(HOMES_PATH.toUri()).listFiles();
        if (listOfFiles == null) {
            return;
        }
        Gson gson = new Gson();
        Arrays.stream(listOfFiles).filter(File::isFile).filter(file -> !file.getName().equals("trusted_players.json")).forEach(file -> {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
                this.addPlayerHomes(file.getName().split("\\.")[0], Collections.synchronizedList(List.of((Home[])gson.fromJson((Reader)reader, Home[].class))));
            }
            catch (IOException e) {
                CyanSHCore.CYANSH_LOGGER.error("Could not open the file '{}' to read homes (readClient)", (Object)file.getPath());
                throw new RuntimeException(e);
            }
        });
    }

    private void writeHomes(String playerKey) {
        CyanSHCore.checkOrCreateHomesDir();
        Path path = Path.of("%s/%s.json".formatted(HOMES_PATH, playerKey), new String[0]);
        if (!this.playerHomes.containsKey(playerKey) || this.playerHomes.containsKey(playerKey) && this.playerHomes.get(playerKey).isEmpty()) {
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                CyanSHCore.removeEmptyModDir();
            }
        } else {
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                new GsonBuilder().setPrettyPrinting().create().toJson(this.playerHomes.get(playerKey), (Appendable)writer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

