/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyansethome.homes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import fr.aeldit.cyansethome.CyanSHCore;
import fr.aeldit.cyansethome.homes.Homes;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class Trusts {
    private final ConcurrentHashMap<String, List<String>> trusts = new ConcurrentHashMap();
    public final TypeToken<ConcurrentHashMap<String, List<String>>> trustType = new TypeToken<ConcurrentHashMap<String, List<String>>>(this){};
    public static Path TRUST_PATH = Path.of("%s/trusted_players.json".formatted(CyanSHCore.MOD_PATH), new String[0]);

    public void trustPlayer(String trustingPlayerKey, String trustedPlayerKey) {
        if (!this.trusts.containsKey(trustingPlayerKey)) {
            this.trusts.put(trustingPlayerKey, Collections.synchronizedList(new ArrayList<String>(Collections.singletonList(trustedPlayerKey))));
        } else {
            this.trusts.get(trustingPlayerKey).add(trustedPlayerKey);
        }
        this.write();
    }

    public void untrustPlayer(String trustingPlayerName, String trustedPlayerName) {
        block0: for (Map.Entry<String, List<String>> entry : this.trusts.entrySet()) {
            if (!entry.getKey().split(" ")[1].equals(trustingPlayerName)) continue;
            for (String name : entry.getValue()) {
                if (!name.split(" ")[1].equals(trustedPlayerName)) continue;
                this.trusts.get(entry.getKey()).remove(name);
                if (this.trusts.get(entry.getKey()).isEmpty()) {
                    this.trusts.remove(entry.getKey());
                }
                this.write();
                break block0;
            }
        }
    }

    public void renameChangedUsernames(String playerUUID, String playerName) {
        if (!Files.exists(TRUST_PATH, new LinkOption[0]) || this.trusts.isEmpty()) {
            return;
        }
        boolean changed = false;
        String prevName = "";
        String playerKey = "%s %s".formatted(playerUUID, playerName);
        for (String key : this.trusts.keySet()) {
            if (key.split(" ")[0].equals(playerUUID) && !key.split(" ")[1].equals(playerName)) {
                prevName = key.split(" ")[1];
                this.trusts.put(playerKey, Collections.synchronizedList(new ArrayList(this.trusts.get(key))));
                this.trusts.remove(key);
                changed = true;
            }
            if (changed) {
                key = playerKey;
            }
            for (String listKey : this.trusts.get(key)) {
                if (!listKey.split(" ")[0].equals(playerUUID) || listKey.split(" ")[1].equals(playerName)) continue;
                prevName = listKey.split(" ")[1];
                changed = true;
                this.trusts.get(key).add(playerKey);
                this.trusts.get(key).remove(listKey);
                this.write();
            }
        }
        if (changed) {
            this.write();
            CyanSHCore.CYANSH_LOGGER.info("[CyanSetHome] Updated {}'s pseudo in the trust file, because the player changed its pseudo (previously {})", (Object)playerName, (Object)prevName);
        }
    }

    public ArrayList<String> getTrustingPlayers(String playerKey) {
        return this.trusts.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(playerKey)).map(entry -> ((String)entry.getKey()).split(" ")[1]).collect(Collectors.toCollection(() -> new ArrayList(this.trusts.size())));
    }

    @Nullable
    public List<String> getTrustedPlayers(String playerKey) {
        if (this.trusts.containsKey(playerKey)) {
            List<String> trustedPlayersKeys = this.trusts.get(playerKey);
            return trustedPlayersKeys.stream().map(player -> player.split(" ")[1]).collect(Collectors.toCollection(() -> new ArrayList(trustedPlayersKeys.size())));
        }
        return null;
    }

    public boolean isPlayerTrustingFromName(String trustingPlayerName, String trustedPlayerName) {
        for (String playerKey : this.trusts.keySet()) {
            if (!playerKey.split(" ")[1].equals(trustingPlayerName)) continue;
            for (String trustedKey : this.trusts.get(playerKey)) {
                if (!trustedKey.split(" ")[1].equals(trustedPlayerName)) continue;
                return true;
            }
        }
        return false;
    }

    public void readServer() {
        if (!Files.exists(TRUST_PATH, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(TRUST_PATH);){
            this.trusts.putAll((Map)new Gson().fromJson((Reader)reader, this.trustType));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void readClient() {
        TRUST_PATH = Path.of("%s/trusted_players.json".formatted(Homes.HOMES_PATH), new String[0]);
        if (!Files.exists(TRUST_PATH, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(TRUST_PATH);){
            this.trusts.putAll((Map)new Gson().fromJson((Reader)reader, this.trustType));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write() {
        CyanSHCore.checkOrCreateHomesDir();
        if (this.trusts.isEmpty()) {
            if (Files.exists(TRUST_PATH, new LinkOption[0])) {
                try {
                    Files.delete(TRUST_PATH);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                CyanSHCore.removeEmptyModDir();
            }
        } else {
            try (BufferedWriter writer = Files.newBufferedWriter(TRUST_PATH, new OpenOption[0]);){
                new GsonBuilder().setPrettyPrinting().create().toJson(this.trusts, (Appendable)writer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

