/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyansethome;

import com.mojang.brigadier.CommandDispatcher;
import fr.aeldit.cyanlib.events.PlayerMovedEvent;
import fr.aeldit.cyanlib.lib.CombatTracking;
import fr.aeldit.cyanlib.lib.CyanLib;
import fr.aeldit.cyanlib.lib.CyanLibLanguageUtils;
import fr.aeldit.cyanlib.lib.commands.CyanLibConfigCommands;
import fr.aeldit.cyanlib.lib.config.ICyanLibConfig;
import fr.aeldit.cyansethome.CooldownManager;
import fr.aeldit.cyansethome.commands.HomeCommands;
import fr.aeldit.cyansethome.commands.HomeOfCommands;
import fr.aeldit.cyansethome.commands.PermissionCommands;
import fr.aeldit.cyansethome.config.CyanLibConfigImpl;
import fr.aeldit.cyansethome.homes.Homes;
import fr.aeldit.cyansethome.homes.Trusts;
import fr.aeldit.cyansethome.util.EventUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyanSHCore
implements ModInitializer {
    public static final String MODID = "cyansethome";
    public static final Logger CYANSH_LOGGER = LoggerFactory.getLogger((String)"cyansethome");
    public static final Path MOD_PATH = FabricLoader.getInstance().getConfigDir().resolve("cyansethome");
    public static final Homes HOMES = new Homes();
    public static final Trusts TRUSTS = new Trusts();
    public static final CyanLib CYANSH_LIB_UTILS = new CyanLib("cyansethome", (ICyanLibConfig)new CyanLibConfigImpl());
    public static final CyanLibLanguageUtils CYANSH_LANG_UTILS = CYANSH_LIB_UTILS.getLanguageUtils();

    public static void checkOrCreateHomesDir() {
        if (!Files.exists(MOD_PATH, new LinkOption[0])) {
            try {
                Files.createDirectory(MOD_PATH, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!Files.exists(Homes.HOMES_PATH, new LinkOption[0])) {
            try {
                Files.createDirectory(Homes.HOMES_PATH, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void removeEmptyModDir() {
        File[] listOfFiles;
        if (Files.exists(Homes.HOMES_PATH, new LinkOption[0]) && (listOfFiles = new File(Homes.HOMES_PATH.toUri()).listFiles()) != null && listOfFiles.length == 0) {
            try {
                Files.delete(Homes.HOMES_PATH);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (Files.exists(MOD_PATH, new LinkOption[0]) && (listOfFiles = new File(MOD_PATH.toUri()).listFiles()) != null && listOfFiles.length == 0) {
            try {
                Files.delete(MOD_PATH);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void onInitialize() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> EventUtils.renameFileIfUsernameChanged(handler));
        PlayerMovedEvent.AFTER_MOVE.register(player -> {
            if (HOMES.playerRequestedTp(player.method_5477().getString())) {
                CooldownManager.cancelCooldown(player);
                HOMES.endTpRequest(player.method_5477().getString());
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(minecraftServer -> {
            CooldownManager.getCanceledCooldowns().forEach(player -> CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.movedWhileWaitingForTp", new Object[0]));
            CooldownManager.clearCanceledCooldowns();
            CooldownManager.getPlayersCompletedCooldowns().forEach((player, t) -> {
                HOMES.endTpRequest(player.method_5477().getString());
                t.home().teleport(t.server(), (class_3222)player);
                if (CyanLibConfigImpl.XP_USE_POINTS.getValue().booleanValue()) {
                    player.method_7255(-1 * t.requiredXpLevel());
                } else {
                    player.method_7316(-1 * t.requiredXpLevel());
                }
                CYANSH_LANG_UTILS.sendPlayerMessage(player, "msg.goToHome", new Object[]{String.valueOf(class_124.field_1054) + t.home().name()});
            });
        });
        ServerLivingEntityEvents.AFTER_DAMAGE.register((entity, source, baseDamageTaken, damageTaken, blocked) -> {
            if (entity.method_31747()) {
                CombatTracking.addEntry((String)entity.method_5477().getString(), (long)System.currentTimeMillis());
                class_1297 attacker = source.method_5529();
                if (attacker != null) {
                    CombatTracking.addEntry((String)attacker.method_5477().getString(), (long)System.currentTimeMillis());
                }
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> CombatTracking.removePlayerOnPlayerQuit((String)handler.field_14140.method_5477().getString()));
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, environment) -> {
            new CyanLibConfigCommands(MODID, CYANSH_LIB_UTILS).register(dispatcher);
            HomeCommands.register((CommandDispatcher<class_2168>)dispatcher);
            HomeOfCommands.register((CommandDispatcher<class_2168>)dispatcher);
            PermissionCommands.register((CommandDispatcher<class_2168>)dispatcher);
        });
        CYANSH_LOGGER.info("[CyanSetHome] Successfully initialized");
    }
}

