/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyansethome.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.aeldit.cyanlib.lib.CombatTracking;
import fr.aeldit.cyanlib.lib.config.IntegerOption;
import fr.aeldit.cyansethome.CooldownManager;
import fr.aeldit.cyansethome.CyanSHCore;
import fr.aeldit.cyansethome.commands.arguments.ArgumentSuggestion;
import fr.aeldit.cyansethome.config.CyanLibConfigImpl;
import fr.aeldit.cyansethome.homes.Home;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class HomeCommands {
    public static void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"set-home").then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.string()).executes(HomeCommands::setHome)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"sh").then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.string()).executes(HomeCommands::setHome)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"remove-home").then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getHomes(builder, Objects.requireNonNull(((class_2168)context.getSource()).method_44023()))).executes(HomeCommands::removeHome)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"rh").then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getHomes(builder, Objects.requireNonNull(((class_2168)context.getSource()).method_44023()))).executes(HomeCommands::removeHome)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"rename-home").then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getHomes(builder, Objects.requireNonNull(((class_2168)context.getSource()).method_44023()))).then(class_2170.method_9244((String)"new_home_name", (ArgumentType)StringArgumentType.string()).executes(HomeCommands::renameHome))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"remove-all-homes").executes(HomeCommands::removeAllHomes));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"home").then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getHomes(builder, Objects.requireNonNull(((class_2168)context.getSource()).method_44023()))).executes(HomeCommands::goToHome)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"h").then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getHomes(builder, Objects.requireNonNull(((class_2168)context.getSource()).method_44023()))).executes(HomeCommands::goToHome)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"get-homes").executes(HomeCommands::getHomesList));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"gh").executes(HomeCommands::getHomesList));
    }

    public static int setHome(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanSHCore.CYANSH_LIB_UTILS.hasPermission(player, CyanLibConfigImpl.MIN_OP_LVL_HOMES.getValue().intValue()) || !CyanSHCore.CYANSH_LIB_UTILS.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_HOMES.getValue().booleanValue(), "homesDisabled")) {
            return 0;
        }
        String homeName = StringArgumentType.getString(context, (String)"home_name");
        String playerKey = "%s %s".formatted(player.method_5845(), player.method_5477().getString());
        if (CyanSHCore.HOMES.maxHomesReached(playerKey)) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.maxHomesReached", new Object[]{String.valueOf(class_124.field_1065) + CyanLibConfigImpl.MAX_HOMES.getValue().toString()});
            return 0;
        }
        if (!CyanSHCore.HOMES.addHome(playerKey, new Home(homeName, player.method_37908().method_40134().method_55840().replace("minecraft:", "").replace("the_", ""), player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455(), new SimpleDateFormat("dd/MM/yyyy HH:mm").format(Calendar.getInstance().getTime())))) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.homeAlreadyExists", new Object[0]);
            return 0;
        }
        CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "msg.setHome", new Object[]{String.valueOf(class_124.field_1054) + homeName});
        return 1;
    }

    public static int removeHome(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanSHCore.CYANSH_LIB_UTILS.hasPermission(player, CyanLibConfigImpl.MIN_OP_LVL_HOMES.getValue().intValue()) || !CyanSHCore.CYANSH_LIB_UTILS.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_HOMES.getValue().booleanValue(), "homesDisabled")) {
            return 0;
        }
        String homeName = StringArgumentType.getString(context, (String)"home_name");
        String playerKey = "%s %s".formatted(player.method_5845(), player.method_5477().getString());
        if (!CyanSHCore.HOMES.removeHome(playerKey, homeName)) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.homeNotFound", new Object[]{String.valueOf(class_124.field_1054) + homeName});
            return 0;
        }
        CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "msg.removeHome", new Object[]{String.valueOf(class_124.field_1054) + homeName});
        return 1;
    }

    public static int removeAllHomes(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanSHCore.CYANSH_LIB_UTILS.hasPermission(player, CyanLibConfigImpl.MIN_OP_LVL_HOMES.getValue().intValue()) || !CyanSHCore.CYANSH_LIB_UTILS.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_HOMES.getValue().booleanValue(), "homesDisabled")) {
            return 0;
        }
        if (!CyanSHCore.HOMES.removeAll("%s %s".formatted(player.method_5845(), player.method_5477().getString()))) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.noHomes", new Object[0]);
            return 0;
        }
        CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "msg.removeAllHomes", new Object[0]);
        return 1;
    }

    public static int renameHome(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanSHCore.CYANSH_LIB_UTILS.hasPermission(player, CyanLibConfigImpl.MIN_OP_LVL_HOMES.getValue().intValue()) || !CyanSHCore.CYANSH_LIB_UTILS.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_HOMES.getValue().booleanValue(), "homesDisabled")) {
            return 0;
        }
        String homeName = StringArgumentType.getString(context, (String)"home_name");
        String newHomeName = StringArgumentType.getString(context, (String)"new_home_name");
        String playerKey = "%s %s".formatted(player.method_5845(), player.method_5477().getString());
        if (!CyanSHCore.HOMES.rename(playerKey, homeName, newHomeName)) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.homeNotFoundOrExists", new Object[]{homeName});
            return 0;
        }
        CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "msg.renameHome", new Object[]{String.valueOf(class_124.field_1054) + homeName, String.valueOf(class_124.field_1054) + newHomeName});
        return 1;
    }

    public static int goToHome(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanSHCore.CYANSH_LIB_UTILS.hasPermission(player, CyanLibConfigImpl.MIN_OP_LVL_HOMES.getValue().intValue()) || !CyanSHCore.CYANSH_LIB_UTILS.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_HOMES.getValue().booleanValue(), "homesDisabled")) {
            return 0;
        }
        if (!CyanLibConfigImpl.TP_IN_COMBAT.getValue().booleanValue() && CombatTracking.isPlayerInCombat((String)player.method_5477().getString(), (IntegerOption)CyanLibConfigImpl.COMBAT_TIMEOUT_SECONDS)) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.noHomeWhileInCombat", new Object[0]);
            return 0;
        }
        String homeName = StringArgumentType.getString(context, (String)"home_name");
        String playerKey = "%s %s".formatted(player.method_5845(), player.method_5477().getString());
        Home home = CyanSHCore.HOMES.getHome(playerKey, homeName);
        if (home == null) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.homeNotFound", new Object[]{String.valueOf(class_124.field_1054) + homeName});
            return 0;
        }
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return 0;
        }
        int requiredXpLevel = 0;
        if (CyanLibConfigImpl.USE_XP_TO_TP_HOME.getValue().booleanValue() && !player.method_68878()) {
            requiredXpLevel = CyanLibConfigImpl.XP_USE_FIXED_AMOUNT.getValue() != false ? CyanLibConfigImpl.XP_AMOUNT.getValue().intValue() : home.getRequiredXpLevelsToTp(player);
            if ((CyanLibConfigImpl.XP_USE_POINTS.getValue() != false ? player.field_7495 : player.field_7520) < requiredXpLevel) {
                CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.notEnoughXp", new Object[]{String.valueOf(class_124.field_1065) + String.valueOf(requiredXpLevel), String.valueOf(class_124.field_1061) + (CyanLibConfigImpl.XP_USE_POINTS.getValue() != false ? "points" : "levels")});
                return 0;
            }
        }
        if (CyanLibConfigImpl.TP_COOLDOWN.getValue().booleanValue()) {
            String playerName = player.method_5477().getString();
            CyanSHCore.HOMES.requestTp(playerName);
            CooldownManager.addPlayerCooldown(player, CyanLibConfigImpl.TP_COOLDOWN_SECONDS.getValue() * 1000, System.currentTimeMillis(), home, requiredXpLevel, server);
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "msg.waitingXSeconds", new Object[]{String.valueOf(class_124.field_1065) + String.valueOf(CyanLibConfigImpl.TP_COOLDOWN_SECONDS.getValue())});
            return 1;
        }
        home.teleport(server, player);
        if (CyanLibConfigImpl.XP_USE_POINTS.getValue().booleanValue()) {
            player.method_7255(-1 * requiredXpLevel);
        } else {
            player.method_7316(-1 * requiredXpLevel);
        }
        CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "msg.goToHome", new Object[]{String.valueOf(class_124.field_1054) + homeName});
        return 1;
    }

    public static int getHomesList(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanSHCore.CYANSH_LIB_UTILS.hasPermission(player, CyanLibConfigImpl.MIN_OP_LVL_HOMES.getValue().intValue()) || !CyanSHCore.CYANSH_LIB_UTILS.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_HOMES.getValue().booleanValue(), "homesDisabled")) {
            return 0;
        }
        List<Home> homes = CyanSHCore.HOMES.getPlayerHomes("%s %s".formatted(player.method_5845(), player.method_5477().getString()));
        if (homes == null) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.noHomes", new Object[0]);
            return 0;
        }
        player.method_7353(class_2561.method_30163((String)"\u00a76------------------------------------"), false);
        CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessageActionBar(player, "msg.listHomes", false, new Object[0]);
        homes.forEach(home -> home.sendFormatedMessage(player));
        player.method_7353(class_2561.method_30163((String)"\u00a76------------------------------------"), false);
        return 1;
    }
}

