/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyansethome.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.aeldit.cyansethome.CyanSHCore;
import fr.aeldit.cyansethome.commands.arguments.ArgumentSuggestion;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class PermissionCommands {
    public static void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"home-trust").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getOnlinePlayersName(builder, (class_2168)context.getSource())).executes(PermissionCommands::trustPlayer)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"home-untrust").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getTrustedPlayersName(builder, ((class_2168)context.getSource()).method_44023())).executes(PermissionCommands::untrustPlayer)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"get-trusting-players").executes(PermissionCommands::getTrustingPlayers));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"get-trusted-players").executes(PermissionCommands::getTrustedPlayers));
    }

    public static int trustPlayer(@NotNull CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (source.method_44023() == null) {
            return 0;
        }
        class_3222 player = source.method_44023();
        String playerName = StringArgumentType.getString(context, (String)"player");
        class_3222 trustedPlayer = source.method_9211().method_3760().method_14566(playerName);
        if (trustedPlayer == null) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.playerNotOnline", new Object[0]);
            return 0;
        }
        String trustingPlayerKey = "%s %s".formatted(player.method_5845(), player.method_5477().getString());
        String trustedPlayerKey = "%s %s".formatted(trustedPlayer.method_5667(), playerName);
        if (trustingPlayerKey.equals(trustedPlayerKey)) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.selfTrust", new Object[0]);
            return 0;
        }
        if (CyanSHCore.TRUSTS.isPlayerTrustingFromName(player.method_5477().getString(), playerName)) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.playerAlreadyTrusted", new Object[0]);
            return 0;
        }
        CyanSHCore.TRUSTS.trustPlayer(trustingPlayerKey, trustedPlayerKey);
        CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "msg.playerTrusted", new Object[]{String.valueOf(class_124.field_1075) + playerName});
        return 1;
    }

    public static int untrustPlayer(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        String untrustedPlayerName = StringArgumentType.getString(context, (String)"player");
        if (player.method_5477().getString().equals(untrustedPlayerName)) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.selfTrust", new Object[0]);
            return 0;
        }
        if (!CyanSHCore.TRUSTS.isPlayerTrustingFromName(player.method_5477().getString(), untrustedPlayerName)) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "error.playerNotTrusted", new Object[0]);
            return 0;
        }
        CyanSHCore.TRUSTS.untrustPlayer(player.method_5477().getString(), untrustedPlayerName);
        CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "msg.playerUnTrusted", new Object[]{String.valueOf(class_124.field_1075) + untrustedPlayerName});
        return 1;
    }

    public static int getTrustingPlayers(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        ArrayList<String> trustingPlayers = CyanSHCore.TRUSTS.getTrustingPlayers("%s %s".formatted(player.method_5845(), player.method_5477().getString()));
        if (trustingPlayers == null || trustingPlayers.isEmpty()) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "msg.noTrustingPlayer", new Object[0]);
            return 0;
        }
        String players = PermissionCommands.getPlayers(trustingPlayers);
        CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessageActionBar(player, "msg.getTrustingPlayers", false, new Object[]{String.valueOf(class_124.field_1075) + players});
        return 1;
    }

    public static int getTrustedPlayers(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        List<String> trustedPlayers = CyanSHCore.TRUSTS.getTrustedPlayers("%s %s".formatted(player.method_5845(), player.method_5477().getString()));
        if (trustedPlayers == null || trustedPlayers.isEmpty()) {
            CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessage(player, "msg.noTrustedPlayer", new Object[0]);
            return 0;
        }
        CyanSHCore.CYANSH_LANG_UTILS.sendPlayerMessageActionBar(player, "msg.getTrustedPlayers", false, new Object[]{String.valueOf(class_124.field_1075) + PermissionCommands.getPlayers(trustedPlayers)});
        return 1;
    }

    @NotNull
    private static String getPlayers(@NotNull List<String> trustedPlayers) {
        if (trustedPlayers.isEmpty()) {
            return "";
        }
        if (trustedPlayers.size() == 1) {
            return trustedPlayers.getFirst();
        }
        StringBuilder players = new StringBuilder();
        int size = trustedPlayers.size();
        for (int i = 0; i < size - 1; ++i) {
            players.append("%s, ".formatted(trustedPlayers.get(i)));
        }
        players.append("%s".formatted(trustedPlayers.get(size - 1)));
        return players.toString();
    }
}

