/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.treecapitation999;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TreeCapitation999
extends JavaPlugin
implements Listener {
    private boolean breakLeaves;
    private boolean requireAxe;
    private boolean dropAsOne;
    private boolean autoReplant;
    private int maxTreeBlocks;
    private int maxBreakDistance;
    private int maxLeavesBreak;
    private Set<Material> woodMaterials;
    private Set<Material> leafMaterials;
    private Set<UUID> disabledPlayers = new HashSet<UUID>();

    public void onEnable() {
        this.woodMaterials = new HashSet<Material>(Arrays.asList(Material.OAK_LOG, Material.SPRUCE_LOG, Material.BIRCH_LOG, Material.JUNGLE_LOG, Material.ACACIA_LOG, Material.DARK_OAK_LOG, Material.MANGROVE_LOG, Material.CHERRY_LOG, Material.CRIMSON_STEM, Material.WARPED_STEM, Material.STRIPPED_OAK_LOG, Material.STRIPPED_SPRUCE_LOG, Material.STRIPPED_BIRCH_LOG, Material.STRIPPED_JUNGLE_LOG, Material.STRIPPED_ACACIA_LOG, Material.STRIPPED_DARK_OAK_LOG, Material.STRIPPED_MANGROVE_LOG, Material.STRIPPED_CHERRY_LOG, Material.STRIPPED_CRIMSON_STEM, Material.STRIPPED_WARPED_STEM));
        this.leafMaterials = new HashSet<Material>(Arrays.asList(Material.OAK_LEAVES, Material.SPRUCE_LEAVES, Material.BIRCH_LEAVES, Material.JUNGLE_LEAVES, Material.ACACIA_LEAVES, Material.DARK_OAK_LEAVES, Material.MANGROVE_LEAVES, Material.CHERRY_LEAVES, Material.AZALEA_LEAVES, Material.FLOWERING_AZALEA_LEAVES));
        this.saveDefaultConfig();
        this.reloadPluginConfig();
        if (this.maxTreeBlocks > 500) {
            this.maxTreeBlocks = 500;
            this.getLogger().warning("max-tree-blocks exceeded safe limit. Reset to 500.");
        }
        if (this.maxBreakDistance > 100) {
            this.getLogger().warning("Max break distance is set very high (" + this.maxBreakDistance + "). This may impact performance.");
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("TreeCapitation999 has been enabled!");
    }

    private void reloadPluginConfig() {
        this.reloadConfig();
        this.breakLeaves = this.getConfig().getBoolean("break-leaves", true);
        this.requireAxe = this.getConfig().getBoolean("require-axe", true);
        this.dropAsOne = this.getConfig().getBoolean("drop-as-one", true);
        this.autoReplant = this.getConfig().getBoolean("auto-replant", true);
        this.maxTreeBlocks = this.getConfig().getInt("max-tree-blocks", 120);
        this.maxBreakDistance = this.getConfig().getInt("max-break-distance", 50);
        this.maxLeavesBreak = this.getConfig().getInt("max-leaves-break", 100);
    }

    public void onDisable() {
        this.getLogger().info("TreeCapitation999 has been disabled!");
    }

    @EventHandler
    public void onTreeBreak(BlockBreakEvent event) {
        ItemStack tool;
        ItemStack tool2;
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (!player.hasPermission("treecapitation.use")) {
            return;
        }
        if (this.disabledPlayers.contains(player.getUniqueId())) {
            return;
        }
        if (!this.woodMaterials.contains(block.getType())) {
            return;
        }
        if (this.requireAxe && ((tool2 = player.getInventory().getItemInMainHand()) == null || tool2.getType() == Material.AIR || !tool2.getType().name().endsWith("_AXE"))) {
            return;
        }
        if (this.isFakeVerticalLog(block)) {
            return;
        }
        Set<Block> treeBlocks = this.findConnectedLogsBFS(block, this.maxBreakDistance);
        if (treeBlocks.size() > this.maxTreeBlocks) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This tree is too large to break!");
            return;
        }
        HashMap<Material, Integer> logCounts = new HashMap<Material, Integer>();
        for (Block block2 : treeBlocks) {
            logCounts.put(block2.getType(), logCounts.getOrDefault(block2.getType(), 0) + 1);
        }
        if (this.dropAsOne) {
            for (Map.Entry entry : logCounts.entrySet()) {
                mat = (Material)entry.getKey();
                int count = (Integer)entry.getValue();
                block.getWorld().dropItemNaturally(block.getLocation(), new ItemStack(mat, count));
            }
            for (Block block3 : treeBlocks) {
                block3.setType(Material.AIR);
            }
        } else {
            for (Block block4 : treeBlocks) {
                mat = block4.getType();
                block4.setType(Material.AIR);
                block4.getWorld().dropItemNaturally(block4.getLocation(), new ItemStack(mat));
            }
        }
        if (this.breakLeaves) {
            Set<Block> leaves = this.findNearbyLeavesBFS(treeBlocks, this.maxLeavesBreak);
            for (Block leaf : leaves) {
                leaf.setType(Material.AIR);
            }
        }
        if ((tool = player.getInventory().getItemInMainHand()) != null && tool.getItemMeta() instanceof Damageable) {
            short maxDurability;
            Damageable damageable = (Damageable)tool.getItemMeta();
            int newDamage = damageable.getDamage() + treeBlocks.size();
            if (newDamage >= (maxDurability = tool.getType().getMaxDurability())) {
                player.getInventory().setItemInMainHand(null);
                player.sendMessage(String.valueOf(ChatColor.RED) + "Your axe broke!");
            } else {
                damageable.setDamage(newDamage);
                tool.setItemMeta((ItemMeta)damageable);
            }
        }
        if (this.autoReplant) {
            Material sapling;
            Block block5 = block.getRelative(0, -1, 0);
            Block plantSpot = block.getWorld().getBlockAt(block.getLocation());
            if ((block5.getType() == Material.DIRT || block5.getType() == Material.GRASS_BLOCK) && plantSpot.getType() == Material.AIR && (sapling = this.saplingFor(block.getType())) != null) {
                plantSpot.setType(sapling);
            }
        }
        event.setCancelled(true);
    }

    private Set<Block> findConnectedLogsBFS(Block start, int maxDistance) {
        HashSet<Block> found = new HashSet<Block>();
        LinkedList<Block> queue = new LinkedList<Block>();
        HashMap<Block, Integer> distances = new HashMap<Block, Integer>();
        queue.add(start);
        distances.put(start, 0);
        while (!queue.isEmpty()) {
            Block current = (Block)queue.poll();
            int dist = (Integer)distances.get(current);
            if (dist > maxDistance || !this.woodMaterials.contains(current.getType()) || found.contains(current)) continue;
            found.add(current);
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        Block relative;
                        if (x == 0 && y == 0 && z == 0 || found.contains(relative = current.getRelative(x, y, z)) || !this.woodMaterials.contains(relative.getType()) || distances.containsKey(relative) && (Integer)distances.get(relative) <= dist + 1) continue;
                        distances.put(relative, dist + 1);
                        queue.add(relative);
                    }
                }
            }
        }
        return found;
    }

    private Set<Block> findNearbyLeavesBFS(Set<Block> logs, int maxLeaves) {
        HashSet<Block> leavesFound = new HashSet<Block>();
        LinkedList<Block> queue = new LinkedList<Block>();
        for (Block log : logs) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        Block relative;
                        if (x == 0 && y == 0 && z == 0 || !this.leafMaterials.contains((relative = log.getRelative(x, y, z)).getType()) || leavesFound.contains(relative)) continue;
                        leavesFound.add(relative);
                        queue.add(relative);
                        if (leavesFound.size() < maxLeaves) continue;
                        return leavesFound;
                    }
                }
            }
        }
        while (!queue.isEmpty() && leavesFound.size() < maxLeaves) {
            Block current = (Block)queue.poll();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        Block relative;
                        if (x == 0 && y == 0 && z == 0 || !this.leafMaterials.contains((relative = current.getRelative(x, y, z)).getType()) || leavesFound.contains(relative)) continue;
                        leavesFound.add(relative);
                        queue.add(relative);
                        if (leavesFound.size() < maxLeaves) continue;
                        return leavesFound;
                    }
                }
            }
        }
        return leavesFound;
    }

    private Material saplingFor(Material logType) {
        switch (logType) {
            case OAK_LOG: 
            case STRIPPED_OAK_LOG: {
                return Material.OAK_SAPLING;
            }
            case SPRUCE_LOG: 
            case STRIPPED_SPRUCE_LOG: {
                return Material.SPRUCE_SAPLING;
            }
            case BIRCH_LOG: 
            case STRIPPED_BIRCH_LOG: {
                return Material.BIRCH_SAPLING;
            }
            case JUNGLE_LOG: 
            case STRIPPED_JUNGLE_LOG: {
                return Material.JUNGLE_SAPLING;
            }
            case ACACIA_LOG: 
            case STRIPPED_ACACIA_LOG: {
                return Material.ACACIA_SAPLING;
            }
            case DARK_OAK_LOG: 
            case STRIPPED_DARK_OAK_LOG: {
                return Material.DARK_OAK_SAPLING;
            }
            case MANGROVE_LOG: 
            case STRIPPED_MANGROVE_LOG: {
                return Material.MANGROVE_PROPAGULE;
            }
            case CHERRY_LOG: 
            case STRIPPED_CHERRY_LOG: {
                return Material.CHERRY_SAPLING;
            }
            case CRIMSON_STEM: 
            case STRIPPED_CRIMSON_STEM: {
                return Material.CRIMSON_FUNGUS;
            }
            case WARPED_STEM: 
            case STRIPPED_WARPED_STEM: {
                return Material.WARPED_FUNGUS;
            }
        }
        return null;
    }

    private boolean isFakeVerticalLog(Block block) {
        Block above = block.getRelative(0, 1, 0);
        Block below = block.getRelative(0, -1, 0);
        boolean aboveIsLog = this.woodMaterials.contains(above.getType());
        boolean belowIsLog = this.woodMaterials.contains(below.getType());
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    Block relative;
                    if (x == 0 && y == 0 && z == 0 || !this.leafMaterials.contains((relative = block.getRelative(x, y, z)).getType())) continue;
                    return false;
                }
            }
        }
        return aboveIsLog || belowIsLog;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("treecapitation")) {
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("reload")) {
                    if (!sender.hasPermission("treecapitation.reload")) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to reload the config.");
                        return true;
                    }
                    this.reloadPluginConfig();
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "TreeCapitation config reloaded.");
                    return true;
                }
                if (args[0].equalsIgnoreCase("toggle")) {
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can toggle the plugin.");
                        return true;
                    }
                    Player player = (Player)sender;
                    if (!player.hasPermission("treecapitation.toggle")) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to toggle TreeCapitation.");
                        return true;
                    }
                    UUID uuid = player.getUniqueId();
                    if (this.disabledPlayers.contains(uuid)) {
                        this.disabledPlayers.remove(uuid);
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "TreeCapitation enabled.");
                    } else {
                        this.disabledPlayers.add(uuid);
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "TreeCapitation disabled.");
                    }
                    return true;
                }
            }
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "TreeCapitation commands:");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/treecapitation reload - Reload config");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/treecapitation toggle - Toggle plugin for yourself");
            return true;
        }
        return false;
    }
}

