/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.treecapitation999;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.yourname.treecapitation999.PlayerSettings;
import com.yourname.treecapitation999.SettingsGUI;
import com.yourname.treecapitation999.TreeType;
import com.yourname.treecapitation999.WorldSettings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TreeCapitation999
extends JavaPlugin
implements Listener {
    private boolean breakLeaves;
    private boolean requireAxe;
    private boolean dropAsOne;
    private boolean autoReplant;
    private int maxTreeBlocks;
    private int maxBreakDistance;
    private int maxLeavesBreak;
    private boolean sneakToFell;
    private boolean cooldownEnabled;
    private int cooldownDuration;
    private boolean toolsEnabled;
    private String toolsMode;
    private Set<Material> toolList;
    private double durabilityMultiplier;
    private boolean soundsEnabled;
    private String breakSound;
    private float soundVolume;
    private float soundPitch;
    private boolean effectsEnabled;
    private String breakEffect;
    private Material particleData;
    private int particleCount;
    private boolean customDropsEnabled;
    private List<String> customDrops;
    private Map<Material, TreeType> treeOverrides = new HashMap<Material, TreeType>();
    private Map<String, WorldSettings> worldSettings = new HashMap<String, WorldSettings>();
    private Set<Material> woodMaterials;
    private Set<Material> leafMaterials;
    private Set<UUID> disabledPlayers = new HashSet<UUID>();
    private Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private Map<UUID, PlayerSettings> playerSettings = new HashMap<UUID, PlayerSettings>();
    private WorldGuard worldGuard;

    public void onEnable() {
        this.woodMaterials = new HashSet<Material>();
        this.leafMaterials = new HashSet<Material>();
        this.saveDefaultConfig();
        this.reloadPluginConfig();
        if (this.maxTreeBlocks > 500) {
            this.maxTreeBlocks = 500;
            this.getLogger().warning("max-tree-blocks exceeded safe limit. Reset to 500.");
        }
        if (this.maxBreakDistance > 100) {
            this.getLogger().warning("Max break distance is set very high (" + this.maxBreakDistance + "). This may impact performance.");
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            this.worldGuard = WorldGuard.getInstance();
            this.getLogger().info("Hooked into WorldGuard.");
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("TreeCapitation999 has been enabled!");
    }

    private void reloadPluginConfig() {
        Material material;
        this.reloadConfig();
        this.woodMaterials.clear();
        this.leafMaterials.clear();
        this.woodMaterials.addAll(Arrays.asList(Material.OAK_LOG, Material.SPRUCE_LOG, Material.BIRCH_LOG, Material.JUNGLE_LOG, Material.ACACIA_LOG, Material.DARK_OAK_LOG, Material.MANGROVE_LOG, Material.CHERRY_LOG, Material.CRIMSON_STEM, Material.WARPED_STEM, Material.STRIPPED_OAK_LOG, Material.STRIPPED_SPRUCE_LOG, Material.STRIPPED_BIRCH_LOG, Material.STRIPPED_JUNGLE_LOG, Material.STRIPPED_ACACIA_LOG, Material.STRIPPED_DARK_OAK_LOG, Material.STRIPPED_MANGROVE_LOG, Material.STRIPPED_CHERRY_LOG, Material.STRIPPED_CRIMSON_STEM, Material.STRIPPED_WARPED_STEM));
        this.leafMaterials.addAll(Arrays.asList(Material.OAK_LEAVES, Material.SPRUCE_LEAVES, Material.BIRCH_LEAVES, Material.JUNGLE_LEAVES, Material.ACACIA_LEAVES, Material.DARK_OAK_LEAVES, Material.MANGROVE_LEAVES, Material.CHERRY_LEAVES, Material.AZALEA_LEAVES, Material.FLOWERING_AZALEA_LEAVES));
        for (Object materialName : this.getConfig().getStringList("modded-wood-materials")) {
            try {
                material = Material.valueOf((String)((String)materialName).toUpperCase());
                this.woodMaterials.add(material);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid modded wood material in config.yml: " + (String)materialName);
            }
        }
        for (Object materialName : this.getConfig().getStringList("modded-leaf-materials")) {
            try {
                material = Material.valueOf((String)((String)materialName).toUpperCase());
                this.leafMaterials.add(material);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid modded leaf material in config.yml: " + (String)materialName);
            }
        }
        this.breakLeaves = this.getConfig().getBoolean("break-leaves", true);
        this.requireAxe = this.getConfig().getBoolean("require-axe", true);
        this.dropAsOne = this.getConfig().getBoolean("drop-as-one", true);
        this.autoReplant = this.getConfig().getBoolean("auto-replant", false);
        this.maxTreeBlocks = this.getConfig().getInt("max-tree-blocks", 120);
        this.maxBreakDistance = this.getConfig().getInt("max-break-distance", 50);
        this.maxLeavesBreak = this.getConfig().getInt("max-leaves-break", 100);
        this.sneakToFell = this.getConfig().getBoolean("sneak-to-fell", true);
        this.cooldownEnabled = this.getConfig().getBoolean("cooldown.enabled", true);
        this.cooldownDuration = this.getConfig().getInt("cooldown.duration", 5);
        this.toolsEnabled = this.getConfig().getBoolean("tools.enabled", true);
        this.toolsMode = this.getConfig().getString("tools.mode", "whitelist");
        this.toolList = this.getConfig().getStringList("tools.list").stream().map(Material::getMaterial).filter(Objects::nonNull).collect(Collectors.toSet());
        this.durabilityMultiplier = this.getConfig().getDouble("durability-multiplier", 1.0);
        this.soundsEnabled = this.getConfig().getBoolean("sounds.enabled", true);
        this.breakSound = this.getConfig().getString("sounds.break-sound", "BLOCK_WOOD_BREAK");
        this.soundVolume = (float)this.getConfig().getDouble("sounds.volume", 1.0);
        this.soundPitch = (float)this.getConfig().getDouble("sounds.pitch", 1.0);
        this.effectsEnabled = this.getConfig().getBoolean("effects.enabled", true);
        this.breakEffect = this.getConfig().getString("effects.break-effect", "BLOCK_CRACK");
        try {
            this.particleData = Material.valueOf((String)this.getConfig().getString("effects.particle-data", "OAK_LOG"));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warning("Invalid particle data material in config.yml. Defaulting to OAK_LOG.");
            this.particleData = Material.OAK_LOG;
        }
        this.particleCount = this.getConfig().getInt("effects.particle-count", 20);
        this.customDropsEnabled = this.getConfig().getBoolean("custom-drops.enabled", false);
        this.customDrops = this.getConfig().getStringList("custom-drops.drops");
        this.treeOverrides.clear();
        ConfigurationSection overridesSection = this.getConfig().getConfigurationSection("tree-overrides");
        if (overridesSection != null) {
            for (String key : overridesSection.getKeys(false)) {
                try {
                    Material material2 = Material.valueOf((String)key.toUpperCase());
                    this.treeOverrides.put(material2, new TreeType(overridesSection.getConfigurationSection(key)));
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid material in tree-overrides section of config.yml: " + key);
                }
            }
        }
        this.worldSettings.clear();
        ConfigurationSection worldSettingsSection = this.getConfig().getConfigurationSection("per-world-settings");
        if (worldSettingsSection != null) {
            for (String worldName : worldSettingsSection.getKeys(false)) {
                this.worldSettings.put(worldName, new WorldSettings(worldSettingsSection.getConfigurationSection(worldName), this));
            }
        }
    }

    public void onDisable() {
        this.getLogger().info("TreeCapitation999 has been disabled!");
    }

    @EventHandler
    public void onTreeBreak(BlockBreakEvent event) {
        LocalPlayer localPlayer;
        com.sk89q.worldedit.util.Location loc;
        RegionContainer container;
        RegionQuery query;
        long secondsLeft;
        Player player = event.getPlayer();
        Block block = event.getBlock();
        WorldSettings worldSettings = this.getWorldSettings(block.getWorld());
        if (!player.hasPermission("treecapitation.use")) {
            return;
        }
        if (this.disabledPlayers.contains(player.getUniqueId())) {
            return;
        }
        if (!this.woodMaterials.contains(block.getType())) {
            return;
        }
        PlayerSettings settings = this.playerSettings.computeIfAbsent(player.getUniqueId(), k -> new PlayerSettings(worldSettings.isSneakToFell(), worldSettings.isAutoReplant()));
        if (settings.isSneakToFell() && !player.isSneaking()) {
            return;
        }
        if (worldSettings.isCooldownEnabled() && this.cooldowns.containsKey(player.getUniqueId()) && (secondsLeft = this.cooldowns.get(player.getUniqueId()) / 1000L + (long)worldSettings.getCooldownDuration() - System.currentTimeMillis() / 1000L) > 0L) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You must wait " + secondsLeft + " seconds before using TreeCapitator again.");
            return;
        }
        if (this.worldGuard != null && !(query = (container = this.worldGuard.getPlatform().getRegionContainer()).createQuery()).testState(loc = BukkitAdapter.adapt((Location)block.getLocation()), localPlayer = WorldGuardPlugin.inst().wrapPlayer(player), new StateFlag[]{Flags.BLOCK_BREAK})) {
            return;
        }
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (worldSettings.isToolsEnabled()) {
            if (tool == null || tool.getType() == Material.AIR) {
                return;
            }
            boolean isListed = worldSettings.getToolList().contains(tool.getType().name());
            if (worldSettings.getToolsMode().equalsIgnoreCase("whitelist") && !isListed) {
                return;
            }
            if (worldSettings.getToolsMode().equalsIgnoreCase("blacklist") && isListed) {
                return;
            }
        } else if (worldSettings.isRequireAxe() && (tool == null || tool.getType() == Material.AIR || !tool.getType().name().endsWith("_AXE"))) {
            return;
        }
        if (this.isFakeVerticalLog(block)) {
            return;
        }
        TreeType treeType = this.treeOverrides.get(block.getType());
        int currentMaxTreeBlocks = treeType != null ? treeType.getMaxTreeBlocks(worldSettings.getMaxTreeBlocks()) : worldSettings.getMaxTreeBlocks();
        double currentDurabilityMultiplier = treeType != null ? treeType.getDurabilityMultiplier(worldSettings.getDurabilityMultiplier()) : worldSettings.getDurabilityMultiplier();
        Set<Block> treeBlocks = this.findConnectedLogsBFS(block, worldSettings.getMaxBreakDistance());
        if (treeBlocks.size() > currentMaxTreeBlocks) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This tree is too large to break!");
            return;
        }
        HashMap<Material, Integer> logCounts = new HashMap<Material, Integer>();
        for (Block block2 : treeBlocks) {
            logCounts.put(block2.getType(), logCounts.getOrDefault(block2.getType(), 0) + 1);
        }
        if (worldSettings.isDropAsOne()) {
            for (Map.Entry entry : logCounts.entrySet()) {
                mat = (Material)entry.getKey();
                int count = (Integer)entry.getValue();
                block.getWorld().dropItemNaturally(block.getLocation(), new ItemStack(mat, count));
            }
            for (Block block3 : treeBlocks) {
                block3.setType(Material.AIR);
            }
        } else {
            for (Block block4 : treeBlocks) {
                mat = block4.getType();
                block4.setType(Material.AIR);
                block4.getWorld().dropItemNaturally(block4.getLocation(), new ItemStack(mat));
            }
        }
        if (worldSettings.isBreakLeaves()) {
            Set<Block> leaves = this.findNearbyLeavesBFS(treeBlocks, worldSettings.getMaxLeavesBreak());
            for (Block leaf : leaves) {
                leaf.setType(Material.AIR);
            }
        }
        if (tool != null && tool.getItemMeta() instanceof Damageable) {
            short maxDurability;
            Damageable dmg = (Damageable)tool.getItemMeta();
            int n = (int)((double)treeBlocks.size() * currentDurabilityMultiplier);
            int newDamage = dmg.getDamage() + n;
            if (newDamage >= (maxDurability = tool.getType().getMaxDurability())) {
                player.getInventory().setItemInMainHand(null);
                player.sendMessage(String.valueOf(ChatColor.RED) + "Your tool broke!");
            } else {
                dmg.setDamage(newDamage);
                tool.setItemMeta((ItemMeta)dmg);
            }
        }
        if (settings.isAutoReplant()) {
            Material sapling;
            Block ground = block.getRelative(0, -1, 0);
            Block block5 = block.getWorld().getBlockAt(block.getLocation());
            if ((ground.getType() == Material.DIRT || ground.getType() == Material.GRASS_BLOCK) && block5.getType() == Material.AIR && (sapling = this.saplingFor(block.getType())) != null) {
                block5.setType(sapling);
            }
        }
        if (this.customDropsEnabled) {
            for (String string : this.customDrops) {
                String[] parts = string.split(":");
                if (parts.length != 3) continue;
                try {
                    Material material = Material.valueOf((String)parts[0]);
                    int amount = Integer.parseInt(parts[1]);
                    double chance = Double.parseDouble(parts[2]);
                    if (!(Math.random() * 100.0 < chance)) continue;
                    block.getWorld().dropItemNaturally(block.getLocation(), new ItemStack(material, amount));
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid custom drop in config.yml: " + string);
                }
            }
        }
        if (worldSettings.isCooldownEnabled()) {
            this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
        }
        if (this.soundsEnabled) {
            try {
                player.playSound(player.getLocation(), Sound.valueOf((String)this.breakSound), this.soundVolume, this.soundPitch);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid sound in config.yml: " + this.breakSound);
            }
        }
        if (this.effectsEnabled) {
            try {
                block.getWorld().spawnParticle(Particle.valueOf((String)this.breakEffect), block.getLocation().add(0.5, 0.5, 0.5), this.particleCount, (Object)this.particleData.createBlockData());
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid effect in config.yml: " + this.breakEffect);
            }
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(String.valueOf(ChatColor.DARK_GREEN) + "TreeCapitator Settings")) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        PlayerSettings settings = this.playerSettings.computeIfAbsent(player.getUniqueId(), k -> new PlayerSettings(this.sneakToFell, this.autoReplant));
        if (clickedItem.getType() == Material.LEATHER_BOOTS) {
            settings.setSneakToFell(!settings.isSneakToFell());
        } else if (clickedItem.getType() == Material.OAK_SAPLING) {
            settings.setAutoReplant(!settings.isAutoReplant());
        }
        SettingsGUI.openGUI(player, settings);
    }

    public WorldSettings getWorldSettings(World world) {
        if (world != null && this.worldSettings.containsKey(world.getName())) {
            return this.worldSettings.get(world.getName());
        }
        return new WorldSettings(this);
    }

    private Set<Block> findConnectedLogsBFS(Block start, int maxDistance) {
        HashSet<Block> found = new HashSet<Block>();
        LinkedList<Block> queue = new LinkedList<Block>();
        HashMap<Block, Integer> distances = new HashMap<Block, Integer>();
        queue.add(start);
        distances.put(start, 0);
        while (!queue.isEmpty()) {
            Block current = (Block)queue.poll();
            int dist = (Integer)distances.get(current);
            if (dist > maxDistance || !this.woodMaterials.contains(current.getType()) || found.contains(current)) continue;
            found.add(current);
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        Block relative;
                        if (x == 0 && y == 0 && z == 0 || found.contains(relative = current.getRelative(x, y, z)) || !this.woodMaterials.contains(relative.getType()) || distances.containsKey(relative) && (Integer)distances.get(relative) <= dist + 1) continue;
                        distances.put(relative, dist + 1);
                        queue.add(relative);
                    }
                }
            }
        }
        return found;
    }

    private Set<Block> findNearbyLeavesBFS(Set<Block> logs, int maxLeaves) {
        HashSet<Block> leavesFound = new HashSet<Block>();
        LinkedList<Block> queue = new LinkedList<Block>();
        for (Block log : logs) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        Block relative;
                        if (x == 0 && y == 0 && (double)z == 0.0 || !this.leafMaterials.contains((relative = log.getRelative(x, y, z)).getType()) || leavesFound.contains(relative)) continue;
                        leavesFound.add(relative);
                        queue.add(relative);
                        if (leavesFound.size() < maxLeaves) continue;
                        return leavesFound;
                    }
                }
            }
        }
        while (!queue.isEmpty() && leavesFound.size() < maxLeaves) {
            Block current = (Block)queue.poll();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        Block relative;
                        if (x == 0 && y == 0 && z == 0 || !this.leafMaterials.contains((relative = current.getRelative(x, y, z)).getType()) || leavesFound.contains(relative)) continue;
                        leavesFound.add(relative);
                        queue.add(relative);
                        if (leavesFound.size() < maxLeaves) continue;
                        return leavesFound;
                    }
                }
            }
        }
        return leavesFound;
    }

    private Material saplingFor(Material logType) {
        switch (logType) {
            case OAK_LOG: 
            case STRIPPED_OAK_LOG: {
                return Material.OAK_SAPLING;
            }
            case SPRUCE_LOG: 
            case STRIPPED_SPRUCE_LOG: {
                return Material.SPRUCE_SAPLING;
            }
            case BIRCH_LOG: 
            case STRIPPED_BIRCH_LOG: {
                return Material.BIRCH_SAPLING;
            }
            case JUNGLE_LOG: 
            case STRIPPED_JUNGLE_LOG: {
                return Material.JUNGLE_SAPLING;
            }
            case ACACIA_LOG: 
            case STRIPPED_ACACIA_LOG: {
                return Material.ACACIA_SAPLING;
            }
            case DARK_OAK_LOG: 
            case STRIPPED_DARK_OAK_LOG: {
                return Material.DARK_OAK_SAPLING;
            }
            case MANGROVE_LOG: 
            case STRIPPED_MANGROVE_LOG: {
                return Material.MANGROVE_PROPAGULE;
            }
            case CHERRY_LOG: 
            case STRIPPED_CHERRY_LOG: {
                return Material.CHERRY_SAPLING;
            }
            case CRIMSON_STEM: 
            case STRIPPED_CRIMSON_STEM: {
                return Material.CRIMSON_FUNGUS;
            }
            case WARPED_STEM: 
            case STRIPPED_WARPED_STEM: {
                return Material.WARPED_FUNGUS;
            }
        }
        return null;
    }

    private boolean isFakeVerticalLog(Block block) {
        Block above = block.getRelative(0, 1, 0);
        Block below = block.getRelative(0, -1, 0);
        boolean aboveIsLog = this.woodMaterials.contains(above.getType());
        boolean belowIsLog = this.woodMaterials.contains(below.getType());
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    Block relative;
                    if (x == 0 && y == 0 && z == 0 || !this.leafMaterials.contains((relative = block.getRelative(x, y, z)).getType())) continue;
                    return false;
                }
            }
        }
        return aboveIsLog || belowIsLog;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("treecapitation")) {
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("reload")) {
                    if (!sender.hasPermission("treecapitation.reload")) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to reload the config.");
                        return true;
                    }
                    this.reloadPluginConfig();
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "TreeCapitation config reloaded.");
                    return true;
                }
                if (args[0].equalsIgnoreCase("toggle")) {
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can toggle the plugin.");
                        return true;
                    }
                    Player player = (Player)sender;
                    if (!player.hasPermission("treecapitation.toggle")) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to toggle TreeCapitation.");
                        return true;
                    }
                    UUID uuid = player.getUniqueId();
                    if (this.disabledPlayers.contains(uuid)) {
                        this.disabledPlayers.remove(uuid);
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "TreeCapitation enabled.");
                    } else {
                        this.disabledPlayers.add(uuid);
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "TreeCapitation disabled.");
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("limits")) {
                    if (!sender.hasPermission("treecapitation.limits")) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to see the limits.");
                        return true;
                    }
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "TreeCapitation Limits:");
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Max Tree Blocks: " + String.valueOf(ChatColor.WHITE) + this.maxTreeBlocks);
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Max Break Distance: " + String.valueOf(ChatColor.WHITE) + this.maxBreakDistance);
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Max Leaves Break: " + String.valueOf(ChatColor.WHITE) + this.maxLeavesBreak);
                    return true;
                }
                if (args[0].equalsIgnoreCase("togglegui")) {
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use the GUI.");
                        return true;
                    }
                    Player player = (Player)sender;
                    if (!player.hasPermission("treecapitation.togglegui")) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use the GUI.");
                        return true;
                    }
                    PlayerSettings settings = this.playerSettings.computeIfAbsent(player.getUniqueId(), k -> new PlayerSettings(this.sneakToFell, this.autoReplant));
                    SettingsGUI.openGUI(player, settings);
                    return true;
                }
            }
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "TreeCapitation commands:");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/treecapitation reload - Reload config");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/treecapitation toggle - Toggle plugin for yourself");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/treecapitation limits - Show plugin limits");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/treecapitation togglegui - Open settings GUI");
            return true;
        }
        return false;
    }

    public boolean isBreakLeaves() {
        return this.breakLeaves;
    }

    public boolean isRequireAxe() {
        return this.requireAxe;
    }

    public boolean isDropAsOne() {
        return this.dropAsOne;
    }

    public boolean isAutoReplant() {
        return this.autoReplant;
    }

    public int getMaxTreeBlocks() {
        return this.maxTreeBlocks;
    }

    public int getMaxBreakDistance() {
        return this.maxBreakDistance;
    }

    public int getMaxLeavesBreak() {
        return this.maxLeavesBreak;
    }

    public boolean isSneakToFell() {
        return this.sneakToFell;
    }

    public boolean isCooldownEnabled() {
        return this.cooldownEnabled;
    }

    public int getCooldownDuration() {
        return this.cooldownDuration;
    }

    public boolean isToolsEnabled() {
        return this.toolsEnabled;
    }

    public String getToolsMode() {
        return this.toolsMode;
    }

    public Set<Material> getToolList() {
        return this.toolList;
    }

    public double getDurabilityMultiplier() {
        return this.durabilityMultiplier;
    }
}

