/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.treecapitation999;

import com.yourname.treecapitation999.TreeCapitation999;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;

public class WorldSettings {
    private final boolean breakLeaves;
    private final boolean requireAxe;
    private final boolean dropAsOne;
    private final boolean autoReplant;
    private final int maxTreeBlocks;
    private final int maxBreakDistance;
    private final int maxLeavesBreak;
    private final boolean sneakToFell;
    private final boolean cooldownEnabled;
    private final int cooldownDuration;
    private final boolean toolsEnabled;
    private final String toolsMode;
    private final Set<String> toolList;
    private final double durabilityMultiplier;

    public WorldSettings(TreeCapitation999 main) {
        this.breakLeaves = main.isBreakLeaves();
        this.requireAxe = main.isRequireAxe();
        this.dropAsOne = main.isDropAsOne();
        this.autoReplant = main.isAutoReplant();
        this.maxTreeBlocks = main.getMaxTreeBlocks();
        this.maxBreakDistance = main.getMaxBreakDistance();
        this.maxLeavesBreak = main.getMaxLeavesBreak();
        this.sneakToFell = main.isSneakToFell();
        this.cooldownEnabled = main.isCooldownEnabled();
        this.cooldownDuration = main.getCooldownDuration();
        this.toolsEnabled = main.isToolsEnabled();
        this.toolsMode = main.getToolsMode();
        this.toolList = main.getToolList().stream().map(Enum::name).collect(Collectors.toSet());
        this.durabilityMultiplier = main.getDurabilityMultiplier();
    }

    public WorldSettings(ConfigurationSection config, TreeCapitation999 main) {
        this.breakLeaves = config.getBoolean("break-leaves", main.isBreakLeaves());
        this.requireAxe = config.getBoolean("require-axe", main.isRequireAxe());
        this.dropAsOne = config.getBoolean("drop-as-one", main.isDropAsOne());
        this.autoReplant = config.getBoolean("auto-replant", main.isAutoReplant());
        this.maxTreeBlocks = config.getInt("max-tree-blocks", main.getMaxTreeBlocks());
        this.maxBreakDistance = config.getInt("max-break-distance", main.getMaxBreakDistance());
        this.maxLeavesBreak = config.getInt("max-leaves-break", main.getMaxLeavesBreak());
        this.sneakToFell = config.getBoolean("sneak-to-fell", main.isSneakToFell());
        this.cooldownEnabled = config.getBoolean("cooldown.enabled", main.isCooldownEnabled());
        this.cooldownDuration = config.getInt("cooldown.duration", main.getCooldownDuration());
        this.toolsEnabled = config.getBoolean("tools.enabled", main.isToolsEnabled());
        this.toolsMode = config.getString("tools.mode", main.getToolsMode());
        this.toolList = config.isSet("tools.list") ? config.getStringList("tools.list").stream().collect(Collectors.toSet()) : main.getToolList().stream().map(Enum::name).collect(Collectors.toSet());
        this.durabilityMultiplier = config.getDouble("durability-multiplier", main.getDurabilityMultiplier());
    }

    public boolean isBreakLeaves() {
        return this.breakLeaves;
    }

    public boolean isRequireAxe() {
        return this.requireAxe;
    }

    public boolean isDropAsOne() {
        return this.dropAsOne;
    }

    public boolean isAutoReplant() {
        return this.autoReplant;
    }

    public int getMaxTreeBlocks() {
        return this.maxTreeBlocks;
    }

    public int getMaxBreakDistance() {
        return this.maxBreakDistance;
    }

    public int getMaxLeavesBreak() {
        return this.maxLeavesBreak;
    }

    public boolean isSneakToFell() {
        return this.sneakToFell;
    }

    public boolean isCooldownEnabled() {
        return this.cooldownEnabled;
    }

    public int getCooldownDuration() {
        return this.cooldownDuration;
    }

    public boolean isToolsEnabled() {
        return this.toolsEnabled;
    }

    public String getToolsMode() {
        return this.toolsMode;
    }

    public Set<String> getToolList() {
        return this.toolList;
    }

    public double getDurabilityMultiplier() {
        return this.durabilityMultiplier;
    }
}

