/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.blockentity.custom;

import com.coolerpromc.uncrafteverything.blockentity.UEBlockEntities;
import com.coolerpromc.uncrafteverything.config.PerItemExpCostConfig;
import com.coolerpromc.uncrafteverything.config.UncraftEverythingConfig;
import com.coolerpromc.uncrafteverything.networking.UncraftingRecipeSelectionRequestPayload;
import com.coolerpromc.uncrafteverything.networking.UncraftingTableDataPayload;
import com.coolerpromc.uncrafteverything.screen.custom.UncraftingTableMenu;
import com.coolerpromc.uncrafteverything.util.ImplementedInventory;
import com.coolerpromc.uncrafteverything.util.UncraftingTableRecipe;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1871;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_8053;
import net.minecraft.class_8057;
import net.minecraft.class_8060;
import net.minecraft.class_8062;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class UncraftingTableBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory {
    public static final int NO_RECIPE = 0;
    public static final int NO_SUITABLE_OUTPUT_SLOT = 1;
    public static final int NO_ENOUGH_EXPERIENCE = 2;
    public static final int NO_ENOUGH_INPUT = 3;
    public static final int SHULKER_WITH_ITEM = 4;
    public static final int RESTRICTED_ITEM = 5;
    public static final int DAMAGED_ITEM = 6;
    public static final int ENCHANTED_ITEM = 7;
    public static final int LOCKED_ITEM = 8;
    public static final int PROGRESSION_NOT_DEFINED = 9;
    private List<UncraftingTableRecipe> currentRecipes = new ArrayList<UncraftingTableRecipe>();
    private UncraftingTableRecipe currentRecipe = null;
    private class_3222 player;
    private final class_3913 data;
    private int experience = 0;
    private int experienceType;
    private int status = -1;
    private class_1799 currentStack = class_1799.field_8037;
    private int page = 0;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)10, (Object)class_1799.field_8037);
    private final int[] inputSlots = new int[]{0};
    private final int[] outputSlots = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    private final ImplementedInventory slots = new ImplementedInventory(10){

        public void method_5447(int slot, class_1799 stack) {
            super.method_5447(slot, stack);
            UncraftingTableBlockEntity.this.getOutputStacks();
            if (UncraftingTableBlockEntity.this.field_11863 != null && !UncraftingTableBlockEntity.this.field_11863.method_8608() && slot == UncraftingTableBlockEntity.this.inputSlots[0] && UncraftingTableBlockEntity.this.player != null) {
                if (UncraftingTableBlockEntity.this.currentStack.method_7909() != this.method_5438(0).method_7909() && !this.method_5438(0).method_7960()) {
                    for (int outputSlot : UncraftingTableBlockEntity.this.outputSlots) {
                        class_1799 outputStack = this.method_5438(outputSlot);
                        if (outputStack.method_7960()) continue;
                        UncraftingTableBlockEntity.this.player.method_31548().method_7398(outputStack);
                        this.method_5447(outputSlot, class_1799.field_8037);
                        this.method_5431();
                    }
                }
                UncraftingTableBlockEntity.this.currentStack = this.method_5438(0);
                UncraftingTableBlockEntity.this.field_11863.method_8413(UncraftingTableBlockEntity.this.field_11867, UncraftingTableBlockEntity.this.method_11010(), UncraftingTableBlockEntity.this.method_11010(), 3);
                int fromIndex = UncraftingTableBlockEntity.this.page * 7;
                if (fromIndex >= UncraftingTableBlockEntity.this.currentRecipes.size()) {
                    fromIndex = UncraftingTableBlockEntity.this.currentRecipes.size();
                }
                int toIndex = Math.min(fromIndex + 7, UncraftingTableBlockEntity.this.currentRecipes.size());
                ServerPlayNetworking.send((class_3222)UncraftingTableBlockEntity.this.player, (class_2960)UncraftingTableDataPayload.ID, (class_2540)UncraftingTableDataPayload.encode(new UncraftingTableDataPayload(UncraftingTableBlockEntity.this.method_11016(), new ArrayList<UncraftingTableRecipe>(UncraftingTableBlockEntity.this.currentRecipes.subList(fromIndex, toIndex)), UncraftingTableBlockEntity.this.currentRecipes.size()), PacketByteBufs.create()));
            }
        }

        public class_1799 method_5441(int slot) {
            UncraftingTableBlockEntity.this.getOutputStacks();
            if (slot != 0 && UncraftingTableBlockEntity.this.player != null) {
                UncraftingTableBlockEntity.this.handleRecipeSelection(UncraftingTableBlockEntity.this.currentRecipe);
            }
            return super.method_5441(slot);
        }

        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 side) {
            return Arrays.asList(new int[][]{UncraftingTableBlockEntity.this.inputSlots}).contains(slot) && side != class_2350.field_11033;
        }

        public boolean method_5493(int slot, class_1799 stack, class_2350 side) {
            return Arrays.asList(new int[][]{UncraftingTableBlockEntity.this.outputSlots}).contains(slot) && side == class_2350.field_11033;
        }

        public boolean method_5437(int slot, class_1799 stack) {
            return Arrays.stream(UncraftingTableBlockEntity.this.outputSlots).noneMatch(value -> value == slot);
        }
    };

    public UncraftingTableBlockEntity(class_2338 pos, class_2680 state) {
        super(UEBlockEntities.UNCRAFTING_TABLE_BE, pos, state);
        this.experienceType = UncraftEverythingConfig.experienceType == UncraftEverythingConfig.ExperienceType.LEVEL ? 1 : 0;
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> UncraftingTableBlockEntity.this.experience;
                    case 1 -> UncraftingTableBlockEntity.this.experienceType;
                    case 2 -> UncraftingTableBlockEntity.this.status;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        UncraftingTableBlockEntity.this.experience = value;
                        break;
                    }
                    case 1: {
                        UncraftingTableBlockEntity.this.experienceType = value;
                        break;
                    }
                    case 2: {
                        UncraftingTableBlockEntity.this.status = value;
                    }
                }
            }

            public int method_17389() {
                return 3;
            }
        };
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.uncrafteverything.uncrafting_table");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer;
            this.player = serverPlayer = (class_3222)player;
        }
        return new UncraftingTableMenu(syncId, playerInventory, this, this.data);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("experience", this.experience);
        nbt.method_10569("experienceType", this.experienceType);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.experience = nbt.method_10550("experience");
        this.experienceType = nbt.method_10550("experienceType");
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public int[] getInputSlots() {
        return this.inputSlots;
    }

    public int[] getOutputSlots() {
        return this.outputSlots;
    }

    public class_2960 inputStackLocation() {
        return class_7923.field_41178.method_10221((Object)this.slots.method_5438(this.inputSlots[0]).method_7909());
    }

    public void getOutputStacks() {
        class_3218 serverLevel;
        block60: {
            block59: {
                class_1937 class_19372 = this.field_11863;
                if (!(class_19372 instanceof class_3218)) break block59;
                serverLevel = (class_3218)class_19372;
                if (this.player != null) break block60;
            }
            return;
        }
        this.status = -1;
        class_1799 inputStack = this.slots.method_5438(this.inputSlots[0]);
        List<String> blacklist = UncraftEverythingConfig.restrictions;
        List<Pattern> wildcardBlacklist = blacklist.stream().filter(s -> s.contains("*")).map(s -> Pattern.compile(s.replace("*", ".*"))).toList();
        if (this.slots.method_5438(this.inputSlots[0]).method_7960() || (Boolean)UncraftEverythingConfig.isItemLocked(this.player, this.slots.method_5438(this.inputSlots[0])).getLeft() != false || this.slots.method_5438(this.inputSlots[0]).method_7919() > 0 && !UncraftEverythingConfig.allowDamaged() || UncraftEverythingConfig.isItemBlacklisted(this.slots.method_5438(this.inputSlots[0])) || UncraftEverythingConfig.isItemWhitelisted(this.slots.method_5438(this.inputSlots[0])) || !UncraftEverythingConfig.isEnchantedItemsAllowed(this.slots.method_5438(this.inputSlots[0])) && inputStack.method_7969() != null && !inputStack.method_7969().method_10545("Trim") || inputStack.method_7909() == class_1802.field_8545 && inputStack.method_7985() || inputStack.method_7909() == class_1802.field_8598) {
            Pair<Boolean, Integer> isItemLocked;
            if (this.slots.method_5438(this.inputSlots[0]).method_7919() > 0 && !UncraftEverythingConfig.allowDamaged()) {
                this.status = 6;
            }
            if (UncraftEverythingConfig.isItemBlacklisted(this.slots.method_5438(this.inputSlots[0]))) {
                this.status = 5;
            }
            if (UncraftEverythingConfig.isItemWhitelisted(this.slots.method_5438(this.inputSlots[0]))) {
                this.status = 5;
            }
            if (!UncraftEverythingConfig.isEnchantedItemsAllowed(this.slots.method_5438(this.inputSlots[0])) && inputStack.method_7969() != null && !inputStack.method_7969().method_10545("Trim")) {
                this.status = 7;
            }
            if (inputStack.method_7909() == class_1802.field_8545 && inputStack.method_7985()) {
                this.status = 4;
            }
            if (this.slots.method_5438(this.inputSlots[0]).method_7960() || inputStack.method_7909() == class_1802.field_8598) {
                this.status = 0;
            }
            if (((Boolean)(isItemLocked = UncraftEverythingConfig.isItemLocked(this.player, this.slots.method_5438(this.inputSlots[0]))).getLeft()).booleanValue() && !this.slots.method_5438(this.inputSlots[0]).method_7960()) {
                this.status = (Integer)isItemLocked.getRight();
            }
            this.currentRecipes.clear();
            this.currentRecipe = null;
            this.experience = 0;
            this.method_5431();
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
            }
            return;
        }
        List<class_1860> recipes = serverLevel.method_8433().method_8126().stream().filter(recipeHolder -> {
            if (!recipeHolder.method_8114().method_12836().equals("minecraft") && class_7923.field_41178.method_10221((Object)inputStack.method_7909()).method_12836().equals("minecraft") && UncraftEverythingConfig.preventModdedIngredientRecipes()) {
                return false;
            }
            if (recipeHolder instanceof class_1869) {
                class_1869 shapedRecipe = (class_1869)recipeHolder;
                if (shapedRecipe.field_9053.method_7909() == inputStack.method_7909() && inputStack.method_7947() < shapedRecipe.field_9053.method_7947()) {
                    this.status = 3;
                }
                if (!class_1890.method_8222((class_1799)inputStack).isEmpty() && UncraftEverythingConfig.outputEnchantedBook()) {
                    return false;
                }
                return shapedRecipe.field_9053.method_7909() == inputStack.method_7909() && inputStack.method_7947() >= shapedRecipe.field_9053.method_7947();
            }
            if (recipeHolder instanceof class_1867) {
                class_1867 shapelessRecipe = (class_1867)recipeHolder;
                if (shapelessRecipe.field_9050.method_7909() == inputStack.method_7909() && inputStack.method_7947() < shapelessRecipe.field_9050.method_7947()) {
                    this.status = 3;
                }
                if (!class_1890.method_8222((class_1799)inputStack).isEmpty() && UncraftEverythingConfig.outputEnchantedBook()) {
                    return false;
                }
                return shapelessRecipe.field_9050.method_7909() == inputStack.method_7909() && inputStack.method_7947() >= shapelessRecipe.field_9050.method_7947();
            }
            if (recipeHolder instanceof class_1871) {
                class_1871 transmuteRecipe = (class_1871)recipeHolder;
                return inputStack.method_31573(ConventionalItemTags.SHULKER_BOXES) && !inputStack.method_31574(class_1802.field_8545);
            }
            if (recipeHolder instanceof class_8060) {
                class_8060 smithingTransformRecipe = (class_8060)recipeHolder;
                if (!UncraftEverythingConfig.allowUnSmithing()) {
                    return false;
                }
                if (!class_1890.method_8222((class_1799)inputStack).isEmpty() && UncraftEverythingConfig.outputEnchantedBook()) {
                    return false;
                }
                return inputStack.method_31574(smithingTransformRecipe.field_42033.method_7909());
            }
            if (recipeHolder instanceof class_8062) {
                class_8062 smithingTrimRecipe = (class_8062)recipeHolder;
                if (!UncraftEverythingConfig.allowUnSmithing()) {
                    return false;
                }
                Optional armorTrim = class_8053.method_48428((class_5455)this.field_11863.method_30349(), (class_1799)inputStack);
                if (armorTrim.isPresent()) {
                    class_1856 ingredient = smithingTrimRecipe.field_42037;
                    Optional trimPatternReference = class_8057.method_48448((class_5455)this.field_11863.method_30349(), (class_1799)smithingTrimRecipe.field_42035.method_8105()[0]);
                    if (ingredient != class_1856.field_9017 && trimPatternReference.isPresent() && ((class_8053)armorTrim.get()).method_48424().equals(trimPatternReference.get())) {
                        return true;
                    }
                }
            }
            if (this.status == -1) {
                this.status = 0;
            }
            return false;
        }).toList();
        if (!recipes.isEmpty() || inputStack.method_31574(class_1802.field_8087) || UncraftEverythingConfig.allowEnchantedItems && !class_1890.method_8222((class_1799)inputStack).isEmpty() && !inputStack.method_7909().equals(class_1802.field_8598)) {
            this.status = -1;
            this.experience = this.getExperience();
            this.experienceType = UncraftEverythingConfig.experienceType == UncraftEverythingConfig.ExperienceType.LEVEL ? 1 : 0;
        }
        ArrayList<UncraftingTableRecipe> outputs = new ArrayList<UncraftingTableRecipe>();
        if (inputStack.method_31574(class_1802.field_8087)) {
            class_1842 potion = class_1844.method_8063((class_1799)inputStack);
            UncraftingTableRecipe outputStack = new UncraftingTableRecipe(new class_1799((class_1935)inputStack.method_7909(), 8));
            class_1799 lingeringPotion = new class_1799((class_1935)class_1802.field_8150);
            class_1844.method_8061((class_1799)lingeringPotion, (class_1842)potion);
            outputStack.addOutput(new class_1799((class_1935)class_1802.field_8107, 1));
            outputStack.addOutput(new class_1799((class_1935)class_1802.field_8107, 1));
            outputStack.addOutput(new class_1799((class_1935)class_1802.field_8107, 1));
            outputStack.addOutput(new class_1799((class_1935)class_1802.field_8107, 1));
            outputStack.addOutput(lingeringPotion);
            outputStack.addOutput(new class_1799((class_1935)class_1802.field_8107, 1));
            outputStack.addOutput(new class_1799((class_1935)class_1802.field_8107, 1));
            outputStack.addOutput(new class_1799((class_1935)class_1802.field_8107, 1));
            outputStack.addOutput(new class_1799((class_1935)class_1802.field_8107, 1));
            outputs.add(outputStack);
        }
        if (!class_1890.method_8222((class_1799)inputStack).isEmpty() && recipes.isEmpty() && !inputStack.method_7909().equals(class_1802.field_8598) && UncraftEverythingConfig.outputEnchantedBook()) {
            UncraftingTableRecipe outputStack = new UncraftingTableRecipe(new class_1799((class_1935)inputStack.method_7909(), 1));
            Map enchantments = class_1890.method_8222((class_1799)inputStack);
            class_1799 book = new class_1799((class_1935)class_1802.field_8598);
            class_1890.method_8214((Map)enchantments, (class_1799)book);
            class_1799 output = new class_1799((class_1935)inputStack.method_7909(), 1);
            output.method_7974(inputStack.method_7919());
            outputStack.addOutput(output);
            outputStack.addOutput(book);
            outputs.add(outputStack);
        }
        for (class_1860 r : recipes) {
            UncraftingTableRecipe outputStack;
            List<List<class_1792>> allIngredientCombinations;
            class_1799 stack;
            Object ingredients;
            if (r instanceof class_1871) {
                class_1871 transmuteRecipe = (class_1871)r;
                if (inputStack.method_31573(ConventionalItemTags.SHULKER_BOXES) && !inputStack.method_31574(class_1802.field_8545)) {
                    ingredients = new ArrayList();
                    class_1856 shulkerBoxIngredient = class_1856.method_8106((class_6862)ConventionalItemTags.SHULKER_BOXES);
                    ingredients.add(shulkerBoxIngredient);
                    class_1856 class_18562 = class_1856.method_8091((class_1935[])new class_1935[]{class_1769.method_7803((class_1767)Objects.requireNonNull(((class_2480)((class_1747)inputStack.method_7909()).method_7711()).method_10528()))});
                    ingredients.add(class_18562);
                    List<List<class_1792>> allIngredientCombinations2 = this.getAllShapelessIngredientCombinations((List<class_1856>)ingredients);
                    class_2487 itemContainerContents = inputStack.method_7969();
                    for (List list : allIngredientCombinations2) {
                        UncraftingTableRecipe outputStack2 = new UncraftingTableRecipe(new class_1799((class_1935)inputStack.method_7909(), 1));
                        for (class_1792 item : list) {
                            if (outputStack2.getOutputs().contains(item.method_7854())) {
                                stack = outputStack2.getOutputs().get(outputStack2.getOutputs().indexOf(item.method_7854()));
                                stack.method_7939(stack.method_7947() + 1);
                                outputStack2.setOutput(outputStack2.getOutputs().indexOf(item.method_7854()), stack);
                                continue;
                            }
                            class_1799 itemStack2 = new class_1799((class_1935)item, 1);
                            if (itemStack2.method_31573(ConventionalItemTags.SHULKER_BOXES)) {
                                itemStack2.method_7980(itemContainerContents);
                            }
                            outputStack2.addOutput(itemStack2);
                        }
                        outputs.add(outputStack2);
                    }
                }
            }
            if (r instanceof class_1869) {
                class_1869 shapedRecipe = (class_1869)r;
                List<List<class_1792>> allIngredientCombinations3 = this.getAllIngredientCombinations((class_2371<class_1856>)shapedRecipe.method_8117());
                for (List list : allIngredientCombinations3) {
                    UncraftingTableRecipe outputStack3 = new UncraftingTableRecipe(new class_1799((class_1935)shapedRecipe.field_9053.method_7909(), shapedRecipe.field_9053.method_7947()));
                    HashMap<class_1792, Integer> allIngredients = new HashMap<class_1792, Integer>();
                    for (class_1792 class_17922 : list) {
                        if (outputStack3.getOutputs().contains(class_17922.method_7854())) {
                            class_1799 stack2 = outputStack3.getOutputs().get(outputStack3.getOutputs().indexOf(class_17922.method_7854()));
                            outputStack3.setOutput(outputStack3.getOutputs().indexOf(class_17922.method_7854()), new class_1799((class_1935)stack2.method_7909(), stack2.method_7947() + 1));
                        } else {
                            outputStack3.addOutput(new class_1799((class_1935)class_17922, 1));
                        }
                        allIngredients.put(class_17922, allIngredients.getOrDefault(class_17922, 0) + 1);
                    }
                    if (inputStack.method_7986()) {
                        for (Map.Entry entry : allIngredients.entrySet()) {
                            if (!inputStack.method_7909().method_7878(inputStack, new class_1799((class_1935)entry.getKey(), ((Integer)entry.getValue()).intValue()))) continue;
                            int damagedPercentage = (int)Math.ceil((double)inputStack.method_7919() / (double)inputStack.method_7936() * (double)((Integer)entry.getValue()).intValue());
                            for (int i = 0; i < outputStack3.getOutputs().size() && damagedPercentage != 0; ++i) {
                                if (!outputStack3.getOutputs().get(i).method_31574((class_1792)entry.getKey())) continue;
                                outputStack3.setOutput(i, class_1799.field_8037);
                                --damagedPercentage;
                            }
                        }
                    }
                    outputs.add(outputStack3);
                }
            }
            if (r instanceof class_1867) {
                class_2487 compoundTag;
                class_1867 shapelessRecipe = (class_1867)r;
                ingredients = new ArrayList(shapelessRecipe.field_9047);
                if (inputStack.method_7985() && inputStack.method_7941("Fireworks") != null && (compoundTag = inputStack.method_7941("Fireworks")) != null) {
                    int n = compoundTag.method_10571("Flight");
                    for (int i = 1; i < n; ++i) {
                        ingredients.add(class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8054}));
                    }
                }
                allIngredientCombinations = this.getAllShapelessIngredientCombinations((List<class_1856>)ingredients);
                for (List<class_1792> ingredientCombination : allIngredientCombinations) {
                    outputStack = new UncraftingTableRecipe(new class_1799((class_1935)shapelessRecipe.field_9050.method_7909(), shapelessRecipe.field_9050.method_7947()));
                    HashMap<class_1792, Integer> allIngredients = new HashMap<class_1792, Integer>();
                    for (class_1792 item : ingredientCombination) {
                        if (item == class_1802.field_8162) continue;
                        if (outputStack.getOutputs().contains(item.method_7854())) {
                            class_1799 stack3 = outputStack.getOutputs().get(outputStack.getOutputs().indexOf(item.method_7854()));
                            outputStack.setOutput(outputStack.getOutputs().indexOf(item.method_7854()), new class_1799((class_1935)stack3.method_7909(), stack3.method_7947() + 1));
                        } else {
                            outputStack.addOutput(new class_1799((class_1935)item, 1));
                        }
                        allIngredients.put(item, allIngredients.getOrDefault(item, 0) + 1);
                    }
                    if (inputStack.method_7986()) {
                        for (Map.Entry x2 : allIngredients.entrySet()) {
                            if (!inputStack.method_7909().method_7878(inputStack, new class_1799((class_1935)x2.getKey(), ((Integer)x2.getValue()).intValue()))) continue;
                            int damagedPercentage = (int)Math.ceil((double)inputStack.method_7919() / (double)inputStack.method_7936() * (double)((Integer)x2.getValue()).intValue());
                            for (int i = 0; i < outputStack.getOutputs().size() && damagedPercentage != 0; ++i) {
                                if (!outputStack.getOutputs().get(i).method_31574((class_1792)x2.getKey())) continue;
                                outputStack.setOutput(i, class_1799.field_8037);
                                --damagedPercentage;
                            }
                        }
                    }
                    outputs.add(outputStack);
                }
            }
            if (r instanceof class_8060) {
                class_8060 smithingTransformRecipe = (class_8060)r;
                ingredients = class_2371.method_10211();
                ingredients.add((Object)smithingTransformRecipe.field_42031);
                ingredients.add((Object)smithingTransformRecipe.field_42032);
                ingredients.add((Object)smithingTransformRecipe.field_42030);
                allIngredientCombinations = this.getAllIngredientCombinations((class_2371<class_1856>)ingredients);
                for (List<class_1792> ingredientCombination : allIngredientCombinations) {
                    outputStack = new UncraftingTableRecipe(smithingTransformRecipe.field_42033);
                    for (class_1792 class_17923 : ingredientCombination) {
                        if (outputStack.getOutputs().contains(class_17923.method_7854())) {
                            class_1799 stack4 = outputStack.getOutputs().get(outputStack.getOutputs().indexOf(class_17923.method_7854()));
                            if (class_17923.method_7854().method_7963()) {
                                stack4.method_7974(inputStack.method_7919());
                            }
                            stack4.method_7933(1);
                            outputStack.setOutput(outputStack.getOutputs().indexOf(class_17923.method_7854()), stack4);
                            continue;
                        }
                        class_1799 itemStack3 = new class_1799((class_1935)class_17923, 1);
                        if (class_17923.method_7854().method_7963()) {
                            itemStack3.method_7974(inputStack.method_7919());
                            if (itemStack3.method_7919() >= itemStack3.method_7936()) {
                                itemStack3 = class_1799.field_8037;
                            }
                        }
                        outputStack.addOutput(itemStack3);
                    }
                    outputs.add(outputStack);
                }
            }
            if (!(r instanceof class_8062)) continue;
            class_8062 smithingTrimRecipe = (class_8062)r;
            Optional armorTrim = class_8053.method_48428((class_5455)this.field_11863.method_30349(), (class_1799)inputStack);
            class_1856 additionIngredient = smithingTrimRecipe.field_42037;
            class_2371 class_23712 = class_2371.method_10211();
            Arrays.stream(smithingTrimRecipe.field_42036.method_8105()).filter(itemStack -> itemStack.method_31574(inputStack.method_7909())).forEach(itemStack -> ingredients2.add((Object)class_1856.method_8101((class_1799[])new class_1799[]{itemStack})));
            class_23712.add((Object)smithingTrimRecipe.field_42035);
            Arrays.stream(smithingTrimRecipe.field_42037.method_8105()).filter(itemStack -> {
                if (armorTrim.isPresent()) {
                    class_5321 armorTrimKey = ((class_8053)armorTrim.get()).method_48431().method_40230().orElse(null);
                    class_5321 itemResourceKey = itemStack.method_41409().method_40230().orElse(null);
                    if (itemResourceKey != null && armorTrimKey != null) {
                        return itemResourceKey.method_29177().method_12832().contains(armorTrimKey.method_29177().method_12832());
                    }
                }
                return false;
            }).forEach(itemStack -> ingredients2.add((Object)class_1856.method_8101((class_1799[])new class_1799[]{itemStack})));
            List<List<class_1792>> allIngredientCombinations2 = this.getAllIngredientCombinations((class_2371<class_1856>)class_23712);
            Map itemEnchantments = class_1890.method_8222((class_1799)inputStack);
            for (List list : allIngredientCombinations2) {
                UncraftingTableRecipe outputStack4 = new UncraftingTableRecipe(inputStack.method_46651(1));
                for (class_1792 item : list) {
                    if (outputStack4.getOutputs().contains(item.method_7854())) {
                        stack = outputStack4.getOutputs().get(outputStack4.getOutputs().indexOf(item.method_7854()));
                        if (item.method_7854().method_31574(((class_1856)class_23712.get(0)).method_8105()[0].method_7909())) {
                            class_1890.method_8214((Map)itemEnchantments, (class_1799)stack);
                            stack.method_7974(inputStack.method_7919());
                        }
                        stack.method_7939(stack.method_7947() + 1);
                        outputStack4.setOutput(outputStack4.getOutputs().indexOf(item.method_7854()), stack);
                        continue;
                    }
                    class_1799 itemStack2 = new class_1799((class_1935)item, 1);
                    if (item.method_7854().method_31574(((class_1856)class_23712.get(0)).method_8105()[0].method_7909())) {
                        class_1890.method_8214((Map)itemEnchantments, (class_1799)itemStack2);
                        itemStack2.method_7974(inputStack.method_7919());
                    }
                    outputStack4.addOutput(itemStack2);
                }
                outputs.add(outputStack4);
            }
        }
        this.currentRecipes = outputs;
        if (!this.currentRecipes.isEmpty()) {
            ServerPlayNetworking.send((class_3222)this.player, (class_2960)UncraftingRecipeSelectionRequestPayload.TYPE, (class_2540)PacketByteBufs.create());
            if (!this.hasRecipe()) {
                this.status = 1;
            } else if (!this.hasEnoughExperience()) {
                this.status = 2;
            }
        } else if (this.status == -1) {
            this.status = 0;
        }
    }

    private List<class_1792> getItemsFromIngredient(class_1856 ingredient) {
        List<Object> items = new ArrayList();
        if (ingredient.getCustomIngredient() != null && !ingredient.getCustomIngredient().getMatchingStacks().isEmpty()) {
            for (class_1799 holder : ingredient.getCustomIngredient().getMatchingStacks()) {
                items.add(holder.method_7909());
            }
        } else {
            try {
                items = Arrays.stream(ingredient.method_8105()).map(class_1799::method_7909).distinct().toList();
            }
            catch (IllegalStateException e) {
                LogUtils.getLogger().warn("Skipping unsupported ingredient type: {}", (Object)ingredient);
                return Collections.emptyList();
            }
        }
        return items.stream().filter(item -> {
            if (item.method_7876().contains("shulker_box")) {
                return item == class_1802.field_8545;
            }
            return item.getRecipeRemainder(item.method_7854()) == class_1799.field_8037 || item.getRecipeRemainder(item.method_7854()).method_7909() != item.method_7854().method_7909();
        }).sorted(Comparator.comparing(class_1792::method_7876)).toList();
    }

    private List<List<class_1792>> getAllIngredientCombinations(class_2371<class_1856> ingredients) {
        HashMap<String, Group> groupKeyToGroup = new HashMap<String, Group>();
        for (int i = 0; i < ingredients.size(); ++i) {
            List<class_1792> items;
            Optional<class_1856> optIngredient = Optional.of((class_1856)ingredients.get(i));
            List<class_1792> finalItems1 = items = optIngredient.map(ingredient -> {
                List<class_1792> ingredientItems = this.getItemsFromIngredient((class_1856)ingredient);
                return ingredientItems.isEmpty() ? List.of(class_1802.field_8162) : ingredientItems;
            }).orElse(List.of(class_1802.field_8162));
            items = items.stream().filter(item -> {
                boolean isVanillaInput = class_7923.field_41178.method_10221((Object)this.slots.method_5438(0).method_7909()).method_12836().equals("minecraft");
                if (isVanillaInput && UncraftEverythingConfig.preventModdedIngredientRecipes()) {
                    return class_7923.field_41178.method_10221(item).method_12836().equals("minecraft");
                }
                if (finalItems1.size() > 1) {
                    class_2960 ingredientRL = class_7923.field_41178.method_10221(item);
                    return !UncraftEverythingConfig.getRestrictedModIngredients().contains(ingredientRL.method_12836());
                }
                return true;
            }).toList();
            String key = items.stream().map(class_1792::method_7876).sorted().collect(Collectors.joining(","));
            List<class_1792> finalItems = items;
            Group group2 = groupKeyToGroup.computeIfAbsent(key, k -> new Group(new ArrayList<Integer>(), finalItems));
            group2.positions.add(i);
        }
        ArrayList groups = new ArrayList(groupKeyToGroup.values());
        List groupChoices = groups.stream().map(group -> group.items).collect(Collectors.toList());
        List product = UncraftingTableBlockEntity.cartesianProduct(groupChoices);
        ArrayList<List<class_1792>> combinations = new ArrayList<List<class_1792>>();
        for (List choiceList : product) {
            Object[] itemsArray = new class_1792[ingredients.size()];
            Arrays.fill(itemsArray, class_1802.field_8162);
            for (int groupIdx = 0; groupIdx < groups.size(); ++groupIdx) {
                Group group3 = (Group)groups.get(groupIdx);
                class_1792 chosenItem = (class_1792)choiceList.get(groupIdx);
                for (int pos : group3.positions) {
                    if (pos < 0 || pos >= itemsArray.length) continue;
                    itemsArray[pos] = chosenItem;
                }
            }
            combinations.add(Arrays.asList(itemsArray));
        }
        return combinations;
    }

    private List<List<class_1792>> getAllShapelessIngredientCombinations(List<class_1856> ingredients) {
        HashMap<String, Group> groupKeyToGroup = new HashMap<String, Group>();
        for (int i = 0; i < ingredients.size(); ++i) {
            class_1856 ingredient = ingredients.get(i);
            List<class_1792> items = this.getItemsFromIngredient(ingredient);
            if (items.isEmpty()) {
                items = List.of(class_1802.field_8162);
            }
            List<class_1792> finalItems1 = items;
            items = items.stream().filter(item -> {
                boolean isVanillaInput = class_7923.field_41178.method_10221((Object)this.slots.method_5438(0).method_7909()).method_12836().equals("minecraft");
                if (isVanillaInput && UncraftEverythingConfig.preventModdedIngredientRecipes()) {
                    return class_7923.field_41178.method_10221(item).method_12836().equals("minecraft");
                }
                if (finalItems1.size() > 1) {
                    class_2960 ingredientRL = class_7923.field_41178.method_10221(item);
                    return !UncraftEverythingConfig.getRestrictedModIngredients().contains(ingredientRL.method_12836());
                }
                return true;
            }).toList();
            String key = items.stream().map(class_1792::method_7876).sorted().collect(Collectors.joining(","));
            List<class_1792> finalItems = items;
            Group group2 = groupKeyToGroup.computeIfAbsent(key, k -> new Group(new ArrayList<Integer>(), finalItems));
            group2.positions.add(i);
        }
        ArrayList groups = new ArrayList(groupKeyToGroup.values());
        List groupChoices = groups.stream().map(group -> group.items).collect(Collectors.toList());
        List product = UncraftingTableBlockEntity.cartesianProduct(groupChoices);
        ArrayList<List<class_1792>> combinations = new ArrayList<List<class_1792>>();
        for (List choiceList : product) {
            Object[] itemsArray = new class_1792[ingredients.size()];
            Arrays.fill(itemsArray, class_1802.field_8162);
            for (int groupIdx = 0; groupIdx < groups.size(); ++groupIdx) {
                Group group3 = (Group)groups.get(groupIdx);
                class_1792 chosenItem = (class_1792)choiceList.get(groupIdx);
                for (int pos : group3.positions) {
                    if (pos < 0 || pos >= itemsArray.length) continue;
                    itemsArray[pos] = chosenItem;
                }
            }
            combinations.add(Arrays.asList(itemsArray));
        }
        return combinations;
    }

    private static <T> List<List<T>> cartesianProduct(List<List<T>> lists) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (lists.isEmpty()) {
            result.add(new ArrayList());
            return result;
        }
        List<T> firstList = lists.get(0);
        List<List<T>> remainingLists = UncraftingTableBlockEntity.cartesianProduct(lists.subList(1, lists.size()));
        for (T item : firstList) {
            for (List<T> remaining : remainingLists) {
                ArrayList<T> combination = new ArrayList<T>();
                combination.add(item);
                combination.addAll(remaining);
                result.add(combination);
            }
        }
        return result;
    }

    public static boolean isVanillaIngredientRecipe(class_1860<?> recipe) {
        Object ingredients;
        if (recipe instanceof class_1869) {
            class_1869 shaped = (class_1869)recipe;
            ingredients = shaped.method_8117();
        } else if (recipe instanceof class_1867) {
            class_1867 shapeless = (class_1867)recipe;
            ingredients = shapeless.method_8117();
        } else if (recipe instanceof class_8060) {
            class_8060 smithingTransformRecipe = (class_8060)recipe;
            ingredients = List.of(smithingTransformRecipe.field_42031, smithingTransformRecipe.field_42032, smithingTransformRecipe.field_42030);
        } else {
            return true;
        }
        for (class_1856 ingredient : ingredients) {
            if (Arrays.stream(ingredient.method_8105()).map(class_1799::method_7909).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0)).map(class_2960::method_12836).toList().contains("minecraft")) continue;
            return false;
        }
        return true;
    }

    public void handleUncraftButtonClicked(boolean hasShiftDown) {
        if (hasShiftDown) {
            while (this.hasRecipe() && this.hasEnoughExperience()) {
                this.processUncraft(this.hasNextRecipe());
            }
        } else if (this.hasRecipe() && this.hasEnoughExperience()) {
            this.processUncraft(false);
        }
    }

    private void processUncraft(boolean hasNext) {
        List<class_1799> outputs = this.currentRecipe.getOutputs();
        for (int i = 0; i < outputs.size(); ++i) {
            class_1799 output = outputs.get(i);
            if (i >= this.outputSlots.length) continue;
            class_1799 slotStack = this.slots.method_5438(this.outputSlots[i]);
            if (slotStack.method_7960()) {
                this.slots.method_5447(this.outputSlots[i], output.method_7972());
                continue;
            }
            if (!class_1799.method_7984((class_1799)slotStack, (class_1799)output) || slotStack.method_7947() + output.method_7947() > slotStack.method_7914()) continue;
            slotStack.method_7933(output.method_7947());
            this.slots.method_5447(this.outputSlots[i], slotStack);
        }
        if (UncraftEverythingConfig.experienceType.equals((Object)UncraftEverythingConfig.ExperienceType.POINT)) {
            this.player.method_7255(-this.getExperience());
        } else if (UncraftEverythingConfig.experienceType.equals((Object)UncraftEverythingConfig.ExperienceType.LEVEL)) {
            this.player.method_7316(-this.getExperience());
        }
        this.slots.method_5434(0, this.currentRecipe.getInput().method_7947());
        this.method_5431();
        this.getOutputStacks();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            if (!hasNext) {
                int fromIndex = this.page * 7;
                if (fromIndex >= this.currentRecipes.size()) {
                    fromIndex = this.currentRecipes.size();
                }
                int toIndex = Math.min(fromIndex + 7, this.currentRecipes.size());
                ServerPlayNetworking.send((class_3222)this.player, (class_2960)UncraftingTableDataPayload.ID, (class_2540)UncraftingTableDataPayload.encode(new UncraftingTableDataPayload(this.method_11016(), new ArrayList<UncraftingTableRecipe>(this.currentRecipes.subList(fromIndex, toIndex)), this.currentRecipes.size()), PacketByteBufs.create()));
            }
        }
    }

    public void handleRecipeSelection(UncraftingTableRecipe recipe) {
        this.currentRecipe = recipe;
        this.status = !this.hasRecipe() ? (this.slots.method_5438(0).method_7960() ? 0 : (((Boolean)UncraftEverythingConfig.isItemLocked(this.player, this.slots.method_5438(this.inputSlots[0])).getLeft()).booleanValue() ? 8 : 1)) : (this.hasEnoughExperience() ? -1 : 2);
    }

    public void updatePage(int page) {
        this.page = page;
        ServerPlayNetworking.send((class_3222)this.player, (class_2960)UncraftingTableDataPayload.ID, (class_2540)UncraftingTableDataPayload.encode(new UncraftingTableDataPayload(this.method_11016(), new ArrayList<UncraftingTableRecipe>(this.currentRecipes.subList(this.currentRecipes.isEmpty() ? 0 : page * 7, Math.min(page * 7 + 7, this.currentRecipes.size()))), this.currentRecipes.size()), PacketByteBufs.create()));
    }

    private int getExperience() {
        Map<String, Integer> experienceMap = PerItemExpCostConfig.getPerItemExp();
        int experience = experienceMap.getOrDefault(this.inputStackLocation().toString(), UncraftEverythingConfig.getExperience());
        for (Map.Entry<String, Integer> exp : experienceMap.entrySet()) {
            String regex;
            String tagName;
            Optional<class_6862<class_1792>> tagKey;
            if (exp.getKey().startsWith("#") && (tagKey = UncraftEverythingConfig.tryParseTagKey(tagName = exp.getKey().substring(1))).isPresent() && this.slots.method_5438(this.inputSlots[0]).method_31573(tagKey.get())) {
                experience = exp.getValue();
                break;
            }
            if (!exp.getKey().contains("*") || !Pattern.matches(regex = exp.getKey().replace("*", ".*"), this.inputStackLocation().toString())) continue;
            experience = exp.getValue();
            break;
        }
        return experience;
    }

    private boolean hasEnoughExperience() {
        if (UncraftEverythingConfig.experienceType.equals((Object)UncraftEverythingConfig.ExperienceType.POINT)) {
            return this.player.field_7495 >= this.getExperience() || this.player.method_7337();
        }
        if (UncraftEverythingConfig.experienceType.equals((Object)UncraftEverythingConfig.ExperienceType.LEVEL)) {
            return this.player.field_7520 >= this.getExperience() || this.player.method_7337();
        }
        return true;
    }

    private boolean hasRecipe() {
        if (this.currentRecipes.isEmpty() || this.currentRecipe == null) {
            return false;
        }
        class_1799 inputStack = this.slots.method_5438(this.inputSlots[0]);
        if (inputStack.method_7947() < this.currentRecipe.getInput().method_7947()) {
            return false;
        }
        List<class_1799> results = this.currentRecipe.getOutputs();
        for (int i = 0; i < results.size(); ++i) {
            class_1799 result = results.get(i);
            if (i >= this.outputSlots.length) {
                return false;
            }
            class_1799 slotStack = this.slots.method_5438(this.outputSlots[i]);
            if (slotStack.method_7960()) continue;
            if (!class_1799.method_7984((class_1799)slotStack, (class_1799)result)) {
                return false;
            }
            if (slotStack.method_7947() + result.method_7947() <= slotStack.method_7914()) continue;
            return false;
        }
        return true;
    }

    private boolean hasNextRecipe() {
        if (this.currentRecipes.isEmpty() || this.currentRecipe == null) {
            return false;
        }
        if (this.slots.method_5438(this.inputSlots[0]).method_7947() - this.currentRecipe.getInput().method_7947() < this.currentRecipe.getInput().method_7947()) {
            return false;
        }
        List<class_1799> results = this.currentRecipe.getOutputs();
        for (int i = 0; i < results.size(); ++i) {
            class_1799 result = results.get(i);
            if (i >= this.outputSlots.length) {
                return false;
            }
            class_1799 slotStack = this.slots.method_5438(this.outputSlots[i]);
            if (slotStack.method_7960()) continue;
            if (!class_1799.method_7984((class_1799)slotStack, (class_1799)result)) {
                return false;
            }
            if (slotStack.method_7947() + result.method_7947() * 2 <= slotStack.method_7914()) continue;
            return false;
        }
        return true;
    }

    public List<UncraftingTableRecipe> getCurrentRecipes() {
        return this.currentRecipes;
    }

    public class_3913 getData() {
        return this.data;
    }

    public ImplementedInventory getSlots() {
        return this.slots;
    }

    private static class Group {
        List<Integer> positions;
        List<class_1792> items;

        Group(List<Integer> positions, List<class_1792> items) {
            this.positions = positions;
            this.items = items;
        }
    }
}

