/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.config;

import com.coolerpromc.uncrafteverything.compat.ftbquests.QuestHelper;
import com.coolerpromc.uncrafteverything.config.FTBQuestProgressionConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.lang3.tuple.Pair;

public class UncraftEverythingConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("uncrafteverything_common.toml");
    private static final ConfigFormat<?> FORMAT = TomlFormat.instance();
    private static CommentedFileConfig configFile;
    public static ExperienceType experienceType;
    public static int experience;
    public static RestrictionType restrictionType;
    public static List<String> restrictions;
    public static boolean allowEnchantedItems;
    public static boolean allowUnSmithing;
    public static boolean allowDamaged;
    public static boolean preventModdedIngredientsFromVanillaItems;
    public static List<String> restrictedModIngredients;
    public static boolean enableProgression;
    public static boolean onlyAllowDefinedProgression;
    public static boolean outputEnchantedBook;

    public static void load() {
        configFile = (CommentedFileConfig)CommentedFileConfig.builder((Path)CONFIG_PATH).autosave().preserveInsertionOrder().sync().build();
        configFile.load();
        UncraftEverythingConfig.applyConfig();
        try {
            FileWatcher.defaultInstance().addWatch(CONFIG_PATH, UncraftEverythingConfig::onConfigFileChanged);
            System.out.println("[UncraftEverything] Config file watcher registered");
        }
        catch (Exception e) {
            System.err.println("[UncraftEverything] Failed to set up config file watcher: " + e.getMessage());
        }
    }

    private static void onConfigFileChanged() {
        System.out.println("[UncraftEverything] Config file changed, reloading...");
        configFile.load();
        UncraftEverythingConfig.applyConfig();
        System.out.println("[UncraftEverything] Config reloaded successfully");
    }

    private static void applyConfig() {
        experienceType = (ExperienceType)configFile.getEnumOrElse("Experience.experienceType", (Enum)ExperienceType.LEVEL);
        experience = Math.max(0, (Integer)configFile.getOrElse("Experience.experiences", (Object)1));
        restrictionType = (RestrictionType)configFile.getEnumOrElse("Restrictions.restrictionType", (Enum)RestrictionType.BLACKLIST);
        restrictions = (List)configFile.getOrElse("Restrictions.restrictions", List.of("uncrafteverything:uncrafting_table", "minecraft:crafting_table"));
        restrictions = restrictions.stream().filter(entry -> {
            try {
                return class_2960.method_12829((String)entry) != null || entry.contains("*") || UncraftEverythingConfig.tryParseTagKey(entry.substring(1)).isPresent();
            }
            catch (Exception e) {
                return false;
            }
        }).toList();
        allowEnchantedItems = (Boolean)configFile.getOrElse("AllowEnchantedItems.allowEnchantedItems", (Object)true);
        allowUnSmithing = (Boolean)configFile.getOrElse("AllowUnSmithing.allowUnSmithing", (Object)true);
        allowDamaged = (Boolean)configFile.getOrElse("AllowDamaged.allowDamaged", (Object)true);
        preventModdedIngredientsFromVanillaItems = (Boolean)configFile.getOrElse("PreventModdedIngredientsFromVanillaItems.preventModdedIngredientsFromVanillaItems", (Object)true);
        restrictedModIngredients = (List)configFile.getOrElse("RestrictedModIngredients.restrictedModIngredients", List.of("productivetrees", "chipped"));
        enableProgression = (Boolean)configFile.getOrElse("FTBQuestProgression.enableProgression", (Object)false);
        onlyAllowDefinedProgression = (Boolean)configFile.getOrElse("FTBQuestProgression.onlyAllowDefinedProgression", (Object)false);
        outputEnchantedBook = (Boolean)configFile.getOrElse("OutputEnchantedBook.outputEnchantedBook", (Object)false);
    }

    public static void save() {
        configFile.set("Experience.experienceType", (Object)experienceType);
        configFile.setComment("Experience.experienceType", "The type of experience to be used.\n[LEVEL/POINT]");
        configFile.set("Experience.experiences", (Object)experience);
        configFile.setComment("Experience.experiences", "The default amount of experience point/level required to uncraft an item. More detailed exp can be configured in uncrafteverything-exp.json");
        configFile.set("Restrictions.restrictionType", (Object)restrictionType);
        configFile.setComment("Restrictions.restrictionType", "The type of restriction to be used.\n[BLACKLIST/WHITELIST]");
        configFile.set("Restrictions.restrictions", restrictions);
        configFile.setComment("Restrictions.restrictions", "A list of items that can/cannot be uncrafted depending on type of restriction.\nInvalid input will cause config reset at runtime.\nFormat: modid:item_name / modid:* / modid:*_glass / modid:black_* / modid:red_*_glass / modid:red_*_glass* / #modid:item_tag_name\nPress F3 + h in game and hover item to check their modid:name");
        configFile.set("AllowEnchantedItems.allowEnchantedItems", (Object)allowEnchantedItems);
        configFile.setComment("AllowEnchantedItems.allowEnchantedItems", "Allow uncrafting of enchanted items. [true/false]");
        configFile.set("AllowUnSmithing.allowUnSmithing", (Object)allowUnSmithing);
        configFile.setComment("AllowUnSmithing.allowUnSmithing", "Allow uncrafting of items that obtained from smithing (Trimmed Armor/Netherite Armor). [true/false]");
        configFile.set("AllowDamaged.allowDamaged", (Object)allowDamaged);
        configFile.setComment("AllowDamaged.allowDamaged", "Allow uncrafting of damaged items. [true/false]");
        configFile.set("PreventModdedIngredientsFromVanillaItems.preventModdedIngredientsFromVanillaItems", (Object)preventModdedIngredientsFromVanillaItems);
        configFile.setComment("PreventModdedIngredientsFromVanillaItems.preventModdedIngredientsFromVanillaItems", "Prevents vanilla items (e.g., iron axe) from being uncrafted using modded recipes. This helps avoid potential duplication or unintended outputs caused by modded ingredients. [true/false]");
        configFile.set("RestrictedModIngredients.restrictedModIngredients", restrictedModIngredients);
        configFile.setComment("RestrictedModIngredients.restrictedModIngredients", "A list of modid that would be excluded when uncrafting, to prevent too much recipes and causing performance issues. \nFormat: modid");
        configFile.set("FTBQuestProgression.enableProgression", (Object)enableProgression);
        configFile.setComment("FTBQuestProgression.enableProgression", "Enable progression based uncrafting recipe search (Only available when FTB Quests is added to the mod pack)");
        configFile.set("FTBQuestProgression.onlyAllowDefinedProgression", (Object)onlyAllowDefinedProgression);
        configFile.setComment("FTBQuestProgression.onlyAllowDefinedProgression", "When FTB Quests is added and progression enabled, only item defined in progression config able to uncraft, all other item will be disabled.");
        configFile.set("OutputEnchantedBook.outputEnchantedBook", (Object)outputEnchantedBook);
        configFile.setComment("OutputEnchantedBook.outputEnchantedBook", "Output Enchanted Book for enchanted item. [true/false]");
        configFile.save();
    }

    public static void shutdown() {
        try {
            FileWatcher fileWatcher = FileWatcher.defaultInstance();
            fileWatcher.removeWatch(CONFIG_PATH);
            fileWatcher.stop();
            System.out.println("[UncraftEverything] Config file watcher removed");
        }
        catch (Exception e) {
            System.err.println("[UncraftEverything] Failed to remove config file watcher: " + e.getMessage());
        }
    }

    public static int getExperience() {
        return experience;
    }

    public static boolean allowDamaged() {
        return allowDamaged;
    }

    public static boolean allowUnSmithing() {
        return allowUnSmithing;
    }

    public static boolean preventModdedIngredientRecipes() {
        return preventModdedIngredientsFromVanillaItems;
    }

    public static boolean isEnchantedItemsAllowed(class_1799 itemStack) {
        return allowEnchantedItems || class_1890.method_8222((class_1799)itemStack).isEmpty();
    }

    public static boolean enableProgression() {
        return enableProgression;
    }

    public static boolean onlyAllowDefinedProgression() {
        return onlyAllowDefinedProgression;
    }

    public static boolean outputEnchantedBook() {
        return outputEnchantedBook;
    }

    public static Pair<Boolean, Integer> isItemLocked(class_3222 player, class_1799 itemStack) {
        if (UncraftEverythingConfig.enableProgression() && QuestHelper.FTBQUESTS_LOADED) {
            String questId = FTBQuestProgressionConfig.getQuestId(itemStack);
            if (UncraftEverythingConfig.onlyAllowDefinedProgression()) {
                return Pair.of((Object)(questId == null || !QuestHelper.hasCompletedQuestOrChapter(player, questId) ? 1 : 0), (Object)(questId == null ? 9 : 8));
            }
            return Pair.of((Object)(questId != null && !QuestHelper.hasCompletedQuestOrChapter(player, questId) ? 1 : 0), (Object)8);
        }
        return Pair.of((Object)false, (Object)-1);
    }

    public static boolean isItemBlacklisted(class_1799 itemStack) {
        if (restrictionType != RestrictionType.BLACKLIST) {
            return false;
        }
        class_2960 itemLocation = UncraftEverythingConfig.inputStackLocation(itemStack);
        String itemLocationString = itemLocation.toString();
        if (restrictions.contains(itemLocationString)) {
            return true;
        }
        for (String entry : restrictions) {
            String regex;
            String tagName;
            Optional<class_6862<class_1792>> tagKey;
            if (entry.startsWith("#") && (tagKey = UncraftEverythingConfig.tryParseTagKey(tagName = entry.substring(1))).isPresent() && itemStack.method_31573(tagKey.get())) {
                return true;
            }
            if (!entry.contains("*") || !itemLocationString.matches(regex = entry.replace("*", ".*"))) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemWhitelisted(class_1799 itemStack) {
        if (restrictionType != RestrictionType.WHITELIST) {
            return false;
        }
        class_2960 itemLocation = UncraftEverythingConfig.inputStackLocation(itemStack);
        String itemLocationString = itemLocation.toString();
        if (restrictions.contains(itemLocationString)) {
            return false;
        }
        for (String entry : restrictions) {
            String regex;
            String tagName;
            Optional<class_6862<class_1792>> tagKey;
            if (entry.startsWith("#") && (tagKey = UncraftEverythingConfig.tryParseTagKey(tagName = entry.substring(1))).isPresent() && itemStack.method_31573(tagKey.get())) {
                return false;
            }
            if (!entry.contains("*") || !itemLocationString.matches(regex = entry.replace("*", ".*"))) continue;
            return false;
        }
        return true;
    }

    public static List<String> getRestrictedModIngredients() {
        return restrictedModIngredients;
    }

    public static class_2960 inputStackLocation(class_1799 itemStack) {
        return class_7923.field_41178.method_10221((Object)itemStack.method_7909());
    }

    public static Optional<class_6862<class_1792>> tryParseTagKey(String input) {
        try {
            class_2960 location = new class_2960(input);
            return Optional.of(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)location));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static enum ExperienceType {
        LEVEL,
        POINT;

    }

    public static enum RestrictionType {
        BLACKLIST,
        WHITELIST;

    }
}

