/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.screen.custom;

import com.coolerpromc.uncrafteverything.UncraftEverythingClient;
import com.coolerpromc.uncrafteverything.networking.RequestConfigPayload;
import com.coolerpromc.uncrafteverything.networking.UEProgressionPayload;
import com.coolerpromc.uncrafteverything.screen.custom.AbstractScrollableScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class FTBQuestsProgressionConfigScreen
extends AbstractScrollableScreen {
    private final class_437 parent;
    private final List<Entry> entries = new ArrayList<Entry>();
    private final int ENTRY_HEIGHT = 24;
    private final int ENTRIES_START_Y = 30;
    private final int ENTRIES_END_Y = 200;
    private boolean hasLoadedFromConfig = false;
    private class_4185 addButton;
    private class_4185 cancelButton;
    private class_4185 saveButton;
    private final List<class_342> scrollableEditBoxes = new ArrayList<class_342>();
    private final List<class_4185> scrollableButtons = new ArrayList<class_4185>();

    public FTBQuestsProgressionConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"screen.uncrafteverything.ftb_quest_progression_config"), 200);
        this.parent = parent;
    }

    protected void method_25426() {
        this.saveCurrentValues();
        this.method_37067();
        this.scrollableEditBoxes.clear();
        this.scrollableButtons.clear();
        if (!this.hasLoadedFromConfig) {
            for (Map.Entry<String, String> entry : UncraftEverythingClient.payloadFromServer.ftbQuestProgression().entrySet()) {
                this.entries.add(new Entry(entry.getKey(), entry.getValue()));
            }
            this.hasLoadedFromConfig = true;
        }
        int visibleHeight = 170;
        this.contentHeight = this.entries.size() * 24 + 16;
        int startIndex = (int)(this.scrollAmount / 24.0);
        int endIndex = Math.min(this.entries.size(), startIndex + visibleHeight / 24 + 2);
        for (int i = startIndex; i < endIndex; ++i) {
            Entry entry = this.entries.get(i);
            int y = (int)((double)(30 + i * 24) - this.scrollAmount);
            if (y < 6 || y > 200) continue;
            entry.initWidgets(this.field_22789 / 2 - 170, y + 16);
            entry.addToScreen(this);
        }
        this.addButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.uncrafteverything.add_new_entry"), b -> {
            this.entries.add(new Entry("", ""));
            this.method_25426();
        }).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 53, 200, 20).method_46431();
        this.method_37063((class_364)this.addButton);
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.uncrafteverything.cancel"), button -> this.method_25419()).method_46434(this.field_22789 / 2 - this.field_22789 / 3 - 10, this.field_22790 - 28, this.field_22789 / 3, 20).method_46431();
        this.method_37063((class_364)this.cancelButton);
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.uncrafteverything.save"), this::saveButtonPressed).method_46434(this.field_22789 / 2 + 10, this.field_22790 - 28, this.field_22789 / 3, 20).method_46431();
        this.method_37063((class_364)this.saveButton);
    }

    private void saveButtonPressed(class_4185 button) {
        this.saveCurrentValues();
        HashMap<String, String> newConfig = new HashMap<String, String>();
        for (Entry entry : this.entries) {
            String key = entry.currentKey.trim();
            String val = entry.currentValue.trim();
            if (key.isEmpty() || val.isEmpty()) continue;
            newConfig.put(key, val);
        }
        UEProgressionPayload configPayload = new UEProgressionPayload(newConfig);
        ClientPlayNetworking.send((class_2960)UEProgressionPayload.TYPE, (class_2540)UEProgressionPayload.encode(PacketByteBufs.create(), configPayload));
        ClientPlayNetworking.send((class_2960)RequestConfigPayload.TYPE, (class_2540)RequestConfigPayload.encode(PacketByteBufs.create(), new RequestConfigPayload()));
        this.field_22787.method_1507(this.parent);
    }

    private void saveCurrentValues() {
        for (Entry entry : this.entries) {
            if (entry.keyBox != null) {
                entry.currentKey = entry.keyBox.method_1882();
            }
            if (entry.valueBox == null) continue;
            entry.currentValue = entry.valueBox.method_1882();
        }
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double delta) {
        super.method_25401(mouseX, mouseY, delta);
        this.method_25426();
        return true;
    }

    @Override
    protected int scrollBarX() {
        return this.field_22789 - 6;
    }

    @Override
    protected int scrollBarY() {
        int scrollBarHeight = Math.max(10, (int)((double)((this.field_22790 - 90) * (this.field_22790 - 90)) / (double)this.contentHeight));
        return (int)(25.0 + this.scrollAmount / (double)this.getMaxScroll() * (double)(this.field_22790 - 90 - scrollBarHeight));
    }

    @Override
    protected int scrollerHeight() {
        return Math.max(10, (int)((double)((this.field_22790 - 90) * (this.field_22790 - 90)) / (double)this.contentHeight));
    }

    @Override
    protected int getMaxScroll() {
        return Math.max(0, this.contentHeight - (this.field_22790 - 95));
    }

    public void method_25420(class_332 guiGraphics) {
        guiGraphics.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        this.renderSeparator(guiGraphics);
        this.renderScrollbar(guiGraphics, 90);
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.method_25420(guiGraphics);
        int n = this.field_22789 / 2;
        Objects.requireNonNull(this.field_22793);
        guiGraphics.method_27534(this.field_22793, this.field_22785, n, (23 - 9) / 2, -1);
        guiGraphics.method_44379(0, 25, this.field_22789, this.field_22790 - 65);
        class_5250 key = class_2561.method_43471((String)"screen.uncrafteverything.per_item_xp_config.key");
        guiGraphics.method_51439(this.field_22793, (class_2561)key, this.field_22789 / 2 - 170 + (150 - this.field_22793.method_27525((class_5348)key)) / 2, (int)(30.0 - this.scrollAmount), -1, false);
        class_5250 value = class_2561.method_43471((String)"screen.uncrafteverything.ftb_quest_progression_config.value");
        guiGraphics.method_51439(this.field_22793, (class_2561)value, this.field_22789 / 2 - 170 + 160 + (150 - this.field_22793.method_27525((class_5348)value)) / 2, (int)(30.0 - this.scrollAmount), -1, false);
        class_5250 del = class_2561.method_43471((String)"screen.uncrafteverything.per_item_xp_config.del");
        guiGraphics.method_51439(this.field_22793, (class_2561)del, this.field_22789 / 2 - 170 + 320 + (20 - this.field_22793.method_27525((class_5348)del)) / 2, (int)(30.0 - this.scrollAmount), -1, false);
        for (class_342 editBox : this.scrollableEditBoxes) {
            editBox.method_25394(guiGraphics, mouseX, mouseY, delta);
        }
        for (class_4185 button : this.scrollableButtons) {
            button.method_25394(guiGraphics, mouseX, mouseY, delta);
        }
        guiGraphics.method_44380();
        this.method_25396().forEach(renderable -> {
            if (renderable instanceof class_4185) {
                class_4185 buttonWidget = (class_4185)renderable;
                if (!this.scrollableButtons.contains(renderable)) {
                    buttonWidget.method_25394(guiGraphics, mouseX, mouseY, delta);
                }
            }
        });
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean inScrollArea;
        int scrollTop = 25;
        int scrollBottom = this.field_22790 - 65;
        boolean bl = inScrollArea = mouseY >= (double)scrollTop && mouseY <= (double)scrollBottom;
        if (!inScrollArea) {
            if (!(this.addButton.method_25405(mouseX, mouseY) || this.cancelButton.method_25405(mouseX, mouseY) || this.saveButton.method_25405(mouseX, mouseY))) {
                return false;
            }
            if (this.addButton.method_25405(mouseX, mouseY)) {
                return this.addButton.method_25402(mouseX, mouseY, button);
            }
            if (this.cancelButton.method_25405(mouseX, mouseY)) {
                return this.cancelButton.method_25402(mouseX, mouseY, button);
            }
            if (this.saveButton.method_25405(mouseX, mouseY)) {
                return this.saveButton.method_25402(mouseX, mouseY, button);
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    protected void renderSeparator(class_332 guiGraphics) {
        class_2960 header = new class_2960("uncrafteverything", "textures/gui/widget/header_separator.png");
        class_2960 footer = new class_2960("uncrafteverything", "textures/gui/widget/footer_separator.png");
        guiGraphics.method_25290(header, 0, 23, 0.0f, 0.0f, this.field_22789, 2, 32, 2);
        guiGraphics.method_25290(footer, 0, this.field_22790 - 65, 0.0f, 0.0f, this.field_22789, 2, 32, 2);
    }

    private class Entry {
        class_342 keyBox;
        class_342 valueBox;
        class_4185 deleteButton;
        String currentKey;
        String currentValue;

        Entry(String key, String value) {
            this.currentKey = key;
            this.currentValue = value;
        }

        void initWidgets(int x, int y) {
            this.keyBox = new class_342(FTBQuestsProgressionConfigScreen.this.field_22793, x, y, 150, 20, (class_2561)class_2561.method_43471((String)"screen.uncrafteverything.key"));
            this.keyBox.method_1852(this.currentKey);
            this.valueBox = new class_342(FTBQuestsProgressionConfigScreen.this.field_22793, x + 160, y, 150, 20, (class_2561)class_2561.method_43471((String)"screen.uncrafteverything.value"));
            this.valueBox.method_1852(this.currentValue);
            this.deleteButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.uncrafteverything.x"), b -> {
                FTBQuestsProgressionConfigScreen.this.entries.remove(this);
                FTBQuestsProgressionConfigScreen.this.method_25426();
            }).method_46434(x + 320, y, 20, 20).method_46431();
        }

        void addToScreen(FTBQuestsProgressionConfigScreen screen) {
            screen.method_37063((class_364)this.keyBox);
            screen.method_37063((class_364)this.valueBox);
            screen.method_37063((class_364)this.deleteButton);
            screen.scrollableEditBoxes.add(this.keyBox);
            screen.scrollableEditBoxes.add(this.valueBox);
            screen.scrollableButtons.add(this.deleteButton);
        }
    }
}

