/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.blockentity.custom;

import com.coolerpromc.uncrafteverything.blockentity.UEBlockEntities;
import com.coolerpromc.uncrafteverything.config.PerItemExpCostConfig;
import com.coolerpromc.uncrafteverything.config.UncraftEverythingConfig;
import com.coolerpromc.uncrafteverything.networking.UncraftingRecipeSelectionRequestPayload;
import com.coolerpromc.uncrafteverything.networking.UncraftingTableDataPayload;
import com.coolerpromc.uncrafteverything.screen.custom.UncraftingTableMenu;
import com.coolerpromc.uncrafteverything.util.ModItemStackHandler;
import com.coolerpromc.uncrafteverything.util.UncraftingTableRecipe;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.crafting.TransmuteRecipe;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UncraftingTableBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final int NO_RECIPE = 0;
    public static final int NO_SUITABLE_OUTPUT_SLOT = 1;
    public static final int NO_ENOUGH_EXPERIENCE = 2;
    public static final int NO_ENOUGH_INPUT = 3;
    public static final int SHULKER_WITH_ITEM = 4;
    public static final int RESTRICTED_ITEM = 5;
    public static final int DAMAGED_ITEM = 6;
    public static final int ENCHANTED_ITEM = 7;
    public static final int LOCKED_ITEM = 8;
    public static final int PROGRESSION_NOT_DEFINED = 9;
    private List<UncraftingTableRecipe> currentRecipes = new ArrayList<UncraftingTableRecipe>();
    private UncraftingTableRecipe currentRecipe = null;
    private ServerPlayer player;
    private final ContainerData data;
    private int experience = 0;
    private int experienceType;
    private int status = -1;
    private ItemStack currentStack = ItemStack.EMPTY;
    private int page = 0;
    private final ModItemStackHandler inputHandler = new ModItemStackHandler(1){

        protected void onContentsChanged(int index, ItemStack previousContents) {
            UncraftingTableBlockEntity.this.setChanged();
            UncraftingTableBlockEntity.this.getOutputStacks();
            if (UncraftingTableBlockEntity.this.level != null && !UncraftingTableBlockEntity.this.level.isClientSide() && UncraftingTableBlockEntity.this.player != null) {
                if (UncraftingTableBlockEntity.this.currentStack.getItem() != ((ItemResource)this.getResource(0)).getItem() && !((ItemResource)this.getResource(0)).isEmpty()) {
                    for (int i = 0; i < UncraftingTableBlockEntity.this.getOutputHandler().size(); ++i) {
                        ItemStack outputStack = (ItemStack)UncraftingTableBlockEntity.this.getOutputHandler().copyToList().get(i);
                        if (outputStack.isEmpty()) continue;
                        UncraftingTableBlockEntity.this.player.getInventory().placeItemBackInInventory(outputStack);
                        UncraftingTableBlockEntity.this.getOutputHandler().set(i, (Resource)ItemResource.EMPTY, 0);
                        UncraftingTableBlockEntity.this.setChanged();
                    }
                }
                UncraftingTableBlockEntity.this.currentStack = ((ItemResource)this.getResource(0)).toStack(this.getAmountAsInt(0));
                UncraftingTableBlockEntity.this.level.sendBlockUpdated(UncraftingTableBlockEntity.this.getBlockPos(), UncraftingTableBlockEntity.this.getBlockState(), UncraftingTableBlockEntity.this.getBlockState(), 3);
                int fromIndex = UncraftingTableBlockEntity.this.page * 7;
                if (fromIndex >= UncraftingTableBlockEntity.this.currentRecipes.size()) {
                    fromIndex = UncraftingTableBlockEntity.this.currentRecipes.size();
                }
                int toIndex = Math.min(fromIndex + 7, UncraftingTableBlockEntity.this.currentRecipes.size());
                PacketDistributor.sendToPlayer((ServerPlayer)UncraftingTableBlockEntity.this.player, (CustomPacketPayload)new UncraftingTableDataPayload(UncraftingTableBlockEntity.this.getBlockPos(), new ArrayList<UncraftingTableRecipe>(UncraftingTableBlockEntity.this.currentRecipes.subList(fromIndex, toIndex)), UncraftingTableBlockEntity.this.currentRecipes.size()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        protected int getCapacity(int index, ItemResource resource) {
            String stackableItems = "com.dplayend.stackableitems.handler.HandlerConfig$Server";
            String fieldName = "defaultStackSize";
            try {
                Class<?> handlerConfigClass = Class.forName("com.dplayend.stackableitems.handler.HandlerConfig");
                Field serverField = handlerConfigClass.getDeclaredField("SERVER");
                serverField.setAccessible(true);
                Object serverInstance = serverField.get(null);
                Class<?> serverClass = serverField.getType();
                Field defaultStackSizeField = serverClass.getDeclaredField("defaultStackSize");
                defaultStackSizeField.setAccessible(true);
                Object value = defaultStackSizeField.get(serverInstance);
                return (Integer)value;
            }
            catch (Exception e) {
                return super.getCapacity(index, resource);
            }
        }
    };
    private final ItemStacksResourceHandler outputHandler = new ItemStacksResourceHandler(9){

        protected void onContentsChanged(int index, ItemStack previousContents) {
            UncraftingTableBlockEntity.this.setChanged();
            if (UncraftingTableBlockEntity.this.player != null) {
                UncraftingTableBlockEntity.this.handleRecipeSelection(UncraftingTableBlockEntity.this.currentRecipe);
            }
            if (UncraftingTableBlockEntity.this.level != null && !UncraftingTableBlockEntity.this.level.isClientSide()) {
                UncraftingTableBlockEntity.this.level.sendBlockUpdated(UncraftingTableBlockEntity.this.getBlockPos(), UncraftingTableBlockEntity.this.getBlockState(), UncraftingTableBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isValid(int index, ItemResource resource) {
            return false;
        }

        protected int getCapacity(int index, ItemResource resource) {
            String stackableItems = "com.dplayend.stackableitems.handler.HandlerConfig$Server";
            String fieldName = "defaultStackSize";
            try {
                Class<?> handlerConfigClass = Class.forName("com.dplayend.stackableitems.handler.HandlerConfig");
                Field serverField = handlerConfigClass.getDeclaredField("SERVER");
                serverField.setAccessible(true);
                Object serverInstance = serverField.get(null);
                Class<?> serverClass = serverField.getType();
                Field defaultStackSizeField = serverClass.getDeclaredField("defaultStackSize");
                defaultStackSizeField.setAccessible(true);
                Object value = defaultStackSizeField.get(serverInstance);
                return (Integer)value;
            }
            catch (Exception e) {
                return super.getCapacity(index, resource);
            }
        }
    };

    public UncraftingTableBlockEntity(BlockPos pos, BlockState blockState) {
        super(UEBlockEntities.UNCRAFTING_TABLE_BE.get(), pos, blockState);
        this.experienceType = UncraftEverythingConfig.CONFIG.experienceType.getRaw() == UncraftEverythingConfig.ExperienceType.LEVEL ? 1 : 0;
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> UncraftingTableBlockEntity.this.experience;
                    case 1 -> UncraftingTableBlockEntity.this.experienceType;
                    case 2 -> UncraftingTableBlockEntity.this.status;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        UncraftingTableBlockEntity.this.experience = value;
                        break;
                    }
                    case 1: {
                        UncraftingTableBlockEntity.this.experienceType = value;
                        break;
                    }
                    case 2: {
                        UncraftingTableBlockEntity.this.status = value;
                    }
                }
            }

            public int getCount() {
                return 3;
            }
        };
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.uncrafteverything.uncrafting_table");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer;
            this.player = serverPlayer = (ServerPlayer)player;
        }
        return new UncraftingTableMenu(containerId, playerInventory, this, this.data);
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        this.inputHandler.serialize(valueOutput.child("input"));
        this.outputHandler.serialize(valueOutput.child("output"));
        valueOutput.putInt("experience", this.experience);
        valueOutput.putInt("experienceType", this.experienceType);
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.inputHandler.deserialize(valueInput.childOrEmpty("input"));
        this.outputHandler.deserialize(valueInput.childOrEmpty("output"));
        this.experience = valueInput.getIntOr("experience", 0);
        this.experienceType = valueInput.getIntOr("experienceType", 0);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public ItemStacksResourceHandler getInputHandler() {
        return this.inputHandler;
    }

    public ItemStacksResourceHandler getOutputHandler() {
        return this.outputHandler;
    }

    public ResourceLocation inputStackLocation() {
        return BuiltInRegistries.ITEM.getKey((Object)((ItemResource)this.inputHandler.getResource(0)).getItem());
    }

    public void getOutputStacks() {
        Recipe output;
        ServerLevel serverLevel;
        block68: {
            block67: {
                Level level = this.level;
                if (!(level instanceof ServerLevel)) break block67;
                serverLevel = (ServerLevel)level;
                if (this.player != null) break block68;
            }
            return;
        }
        this.status = -1;
        ItemStack inputStack = ((ItemResource)this.inputHandler.getResource(0)).toStack(this.inputHandler.getAmountAsInt(0));
        List blacklist = (List)UncraftEverythingConfig.CONFIG.restrictions.get();
        List<Pattern> wildcardBlacklist = blacklist.stream().filter(s -> s.contains("*")).map(s -> Pattern.compile(s.replace("*", ".*"))).toList();
        if (((ItemResource)this.inputHandler.getResource(0)).isEmpty() || (Boolean)UncraftEverythingConfig.isItemLocked(this.player, ((ItemResource)this.inputHandler.getResource(0)).toStack()).getLeft() != false || ((ItemResource)this.inputHandler.getResource(0)).toStack().getDamageValue() > 0 && !UncraftEverythingConfig.CONFIG.allowDamaged() || UncraftEverythingConfig.CONFIG.isItemBlacklisted(((ItemResource)this.inputHandler.getResource(0)).toStack()) || UncraftEverythingConfig.CONFIG.isItemWhitelisted(((ItemResource)this.inputHandler.getResource(0)).toStack()) || !UncraftEverythingConfig.CONFIG.isEnchantedItemsAllowed(((ItemResource)this.inputHandler.getResource(0)).toStack()) && !inputStack.has(DataComponents.TRIM) || inputStack.getItem() == Items.SHULKER_BOX && inputStack.get(DataComponents.CONTAINER) != ItemContainerContents.EMPTY || inputStack.getItem() == Items.ENCHANTED_BOOK) {
            Pair<Boolean, Integer> isItemLocked;
            if (((ItemResource)this.inputHandler.getResource(0)).toStack().getDamageValue() > 0 && !UncraftEverythingConfig.CONFIG.allowDamaged()) {
                this.status = 6;
            }
            if (UncraftEverythingConfig.CONFIG.isItemBlacklisted(((ItemResource)this.inputHandler.getResource(0)).toStack())) {
                this.status = 5;
            }
            if (UncraftEverythingConfig.CONFIG.isItemWhitelisted(((ItemResource)this.inputHandler.getResource(0)).toStack())) {
                this.status = 5;
            }
            if (!UncraftEverythingConfig.CONFIG.isEnchantedItemsAllowed(((ItemResource)this.inputHandler.getResource(0)).toStack()) && !inputStack.has(DataComponents.TRIM)) {
                this.status = 7;
            }
            if (inputStack.getItem() == Items.SHULKER_BOX && inputStack.get(DataComponents.CONTAINER) != ItemContainerContents.EMPTY) {
                this.status = 4;
            }
            if (((ItemResource)this.inputHandler.getResource(0)).isEmpty() || ((ItemResource)this.inputHandler.getResource(0)).getItem() == Items.ENCHANTED_BOOK) {
                this.status = 0;
            }
            if (((Boolean)(isItemLocked = UncraftEverythingConfig.isItemLocked(this.player, ((ItemResource)this.inputHandler.getResource(0)).toStack())).getLeft()).booleanValue() && !((ItemResource)this.inputHandler.getResource(0)).isEmpty()) {
                this.status = (Integer)isItemLocked.getRight();
            }
            this.currentRecipes.clear();
            this.currentRecipe = null;
            this.experience = 0;
            this.setChanged();
            if (this.level != null && !this.level.isClientSide()) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
            return;
        }
        List<RecipeHolder> recipes = serverLevel.recipeAccess().getRecipes().stream().filter(recipeHolder -> {
            Equippable component;
            if (!recipeHolder.id().location().getNamespace().equals("minecraft") && BuiltInRegistries.ITEM.getKey((Object)inputStack.getItem()).getNamespace().equals("minecraft") && UncraftEverythingConfig.CONFIG.preventModdedIngredientRecipes()) {
                return false;
            }
            Recipe patt0$temp = recipeHolder.value();
            if (patt0$temp instanceof ShapedRecipe) {
                ResourceLocation assetId;
                ShapedRecipe shapedRecipe = (ShapedRecipe)patt0$temp;
                if (shapedRecipe.result.getItem() == inputStack.getItem() && inputStack.getCount() < shapedRecipe.result.getCount()) {
                    this.status = 3;
                }
                if (inputStack.get(DataComponents.ENCHANTMENTS) != ItemEnchantments.EMPTY && UncraftEverythingConfig.CONFIG.outputEnchantedBook()) {
                    return false;
                }
                component = (Equippable)inputStack.get(DataComponents.EQUIPPABLE);
                if (component != null && component.slot() == EquipmentSlot.CHEST && component.assetId().isPresent() && (assetId = ((ResourceKey)component.assetId().get()).location()).getNamespace().equals("elytra_chestplate")) {
                    return false;
                }
                return shapedRecipe.result.getItem() == inputStack.getItem() && inputStack.getCount() >= shapedRecipe.result.getCount();
            }
            Recipe patt1$temp = recipeHolder.value();
            if (patt1$temp instanceof ShapelessRecipe) {
                ShapelessRecipe shapelessRecipe = (ShapelessRecipe)patt1$temp;
                if (shapelessRecipe.result.getItem() == inputStack.getItem() && inputStack.getCount() < shapelessRecipe.result.getCount()) {
                    this.status = 3;
                }
                if (inputStack.get(DataComponents.ENCHANTMENTS) != ItemEnchantments.EMPTY && UncraftEverythingConfig.CONFIG.outputEnchantedBook()) {
                    return false;
                }
                return shapelessRecipe.result.getItem() == inputStack.getItem() && inputStack.getCount() >= shapelessRecipe.result.getCount();
            }
            Recipe patt2$temp = recipeHolder.value();
            if (patt2$temp instanceof TransmuteRecipe) {
                TransmuteRecipe transmuteRecipe = (TransmuteRecipe)patt2$temp;
                return transmuteRecipe.result.item().value() == inputStack.getItem();
            }
            Recipe patt3$temp = recipeHolder.value();
            if (patt3$temp instanceof SmithingTransformRecipe) {
                SmithingTransformRecipe smithingTransformRecipe = (SmithingTransformRecipe)patt3$temp;
                if (!UncraftEverythingConfig.CONFIG.allowUnSmithing()) {
                    return false;
                }
                if (inputStack.get(DataComponents.ENCHANTMENTS) != ItemEnchantments.EMPTY && UncraftEverythingConfig.CONFIG.outputEnchantedBook()) {
                    return false;
                }
                component = (Equippable)inputStack.get(DataComponents.EQUIPPABLE);
                if (component != null && component.slot() == EquipmentSlot.CHEST && component.assetId().isPresent()) {
                    ResourceLocation assetId = ((ResourceKey)component.assetId().get()).location();
                    if (!assetId.getNamespace().equals("elytra_chestplate") && smithingTransformRecipe.templateIngredient().isEmpty()) {
                        return false;
                    }
                    if (inputStack.is(Items.NETHERITE_CHESTPLATE) && smithingTransformRecipe.templateIngredient().isPresent() && assetId.getNamespace().equals("elytra_chestplate")) {
                        return false;
                    }
                }
                return inputStack.is((Item)smithingTransformRecipe.result.item().value());
            }
            Recipe patt4$temp = recipeHolder.value();
            if (patt4$temp instanceof SmithingTrimRecipe) {
                Optional ingredient;
                SmithingTrimRecipe smithingTrimRecipe = (SmithingTrimRecipe)patt4$temp;
                if (!UncraftEverythingConfig.CONFIG.allowUnSmithing()) {
                    return false;
                }
                ArmorTrim armorTrim = (ArmorTrim)inputStack.get(DataComponents.TRIM);
                if (armorTrim != null && (ingredient = smithingTrimRecipe.additionIngredient()).isPresent() && armorTrim.pattern().equals((Object)smithingTrimRecipe.pattern)) {
                    return true;
                }
            }
            if (this.status == -1) {
                this.status = 0;
            }
            return false;
        }).toList();
        if (!recipes.isEmpty() || inputStack.is(Items.TIPPED_ARROW) || UncraftEverythingConfig.CONFIG.allowEnchantedItems.getAsBoolean() && inputStack.get(DataComponents.ENCHANTMENTS) != ItemEnchantments.EMPTY) {
            this.status = -1;
            this.experience = this.getExperience();
            this.experienceType = UncraftEverythingConfig.CONFIG.experienceType.getRaw() == UncraftEverythingConfig.ExperienceType.LEVEL ? 1 : 0;
        }
        ArrayList<UncraftingTableRecipe> outputs = new ArrayList<UncraftingTableRecipe>();
        if (inputStack.is(Items.TIPPED_ARROW)) {
            PotionContents potionContents = (PotionContents)inputStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            UncraftingTableRecipe outputStack = new UncraftingTableRecipe(new ItemStack((Holder)inputStack.getItem().builtInRegistryHolder(), 8, inputStack.getComponentsPatch()));
            ItemStack potion = new ItemStack((ItemLike)Items.LINGERING_POTION);
            potion.set(DataComponents.POTION_CONTENTS, (Object)potionContents);
            outputStack.addOutput(new ItemStack((ItemLike)Items.ARROW, 1));
            outputStack.addOutput(new ItemStack((ItemLike)Items.ARROW, 1));
            outputStack.addOutput(new ItemStack((ItemLike)Items.ARROW, 1));
            outputStack.addOutput(new ItemStack((ItemLike)Items.ARROW, 1));
            outputStack.addOutput(potion);
            outputStack.addOutput(new ItemStack((ItemLike)Items.ARROW, 1));
            outputStack.addOutput(new ItemStack((ItemLike)Items.ARROW, 1));
            outputStack.addOutput(new ItemStack((ItemLike)Items.ARROW, 1));
            outputStack.addOutput(new ItemStack((ItemLike)Items.ARROW, 1));
            outputs.add(outputStack);
        }
        if (inputStack.get(DataComponents.ENCHANTMENTS) != ItemEnchantments.EMPTY && recipes.isEmpty() && UncraftEverythingConfig.CONFIG.outputEnchantedBook()) {
            UncraftingTableRecipe outputStack = new UncraftingTableRecipe(new ItemStack((Holder)inputStack.getItem().builtInRegistryHolder(), 1, inputStack.getComponentsPatch()));
            ItemEnchantments enchantments = (ItemEnchantments)inputStack.get(DataComponents.ENCHANTMENTS);
            ItemStack book = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            book.set(DataComponents.STORED_ENCHANTMENTS, (Object)enchantments);
            output = new ItemStack((ItemLike)inputStack.getItem(), 1);
            output.setDamageValue(inputStack.getDamageValue());
            outputStack.addOutput((ItemStack)output);
            outputStack.addOutput(book);
            outputs.add(outputStack);
        }
        for (RecipeHolder r : recipes) {
            List<List<Item>> allIngredientCombinations;
            ItemStack stack;
            Object allIngredientCombinations2;
            Object allIngredientCombinations22;
            Object ingredients;
            output = r.value();
            if (output instanceof TransmuteRecipe) {
                TransmuteRecipe transmuteRecipe = (TransmuteRecipe)output;
                ingredients = List.of(transmuteRecipe.input, transmuteRecipe.material);
                allIngredientCombinations22 = this.getAllShapelessIngredientCombinations((List<Ingredient>)ingredients);
                ItemContainerContents itemContainerContents = (ItemContainerContents)inputStack.get(DataComponents.CONTAINER);
                Iterator iterator = allIngredientCombinations22.iterator();
                while (iterator.hasNext()) {
                    List list = (List)iterator.next();
                    UncraftingTableRecipe outputStack2 = new UncraftingTableRecipe(new ItemStack((Holder)((Item)transmuteRecipe.result.item().value()).builtInRegistryHolder(), 1, inputStack.getComponentsPatch()));
                    for (Item item2 : list) {
                        if (outputStack2.getOutputs().contains(item2.getDefaultInstance())) {
                            ItemStack stack2 = outputStack2.getOutputs().get(outputStack2.getOutputs().indexOf(item2.getDefaultInstance()));
                            if (stack2.has(DataComponents.CONTAINER)) {
                                stack2.set(DataComponents.CONTAINER, (Object)itemContainerContents);
                            }
                            stack2.setCount(stack2.getCount() + 1);
                            outputStack2.setOutput(outputStack2.getOutputs().indexOf(item2.getDefaultInstance()), stack2);
                            continue;
                        }
                        ItemStack itemStack = new ItemStack((ItemLike)item2, 1);
                        if (itemStack.has(DataComponents.CONTAINER)) {
                            itemStack.set(DataComponents.CONTAINER, (Object)itemContainerContents);
                        }
                        outputStack2.addOutput(itemStack);
                    }
                    outputs.add(outputStack2);
                }
            }
            if ((ingredients = r.value()) instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)ingredients;
                allIngredientCombinations2 = this.getAllIngredientCombinations(shapedRecipe.getIngredients());
                allIngredientCombinations22 = allIngredientCombinations2.iterator();
                while (allIngredientCombinations22.hasNext()) {
                    List ingredientCombination = (List)allIngredientCombinations22.next();
                    UncraftingTableRecipe outputStack3 = new UncraftingTableRecipe(new ItemStack((Holder)shapedRecipe.result.getItem().builtInRegistryHolder(), shapedRecipe.result.getCount(), inputStack.getComponentsPatch()));
                    HashMap<Item, Integer> hashMap = new HashMap<Item, Integer>();
                    for (Item item : ingredientCombination) {
                        if (outputStack3.getOutputs().contains(item.getDefaultInstance())) {
                            stack = outputStack3.getOutputs().get(outputStack3.getOutputs().indexOf(item.getDefaultInstance()));
                            outputStack3.setOutput(outputStack3.getOutputs().indexOf(item.getDefaultInstance()), new ItemStack((ItemLike)stack.getItem(), stack.getCount() + 1));
                        } else {
                            outputStack3.addOutput(new ItemStack((ItemLike)item, 1));
                        }
                        hashMap.put(item, hashMap.getOrDefault(item, 0) + 1);
                    }
                    if (inputStack.isDamaged()) {
                        Repairable repairableComponent = (Repairable)inputStack.get(DataComponents.REPAIRABLE);
                        if (repairableComponent != null) {
                            for (Map.Entry x : hashMap.entrySet()) {
                                if (!repairableComponent.isValidRepairItem(new ItemStack((ItemLike)x.getKey(), ((Integer)x.getValue()).intValue()))) continue;
                                int damagedPercentage = (int)Math.ceil((double)inputStack.getDamageValue() / (double)inputStack.getMaxDamage() * (double)((Integer)x.getValue()).intValue());
                                for (int i = 0; i < outputStack3.getOutputs().size() && damagedPercentage != 0; ++i) {
                                    if (!outputStack3.getOutputs().get(i).is((Item)x.getKey())) continue;
                                    outputStack3.setOutput(i, ItemStack.EMPTY);
                                    --damagedPercentage;
                                }
                                break;
                            }
                        } else {
                            this.status = 6;
                            outputs.clear();
                            return;
                        }
                    }
                    outputs.add(outputStack3);
                }
            }
            if ((allIngredientCombinations2 = r.value()) instanceof ShapelessRecipe) {
                ShapelessRecipe shapelessRecipe = (ShapelessRecipe)allIngredientCombinations2;
                ingredients = new ArrayList(shapelessRecipe.ingredients);
                if (inputStack.has(DataComponents.FIREWORKS)) {
                    Fireworks fireworks = (Fireworks)inputStack.getOrDefault(DataComponents.FIREWORKS, (Object)new Fireworks(1, List.of()));
                    for (int i = 1; i < fireworks.flightDuration(); ++i) {
                        ingredients.add(Ingredient.of((ItemLike)Items.GUNPOWDER));
                    }
                }
                allIngredientCombinations = this.getAllShapelessIngredientCombinations((List<Ingredient>)ingredients);
                for (List<Item> ingredientCombination : allIngredientCombinations) {
                    UncraftingTableRecipe uncraftingTableRecipe = new UncraftingTableRecipe(new ItemStack((Holder)shapelessRecipe.result.getItem().builtInRegistryHolder(), shapelessRecipe.result.getCount(), inputStack.getComponentsPatch()));
                    HashMap<Object, Integer> allIngredients = new HashMap<Object, Integer>();
                    for (Object item : ingredientCombination) {
                        if (item == Items.AIR) continue;
                        if (uncraftingTableRecipe.getOutputs().contains(item.getDefaultInstance())) {
                            ItemStack stack3 = uncraftingTableRecipe.getOutputs().get(uncraftingTableRecipe.getOutputs().indexOf(item.getDefaultInstance()));
                            uncraftingTableRecipe.setOutput(uncraftingTableRecipe.getOutputs().indexOf(item.getDefaultInstance()), new ItemStack((ItemLike)stack3.getItem(), stack3.getCount() + 1));
                        } else {
                            uncraftingTableRecipe.addOutput(new ItemStack((ItemLike)item, 1));
                        }
                        allIngredients.put(item, allIngredients.getOrDefault(item, 0) + 1);
                    }
                    if (inputStack.isDamaged()) {
                        Repairable repairable = (Repairable)inputStack.get(DataComponents.REPAIRABLE);
                        if (repairable != null) {
                            Object item;
                            item = allIngredients.entrySet().iterator();
                            while (item.hasNext()) {
                                Map.Entry x = (Map.Entry)item.next();
                                if (!repairable.isValidRepairItem(new ItemStack((ItemLike)x.getKey(), ((Integer)x.getValue()).intValue()))) continue;
                                int damagedPercentage = (int)Math.ceil((double)inputStack.getDamageValue() / (double)inputStack.getMaxDamage() * (double)((Integer)x.getValue()).intValue());
                                for (int i = 0; i < uncraftingTableRecipe.getOutputs().size() && damagedPercentage != 0; ++i) {
                                    if (!uncraftingTableRecipe.getOutputs().get(i).is((Item)x.getKey())) continue;
                                    uncraftingTableRecipe.setOutput(i, ItemStack.EMPTY);
                                    --damagedPercentage;
                                }
                                break;
                            }
                        } else {
                            this.status = 6;
                            outputs.clear();
                            return;
                        }
                    }
                    outputs.add(uncraftingTableRecipe);
                }
            }
            if ((ingredients = r.value()) instanceof SmithingTransformRecipe) {
                SmithingTransformRecipe smithingTransformRecipe = (SmithingTransformRecipe)ingredients;
                ingredients = new ArrayList();
                ingredients.add(Optional.of(smithingTransformRecipe.baseIngredient()));
                ingredients.add(smithingTransformRecipe.additionIngredient());
                ingredients.add(smithingTransformRecipe.templateIngredient());
                allIngredientCombinations = this.getAllIngredientCombinations((List<Optional<Ingredient>>)ingredients);
                for (List<Item> ingredientCombination : allIngredientCombinations) {
                    UncraftingTableRecipe uncraftingTableRecipe = new UncraftingTableRecipe(new ItemStack((Holder)((Item)smithingTransformRecipe.result.item().value()).builtInRegistryHolder(), 1, inputStack.getComponentsPatch()));
                    for (Item item : ingredientCombination) {
                        if (uncraftingTableRecipe.getOutputs().contains(item.getDefaultInstance())) {
                            stack = uncraftingTableRecipe.getOutputs().get(uncraftingTableRecipe.getOutputs().indexOf(item.getDefaultInstance()));
                            if (item.getDefaultInstance().isDamageableItem()) {
                                stack.set(DataComponents.DAMAGE, (Object)((Integer)inputStack.get(DataComponents.DAMAGE)));
                            }
                            stack.grow(1);
                            uncraftingTableRecipe.setOutput(uncraftingTableRecipe.getOutputs().indexOf(item.getDefaultInstance()), stack);
                            continue;
                        }
                        ItemStack itemStack = new ItemStack((ItemLike)item, 1);
                        if (item.getDefaultInstance().isDamageableItem()) {
                            itemStack.set(DataComponents.DAMAGE, (Object)((Integer)inputStack.get(DataComponents.DAMAGE)));
                            if ((Integer)itemStack.getOrDefault(DataComponents.DAMAGE, (Object)0) >= (Integer)itemStack.getOrDefault(DataComponents.MAX_DAMAGE, (Object)0)) {
                                itemStack = ItemStack.EMPTY;
                            }
                        }
                        uncraftingTableRecipe.addOutput(itemStack);
                    }
                    outputs.add(uncraftingTableRecipe);
                }
            }
            if (!((ingredients = r.value()) instanceof SmithingTrimRecipe)) continue;
            SmithingTrimRecipe smithingTrimRecipe = (SmithingTrimRecipe)ingredients;
            ArmorTrim armorTrim = (ArmorTrim)inputStack.get(DataComponents.TRIM);
            Optional additionIngredient = smithingTrimRecipe.additionIngredient();
            ArrayList<Optional<Ingredient>> ingredients2 = new ArrayList<Optional<Ingredient>>();
            smithingTrimRecipe.baseIngredient().getValues().stream().filter(itemHolder -> inputStack.is((Item)itemHolder.value())).forEach(itemHolder -> ingredients2.add(Optional.of(Ingredient.of((ItemLike)((ItemLike)itemHolder.value())))));
            ingredients2.add(smithingTrimRecipe.templateIngredient());
            if (additionIngredient.isPresent() && armorTrim != null) {
                ((Ingredient)additionIngredient.get()).getValues().stream().filter(itemHolder -> {
                    ResourceKey itemResourceKey = itemHolder.getKey();
                    ResourceKey armorTrimKey = armorTrim.material().getKey();
                    if (itemResourceKey != null && armorTrimKey != null) {
                        return itemResourceKey.location().getPath().contains(armorTrimKey.location().getPath());
                    }
                    return false;
                }).forEach(itemHolder -> ingredients2.add(Optional.of(Ingredient.of((ItemLike)((ItemLike)itemHolder.value())))));
            }
            List<List<Item>> allIngredientCombinations3 = this.getAllIngredientCombinations(ingredients2);
            ItemEnchantments itemEnchantments = (ItemEnchantments)inputStack.get(DataComponents.ENCHANTMENTS);
            for (List<Item> list : allIngredientCombinations3) {
                UncraftingTableRecipe outputStack4 = new UncraftingTableRecipe(inputStack.copyWithCount(1));
                for (Item item4 : list) {
                    if (outputStack4.getOutputs().contains(item4.getDefaultInstance())) {
                        ItemStack stack4 = outputStack4.getOutputs().get(outputStack4.getOutputs().indexOf(item4.getDefaultInstance()));
                        if (item4.getDefaultInstance().is(((Optional)ingredients2.getFirst()).isPresent() ? (Item)((Ingredient)((Optional)ingredients2.getFirst()).get()).getValues().get(0).value() : Items.AIR)) {
                            stack4.set(DataComponents.ENCHANTMENTS, (Object)itemEnchantments);
                            stack4.set(DataComponents.DAMAGE, (Object)((Integer)inputStack.get(DataComponents.DAMAGE)));
                        }
                        stack4.setCount(stack4.getCount() + 1);
                        outputStack4.setOutput(outputStack4.getOutputs().indexOf(item4.getDefaultInstance()), stack4);
                        continue;
                    }
                    ItemStack itemStack = new ItemStack((ItemLike)item4, 1);
                    if (item4.getDefaultInstance().is(((Optional)ingredients2.getFirst()).isPresent() ? (Item)((Ingredient)((Optional)ingredients2.getFirst()).get()).getValues().get(0).value() : Items.AIR)) {
                        itemStack.set(DataComponents.ENCHANTMENTS, (Object)itemEnchantments);
                        itemStack.set(DataComponents.DAMAGE, (Object)((Integer)inputStack.get(DataComponents.DAMAGE)));
                    }
                    outputStack4.addOutput(itemStack);
                }
                outputs.add(outputStack4);
            }
        }
        this.currentRecipes = outputs;
        if (!this.currentRecipes.isEmpty()) {
            PacketDistributor.sendToPlayer((ServerPlayer)this.player, (CustomPacketPayload)new UncraftingRecipeSelectionRequestPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (!this.hasRecipe()) {
                this.status = 1;
            } else if (!this.hasEnoughExperience()) {
                this.status = 2;
            }
        } else if (this.status == -1) {
            this.status = 0;
        }
    }

    private List<Item> getItemsFromIngredient(Ingredient ingredient) {
        List<Object> items = new ArrayList();
        if (ingredient.getCustomIngredient() != null && !ingredient.getCustomIngredient().items().toList().isEmpty()) {
            for (Holder holder : ingredient.getCustomIngredient().items().toList()) {
                items.add((Item)holder.value());
            }
        } else {
            try {
                items = ingredient.getValues().stream().map(Holder::value).distinct().toList();
            }
            catch (IllegalStateException e) {
                LogUtils.getLogger().warn("Skipping unsupported ingredient type: {}", (Object)ingredient);
                return Collections.emptyList();
            }
        }
        return items.stream().filter(item -> {
            if (item.getDescriptionId().contains("shulker_box")) {
                return item == Items.SHULKER_BOX;
            }
            return item.getCraftingRemainder(item.getDefaultInstance()) == ItemStack.EMPTY || item.getCraftingRemainder(item.getDefaultInstance()).getItem() != item.getDefaultInstance().getItem();
        }).sorted(Comparator.comparing(Item::getDescriptionId)).toList();
    }

    private List<List<Item>> getAllIngredientCombinations(List<Optional<Ingredient>> ingredients) {
        HashMap<String, Group> groupKeyToGroup = new HashMap<String, Group>();
        for (int i = 0; i < ingredients.size(); ++i) {
            List<Item> items;
            Optional<Ingredient> optIngredient = ingredients.get(i);
            List<Item> finalItems1 = items = optIngredient.map(ingredient -> {
                List<Item> ingredientItems = this.getItemsFromIngredient((Ingredient)ingredient);
                return ingredientItems.isEmpty() ? List.of(Items.AIR) : ingredientItems;
            }).orElse(List.of(Items.AIR));
            items = items.stream().filter(item -> {
                boolean isVanillaInput = BuiltInRegistries.ITEM.getKey((Object)((ItemResource)this.inputHandler.getResource(0)).getItem()).getNamespace().equals("minecraft");
                if (isVanillaInput && UncraftEverythingConfig.CONFIG.preventModdedIngredientRecipes()) {
                    return BuiltInRegistries.ITEM.getKey(item).getNamespace().equals("minecraft");
                }
                if (finalItems1.size() > 1) {
                    ResourceLocation ingredientRL = BuiltInRegistries.ITEM.getKey(item);
                    return !UncraftEverythingConfig.CONFIG.getRestrictedModIngredients().contains(ingredientRL.getNamespace());
                }
                return true;
            }).toList();
            String key = items.stream().map(Item::getDescriptionId).sorted().collect(Collectors.joining(","));
            List<Item> finalItems = items;
            Group group2 = groupKeyToGroup.computeIfAbsent(key, k -> new Group(new ArrayList<Integer>(), finalItems));
            group2.positions.add(i);
        }
        ArrayList groups = new ArrayList(groupKeyToGroup.values());
        List groupChoices = groups.stream().map(group -> group.items).collect(Collectors.toList());
        List product = UncraftingTableBlockEntity.cartesianProduct(groupChoices);
        ArrayList<List<Item>> combinations = new ArrayList<List<Item>>();
        for (List choiceList : product) {
            Object[] itemsArray = new Item[ingredients.size()];
            Arrays.fill(itemsArray, Items.AIR);
            for (int groupIdx = 0; groupIdx < groups.size(); ++groupIdx) {
                Group group3 = (Group)groups.get(groupIdx);
                Item chosenItem = (Item)choiceList.get(groupIdx);
                for (int pos : group3.positions) {
                    if (pos < 0 || pos >= itemsArray.length) continue;
                    itemsArray[pos] = chosenItem;
                }
            }
            combinations.add(Arrays.asList(itemsArray));
        }
        return combinations;
    }

    private List<List<Item>> getAllShapelessIngredientCombinations(List<Ingredient> ingredients) {
        HashMap<String, Group> groupKeyToGroup = new HashMap<String, Group>();
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = ingredients.get(i);
            List<Item> items = this.getItemsFromIngredient(ingredient);
            if (items.isEmpty()) {
                items = List.of(Items.AIR);
            }
            List<Item> finalItems1 = items;
            items = items.stream().filter(item -> {
                boolean isVanillaInput = BuiltInRegistries.ITEM.getKey((Object)((ItemResource)this.inputHandler.getResource(0)).getItem()).getNamespace().equals("minecraft");
                if (isVanillaInput && UncraftEverythingConfig.CONFIG.preventModdedIngredientRecipes()) {
                    return BuiltInRegistries.ITEM.getKey(item).getNamespace().equals("minecraft");
                }
                if (finalItems1.size() > 1) {
                    ResourceLocation ingredientRL = BuiltInRegistries.ITEM.getKey(item);
                    return !UncraftEverythingConfig.CONFIG.getRestrictedModIngredients().contains(ingredientRL.getNamespace());
                }
                return true;
            }).toList();
            String key = items.stream().map(Item::getDescriptionId).sorted().collect(Collectors.joining(","));
            List<Item> finalItems = items;
            Group group2 = groupKeyToGroup.computeIfAbsent(key, k -> new Group(new ArrayList<Integer>(), finalItems));
            group2.positions.add(i);
        }
        ArrayList groups = new ArrayList(groupKeyToGroup.values());
        List groupChoices = groups.stream().map(group -> group.items).collect(Collectors.toList());
        List product = UncraftingTableBlockEntity.cartesianProduct(groupChoices);
        ArrayList<List<Item>> combinations = new ArrayList<List<Item>>();
        for (List choiceList : product) {
            Object[] itemsArray = new Item[ingredients.size()];
            Arrays.fill(itemsArray, Items.AIR);
            for (int groupIdx = 0; groupIdx < groups.size(); ++groupIdx) {
                Group group3 = (Group)groups.get(groupIdx);
                Item chosenItem = (Item)choiceList.get(groupIdx);
                for (int pos : group3.positions) {
                    if (pos < 0 || pos >= itemsArray.length) continue;
                    itemsArray[pos] = chosenItem;
                }
            }
            combinations.add(Arrays.asList(itemsArray));
        }
        return combinations;
    }

    private static <T> List<List<T>> cartesianProduct(List<List<T>> lists) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (lists.isEmpty()) {
            result.add(new ArrayList());
            return result;
        }
        List<T> firstList = lists.getFirst();
        List<List<T>> remainingLists = UncraftingTableBlockEntity.cartesianProduct(lists.subList(1, lists.size()));
        for (T item : firstList) {
            for (List<T> remaining : remainingLists) {
                ArrayList<T> combination = new ArrayList<T>();
                combination.add(item);
                combination.addAll(remaining);
                result.add(combination);
            }
        }
        return result;
    }

    public static boolean isVanillaIngredientRecipe(Recipe<?> recipe) {
        List<Optional> ingredients;
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            ingredients = shaped.getIngredients();
        } else if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
            ingredients = shapeless.ingredients.stream().map(Optional::of).toList();
        } else if (recipe instanceof SmithingTransformRecipe) {
            SmithingTransformRecipe smithingTransformRecipe = (SmithingTransformRecipe)recipe;
            ingredients = List.of(Optional.of(smithingTransformRecipe.baseIngredient()), smithingTransformRecipe.additionIngredient(), smithingTransformRecipe.templateIngredient());
        } else {
            return true;
        }
        for (Optional ingredient : ingredients) {
            if (!ingredient.isPresent()) continue;
            if (((Ingredient)ingredient.get()).getCustomIngredient() != null && !((Ingredient)ingredient.get()).getCustomIngredient().items().toList().isEmpty()) {
                if (((Ingredient)ingredient.get()).getCustomIngredient().items().map(Holder::value).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)).map(ResourceLocation::getNamespace).toList().contains("minecraft")) continue;
                return false;
            }
            if (((Ingredient)ingredient.get()).getValues().stream().map(Holder::value).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)).map(ResourceLocation::getNamespace).toList().contains("minecraft")) continue;
            return false;
        }
        return true;
    }

    public void handleUncraftButtonClicked(boolean hasShiftDown) {
        if (hasShiftDown) {
            while (this.hasRecipe() && this.hasEnoughExperience()) {
                this.processUncraft(this.hasNextRecipe());
            }
        } else if (this.hasRecipe() && this.hasEnoughExperience()) {
            this.processUncraft(false);
        }
    }

    private void processUncraft(boolean hasNext) {
        List<ItemStack> outputs = this.currentRecipe.getOutputs();
        for (int i = 0; i < outputs.size(); ++i) {
            ItemStack output = outputs.get(i);
            if (i >= this.outputHandler.size()) continue;
            ItemStack slotStack = ((ItemResource)this.outputHandler.getResource(i)).toStack(this.outputHandler.getAmountAsInt(i));
            if (slotStack.isEmpty()) {
                this.outputHandler.set(i, (Resource)ItemResource.of((ItemStack)output.copy()), output.getCount());
                continue;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)output) || slotStack.getCount() + output.getCount() > slotStack.getMaxStackSize()) continue;
            slotStack.grow(output.getCount());
            this.outputHandler.set(i, (Resource)ItemResource.of((ItemStack)slotStack), slotStack.getCount());
        }
        if (((UncraftEverythingConfig.ExperienceType)((Object)UncraftEverythingConfig.CONFIG.experienceType.get())).equals((Object)UncraftEverythingConfig.ExperienceType.POINT)) {
            this.player.giveExperiencePoints(-this.getExperience());
        } else if (((UncraftEverythingConfig.ExperienceType)((Object)UncraftEverythingConfig.CONFIG.experienceType.get())).equals((Object)UncraftEverythingConfig.ExperienceType.LEVEL)) {
            this.player.giveExperienceLevels(-this.getExperience());
        }
        if (hasNext) {
            this.inputHandler.extractItemWithoutTriggerChanges(0, this.currentRecipe.getInput().getCount(), false);
        } else {
            try (Transaction tx = Transaction.open(null);){
                int count = this.inputHandler.extract(0, (Resource)ItemResource.of((ItemLike)this.currentRecipe.getInput().getItem(), (DataComponentPatch)this.currentRecipe.getInput().getComponentsPatch()), this.currentRecipe.getInput().getCount(), (TransactionContext)tx);
                if (count == this.currentRecipe.getInput().getCount()) {
                    tx.commit();
                }
            }
        }
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void handleRecipeSelection(UncraftingTableRecipe recipe) {
        this.currentRecipe = recipe;
        this.status = !this.hasRecipe() ? (((ItemResource)this.inputHandler.getResource(0)).isEmpty() ? 0 : (((Boolean)UncraftEverythingConfig.isItemLocked(this.player, ((ItemResource)this.inputHandler.getResource(0)).toStack(this.inputHandler.getAmountAsInt(0))).getLeft()).booleanValue() ? 8 : 1)) : (this.hasEnoughExperience() ? -1 : 2);
    }

    public void updatePage(int page) {
        this.page = page;
        PacketDistributor.sendToPlayer((ServerPlayer)this.player, (CustomPacketPayload)new UncraftingTableDataPayload(this.getBlockPos(), new ArrayList<UncraftingTableRecipe>(this.currentRecipes.subList(page * 7, Math.min(page * 7 + 7, this.currentRecipes.size()))), this.currentRecipes.size()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private int getExperience() {
        Map<String, Integer> experienceMap = PerItemExpCostConfig.getPerItemExp();
        int experience = experienceMap.getOrDefault(this.inputStackLocation().toString(), UncraftEverythingConfig.CONFIG.getExperience());
        for (Map.Entry<String, Integer> exp : experienceMap.entrySet()) {
            String regex;
            String tagName;
            Optional<TagKey<Item>> tagKey;
            if (exp.getKey().startsWith("#") && (tagKey = UncraftEverythingConfig.tryParseTagKey(tagName = exp.getKey().substring(1))).isPresent() && ((ItemResource)this.inputHandler.getResource(0)).is(tagKey.get())) {
                experience = exp.getValue();
                break;
            }
            if (!exp.getKey().contains("*") || !Pattern.matches(regex = exp.getKey().replace("*", ".*"), this.inputStackLocation().toString())) continue;
            experience = exp.getValue();
            break;
        }
        return experience;
    }

    private boolean hasEnoughExperience() {
        if (((UncraftEverythingConfig.ExperienceType)((Object)UncraftEverythingConfig.CONFIG.experienceType.get())).equals((Object)UncraftEverythingConfig.ExperienceType.POINT)) {
            return this.player.totalExperience >= this.getExperience() || this.player.isCreative();
        }
        if (((UncraftEverythingConfig.ExperienceType)((Object)UncraftEverythingConfig.CONFIG.experienceType.get())).equals((Object)UncraftEverythingConfig.ExperienceType.LEVEL)) {
            return this.player.experienceLevel >= this.getExperience() || this.player.isCreative();
        }
        return true;
    }

    private boolean hasRecipe() {
        if (this.currentRecipes.isEmpty() || this.currentRecipe == null) {
            return false;
        }
        ItemStack inputStack = ((ItemResource)this.inputHandler.getResource(0)).toStack(this.inputHandler.getAmountAsInt(0));
        if (inputStack.getCount() < this.currentRecipe.getInput().getCount()) {
            return false;
        }
        List<ItemStack> results = this.currentRecipe.getOutputs();
        for (int i = 0; i < results.size(); ++i) {
            ItemStack result = results.get(i);
            if (i >= this.outputHandler.size()) {
                return false;
            }
            ItemStack slotStack = ((ItemResource)this.outputHandler.getResource(i)).toStack(this.inputHandler.getAmountAsInt(0));
            if (slotStack.isEmpty()) continue;
            if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)result)) {
                return false;
            }
            if (slotStack.getCount() + result.getCount() <= slotStack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    private boolean hasNextRecipe() {
        if (this.currentRecipes.isEmpty() || this.currentRecipe == null) {
            return false;
        }
        if (((ItemResource)this.inputHandler.getResource(0)).toStack().getCount() - this.currentRecipe.getInput().getCount() < this.currentRecipe.getInput().getCount()) {
            return false;
        }
        List<ItemStack> results = this.currentRecipe.getOutputs();
        for (int i = 0; i < results.size(); ++i) {
            ItemStack result = results.get(i);
            if (i >= this.outputHandler.size()) {
                return false;
            }
            ItemStack slotStack = ((ItemResource)this.outputHandler.getResource(i)).toStack(this.outputHandler.getAmountAsInt(i));
            if (slotStack.isEmpty()) continue;
            if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)result)) {
                return false;
            }
            if (slotStack.getCount() + result.getCount() * 2 <= slotStack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    public List<UncraftingTableRecipe> getCurrentRecipes() {
        return this.currentRecipes;
    }

    public ContainerData getData() {
        return this.data;
    }

    private static class Group {
        List<Integer> positions;
        List<Item> items;

        Group(List<Integer> positions, List<Item> items) {
            this.positions = positions;
            this.items = items;
        }
    }
}

