/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.compat.jei;

import com.coolerpromc.uncrafteverything.block.UEBlocks;
import com.coolerpromc.uncrafteverything.blockentity.custom.UncraftingTableBlockEntity;
import com.coolerpromc.uncrafteverything.compat.jei.UncraftingRecipeCategory;
import com.coolerpromc.uncrafteverything.config.UncraftEverythingConfig;
import com.coolerpromc.uncrafteverything.event.UERecipeReceivedEvent;
import com.coolerpromc.uncrafteverything.screen.custom.UncraftingTableScreen;
import com.coolerpromc.uncrafteverything.util.JEIUncraftingTableRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class UEJEIPlugin
implements IModPlugin {
    public static final IRecipeType<JEIUncraftingTableRecipe> UNCRAFTING_TYPE = IRecipeType.create((String)"uncrafteverything", (String)"uncrafting_table", JEIUncraftingTableRecipe.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"uncrafteverything", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new UncraftingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList entries = new ArrayList();
        Ingredient shulkerBoxIngredient = Ingredient.of((HolderSet)BuiltInRegistries.ITEM.getOrThrow(Tags.Items.SHULKER_BOXES));
        shulkerBoxIngredient.getValues().forEach(itemStack -> {
            if (!((Item)itemStack.value()).equals(Items.SHULKER_BOX)) {
                entries.add(new JEIUncraftingTableRecipe(((Item)itemStack.value()).getDefaultInstance(), List.of(Ingredient.of((ItemLike)Blocks.SHULKER_BOX), Ingredient.of((ItemLike)DyeItem.byColor((DyeColor)Objects.requireNonNull(((ShulkerBoxBlock)((BlockItem)itemStack.value()).getBlock()).getColor()))))));
            }
        });
        Minecraft.getInstance().level.registryAccess().lookup(Registries.POTION).stream().flatMap(HolderLookup::listElements).forEach(potion -> {
            if (potion != Potions.WATER) {
                ItemStack tippedArrow = PotionContents.createItemStack((Item)Items.TIPPED_ARROW, (Holder)potion);
                ArrayList<Ingredient> output = new ArrayList<Ingredient>();
                output.add(Ingredient.of((ItemLike)Items.ARROW));
                output.add(Ingredient.of((ItemLike)Items.ARROW));
                output.add(Ingredient.of((ItemLike)Items.ARROW));
                output.add(Ingredient.of((ItemLike)Items.ARROW));
                output.add(DataComponentIngredient.of((boolean)false, (ItemStack)PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)potion)));
                output.add(Ingredient.of((ItemLike)Items.ARROW));
                output.add(Ingredient.of((ItemLike)Items.ARROW));
                output.add(Ingredient.of((ItemLike)Items.ARROW));
                output.add(Ingredient.of((ItemLike)Items.ARROW));
                entries.add(new JEIUncraftingTableRecipe(tippedArrow, output));
            }
        });
        Minecraft.getInstance().level.registryAccess().lookup(Registries.ENCHANTMENT).stream().flatMap(HolderLookup::listElements).forEach(enchantment -> {
            if (enchantment != null) {
                for (int i = 1; i <= ((Enchantment)enchantment.value()).getMaxLevel(); ++i) {
                    ItemStack enchantedBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                    enchantedBook.enchant((Holder)enchantment, i);
                    ItemStack dirt = new ItemStack((ItemLike)Items.DIAMOND_SWORD);
                    dirt.enchant((Holder)enchantment, i);
                    ArrayList<Ingredient> output = new ArrayList<Ingredient>();
                    output.add(Ingredient.of((ItemLike)Items.DIAMOND_SWORD));
                    output.add(DataComponentIngredient.of((boolean)false, (ItemStack)enchantedBook));
                    entries.add(new JEIUncraftingTableRecipe(dirt, output));
                }
            }
        });
        UERecipeReceivedEvent.recipeMap.values().forEach(recipeHolder -> {
            Recipe patt3$temp;
            Recipe patt2$temp;
            Recipe patt1$temp;
            Recipe patt0$temp = recipeHolder.value();
            if (patt0$temp instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)patt0$temp;
                boolean isVanillaInput = BuiltInRegistries.ITEM.getKey((Object)shapedRecipe.result.getItem()).getNamespace().equals("minecraft");
                if (!isVanillaInput || !UncraftEverythingConfig.CONFIG.preventModdedIngredientRecipes() || UncraftingTableBlockEntity.isVanillaIngredientRecipe(shapedRecipe)) {
                    entries.add(new JEIUncraftingTableRecipe(shapedRecipe.result, shapedRecipe.getIngredients().stream().map(ingredient -> ingredient.orElse(null)).toList()));
                }
            }
            if ((patt1$temp = recipeHolder.value()) instanceof ShapelessRecipe) {
                ShapelessRecipe shapelessRecipe = (ShapelessRecipe)patt1$temp;
                boolean isVanillaInput = BuiltInRegistries.ITEM.getKey((Object)shapelessRecipe.result.getItem()).getNamespace().equals("minecraft");
                if (!isVanillaInput || !UncraftEverythingConfig.CONFIG.preventModdedIngredientRecipes() || UncraftingTableBlockEntity.isVanillaIngredientRecipe(shapelessRecipe)) {
                    entries.add(new JEIUncraftingTableRecipe(shapelessRecipe.result, shapelessRecipe.ingredients));
                }
            }
            if ((patt2$temp = recipeHolder.value()) instanceof SmithingTransformRecipe) {
                SmithingTransformRecipe smithingTransformRecipe = (SmithingTransformRecipe)patt2$temp;
                boolean isVanillaInput = BuiltInRegistries.ITEM.getKey((Object)((Item)smithingTransformRecipe.result.item().value())).getNamespace().equals("minecraft");
                if (!isVanillaInput || !UncraftEverythingConfig.CONFIG.preventModdedIngredientRecipes() || UncraftingTableBlockEntity.isVanillaIngredientRecipe(smithingTransformRecipe)) {
                    NonNullList ingredients = NonNullList.create();
                    ingredients.add((Object)smithingTransformRecipe.baseIngredient());
                    smithingTransformRecipe.additionIngredient().ifPresent(arg_0 -> ingredients.add(arg_0));
                    smithingTransformRecipe.templateIngredient().ifPresent(arg_0 -> ingredients.add(arg_0));
                    entries.add(new JEIUncraftingTableRecipe(new ItemStack(smithingTransformRecipe.result.item(), 1, smithingTransformRecipe.result.components()), (List<Ingredient>)ingredients));
                }
            }
            if ((patt3$temp = recipeHolder.value()) instanceof SmithingTrimRecipe) {
                SmithingTrimRecipe smithingTrimRecipe = (SmithingTrimRecipe)patt3$temp;
                RegistryAccess registryAccess = Minecraft.getInstance().level.registryAccess();
                ArrayList<Ingredient> output = new ArrayList<Ingredient>();
                output.add(0, smithingTrimRecipe.baseIngredient());
                output.add(1, (Ingredient)smithingTrimRecipe.additionIngredient().get());
                output.add((Ingredient)smithingTrimRecipe.templateIngredient().get());
                smithingTrimRecipe.baseIngredient().getValues().stream().forEach(itemHolder -> {
                    output.set(0, Ingredient.of((ItemLike)((Item)itemHolder.value()).asItem()));
                    ((Ingredient)smithingTrimRecipe.additionIngredient().get()).getValues().forEach(itemHolder1 -> {
                        output.set(1, Ingredient.of((ItemLike)((ItemLike)itemHolder1.value())));
                        Optional trimMaterialReference = TrimMaterials.getFromIngredient((HolderLookup.Provider)registryAccess, (ItemStack)((Item)((Ingredient)smithingTrimRecipe.additionIngredient().get()).getValues().get(0).value()).getDefaultInstance());
                        if (trimMaterialReference.isPresent()) {
                            ItemStack stack = ((Item)itemHolder1.value()).getDefaultInstance();
                            stack.set(DataComponents.TRIM, (Object)new ArmorTrim((Holder)trimMaterialReference.get(), smithingTrimRecipe.pattern));
                            entries.add(new JEIUncraftingTableRecipe(stack, output));
                        }
                    });
                });
            }
        });
        registration.addRecipes(UNCRAFTING_TYPE, entries);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(UncraftingTableScreen.class, 59, 35, 22, 15, new IRecipeType[]{UNCRAFTING_TYPE});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)UEBlocks.UNCRAFTING_TABLE.get()), new IRecipeType[]{UNCRAFTING_TYPE});
    }
}

