/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.config;

import com.coolerpromc.uncrafteverything.compat.ftbquests.QuestHelper;
import com.coolerpromc.uncrafteverything.config.FTBQuestProgressionConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class UncraftEverythingConfig {
    public static final UncraftEverythingConfig CONFIG;
    public static final ModConfigSpec CONFIG_SPEC;
    public final ModConfigSpec.EnumValue<ExperienceType> experienceType;
    public final ModConfigSpec.IntValue experience;
    public final ModConfigSpec.EnumValue<RestrictionType> restrictionType;
    public final ModConfigSpec.ConfigValue<List<? extends String>> restrictions;
    public final ModConfigSpec.BooleanValue allowEnchantedItems;
    public final ModConfigSpec.BooleanValue allowUnSmithing;
    public final ModConfigSpec.BooleanValue allowDamaged;
    public final ModConfigSpec.BooleanValue preventModdedIngredientsFromVanillaItems;
    public final ModConfigSpec.ConfigValue<List<? extends String>> restrictedModIngredients;
    public final ModConfigSpec.BooleanValue enableProgression;
    public final ModConfigSpec.BooleanValue onlyAllowDefinedProgression;
    public final ModConfigSpec.BooleanValue outputEnchantedBook;

    private UncraftEverythingConfig(ModConfigSpec.Builder builder) {
        builder.push("Experience");
        this.experienceType = builder.comment("The type of experience to be used.").defineEnum("experienceType", (Enum)ExperienceType.LEVEL, (Enum[])ExperienceType.values());
        this.experience = builder.comment("The default amount of experience point/level required to uncraft an item. More detailed exp can me configured in uncrafteverything-exp.json").defineInRange("experiences", 1, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("Restrictions");
        this.restrictionType = builder.comment("The type of restriction to be used.").defineEnum("restrictionType", (Enum)RestrictionType.BLACKLIST, (Enum[])RestrictionType.values());
        this.restrictions = builder.comment(new String[]{"A list of items that can/cannot be uncrafted depending on type of restriction.", "Invalid input will cause config reset at runtime.", "Format: modid:item_name / modid:* / modid:*_glass / modid:black_* / modid:red_*_glass / modid:red_*_glass* / #modid:item_tag_name", "Press F3 + h in game and hover item to check their modid:name"}).defineList("restrictions", List.of("uncrafteverything:uncrafting_table", "minecraft:crafting_table"), () -> "", o -> o instanceof String && ResourceLocation.tryParse((String)((String)o)) != null || o.toString().contains("*") || UncraftEverythingConfig.tryParseTagKey(o.toString().substring(1)).isPresent());
        builder.pop();
        builder.push("AllowEnchantedItems");
        this.allowEnchantedItems = builder.comment("Allow uncrafting of enchanted items. [true/false]").define("allowEnchantedItems", true);
        builder.pop();
        builder.push("AllowUnSmithing");
        this.allowUnSmithing = builder.comment("Allow uncrafting of items that obtained from smithing (Trimmed Armor/Netherite Armor). [true/false]").define("allowUnSmithing", true);
        builder.pop();
        builder.push("AllowDamaged");
        this.allowDamaged = builder.comment("Allow uncrafting of damaged items. [true/false]").define("allowDamaged", true);
        builder.pop();
        builder.push("PreventModdedIngredientsFromVanillaItems");
        this.preventModdedIngredientsFromVanillaItems = builder.comment("Prevents vanilla items (e.g., iron axe) from being uncrafted using modded recipes. This helps avoid potential duplication or unintended outputs caused by modded ingredients. [true/false]").define("preventModdedIngredientsFromVanillaItems", true);
        builder.pop();
        builder.push("RestrictedModIngredients");
        this.restrictedModIngredients = builder.comment(new String[]{"A list of modid that would be excluded when uncrafting, to prevent too much recipes and causing performance issues.", "Format: modid"}).defineList("restrictedModIngredients", List.of("productivetrees", "chipped"), () -> "", o -> {
            String modid;
            return o instanceof String && !(modid = (String)o).equals("minecraft");
        });
        builder.pop();
        builder.push("FTBQuestProgression");
        this.enableProgression = builder.comment("Enable progression based uncrafting recipe search (Only available when FTB Quests is added to the mod pack)").define("enableProgression", false);
        this.onlyAllowDefinedProgression = builder.comment("When FTB Quests is added and progression enabled, only item defined in progression config able to uncraft, all other item will be disabled.").define("onlyAllowDefinedProgression", false);
        builder.pop();
        builder.push("OutputEnchantedBook");
        this.outputEnchantedBook = builder.comment("Output Enchanted Book for enchanted item. [true/false]").define("outputEnchantedBook", false);
        builder.pop();
    }

    public int getExperience() {
        return this.experience.getAsInt();
    }

    public boolean allowUnSmithing() {
        return this.allowUnSmithing.getAsBoolean();
    }

    public boolean allowDamaged() {
        return this.allowDamaged.getAsBoolean();
    }

    public boolean isEnchantedItemsAllowed(ItemStack itemStack) {
        return this.allowEnchantedItems.getAsBoolean() || itemStack.get(DataComponents.ENCHANTMENTS) == ItemEnchantments.EMPTY;
    }

    public boolean preventModdedIngredientRecipes() {
        return this.preventModdedIngredientsFromVanillaItems.getAsBoolean();
    }

    public boolean enableProgression() {
        return this.enableProgression.getAsBoolean();
    }

    public boolean onlyAllowDefinedProgression() {
        return this.onlyAllowDefinedProgression.getAsBoolean();
    }

    public boolean outputEnchantedBook() {
        return this.outputEnchantedBook.getAsBoolean();
    }

    public static Pair<Boolean, Integer> isItemLocked(ServerPlayer player, ItemStack itemStack) {
        if (CONFIG.enableProgression() && QuestHelper.FTBQUESTS_LOADED) {
            String questId = FTBQuestProgressionConfig.getQuestId(itemStack);
            if (CONFIG.onlyAllowDefinedProgression()) {
                return Pair.of((Object)(questId == null || !QuestHelper.hasCompletedQuestOrChapter(player, questId) ? 1 : 0), (Object)(questId == null ? 9 : 8));
            }
            return Pair.of((Object)(questId != null && !QuestHelper.hasCompletedQuestOrChapter(player, questId) ? 1 : 0), (Object)8);
        }
        return Pair.of((Object)false, (Object)-1);
    }

    public boolean isItemBlacklisted(ItemStack itemStack) {
        if (this.restrictionType.getRaw() != RestrictionType.BLACKLIST) {
            return false;
        }
        ResourceLocation itemLocation = this.inputStackLocation(itemStack);
        String itemLocationString = itemLocation.toString();
        if (((List)this.restrictions.get()).contains(itemLocationString)) {
            return true;
        }
        for (String entry : (List)this.restrictions.get()) {
            String regex;
            String tagName;
            Optional<TagKey<Item>> tagKey;
            if (entry.startsWith("#") && (tagKey = UncraftEverythingConfig.tryParseTagKey(tagName = entry.substring(1))).isPresent() && itemStack.is(tagKey.get())) {
                return true;
            }
            if (!entry.contains("*") || !itemLocationString.matches(regex = entry.replace("*", ".*"))) continue;
            return true;
        }
        return false;
    }

    public boolean isItemWhitelisted(ItemStack itemStack) {
        if (this.restrictionType.getRaw() != RestrictionType.WHITELIST) {
            return false;
        }
        ResourceLocation itemLocation = this.inputStackLocation(itemStack);
        String itemLocationString = itemLocation.toString();
        if (((List)this.restrictions.get()).contains(itemLocationString)) {
            return false;
        }
        for (String entry : (List)this.restrictions.get()) {
            String regex;
            String tagName;
            Optional<TagKey<Item>> tagKey;
            if (entry.startsWith("#") && (tagKey = UncraftEverythingConfig.tryParseTagKey(tagName = entry.substring(1))).isPresent() && itemStack.is(tagKey.get())) {
                return false;
            }
            if (!entry.contains("*") || !itemLocationString.matches(regex = entry.replace("*", ".*"))) continue;
            return false;
        }
        return true;
    }

    public List<? extends String> getRestrictedModIngredients() {
        return (List)this.restrictedModIngredients.get();
    }

    public ResourceLocation inputStackLocation(ItemStack itemStack) {
        return BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
    }

    public static Optional<TagKey<Item>> tryParseTagKey(String input) {
        try {
            ResourceLocation location = ResourceLocation.parse((String)input);
            return Optional.of(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)location));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(UncraftEverythingConfig::new);
        CONFIG = (UncraftEverythingConfig)pair.getLeft();
        CONFIG_SPEC = (ModConfigSpec)pair.getRight();
    }

    public static enum ExperienceType {
        LEVEL,
        POINT;

        public static final StreamCodec<RegistryFriendlyByteBuf, ExperienceType> STREAM_CODEC;

        static {
            STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ExperienceType>(){

                public ExperienceType decode(RegistryFriendlyByteBuf buffer) {
                    return (ExperienceType)buffer.readEnum(ExperienceType.class);
                }

                public void encode(RegistryFriendlyByteBuf buffer, ExperienceType value) {
                    buffer.writeEnum((Enum)value);
                }
            };
        }
    }

    public static enum RestrictionType {
        BLACKLIST,
        WHITELIST;

        public static final StreamCodec<RegistryFriendlyByteBuf, RestrictionType> STREAM_CODEC;

        static {
            STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, RestrictionType>(){

                public RestrictionType decode(RegistryFriendlyByteBuf buffer) {
                    return (RestrictionType)buffer.readEnum(RestrictionType.class);
                }

                public void encode(RegistryFriendlyByteBuf buffer, RestrictionType value) {
                    buffer.writeEnum((Enum)value);
                }
            };
        }
    }
}

