/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.screen.custom;

import com.coolerpromc.uncrafteverything.block.UEBlocks;
import com.coolerpromc.uncrafteverything.blockentity.custom.UncraftingTableBlockEntity;
import com.coolerpromc.uncrafteverything.screen.UEMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.item.ResourceHandlerSlot;
import net.neoforged.neoforge.transfer.resource.Resource;

public class UncraftingTableMenu
extends AbstractContainerMenu {
    public final UncraftingTableBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    public final Player player;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 10;

    public UncraftingTableMenu(int pContainerId, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        this(pContainerId, inventory, inventory.player.level().getBlockEntity(friendlyByteBuf.readBlockPos()), (ContainerData)new SimpleContainerData(3));
    }

    public UncraftingTableMenu(int pContainerId, Inventory inventory, BlockEntity blockEntity, ContainerData data) {
        super(UEMenuTypes.UNCRAFTING_TABLE_MENU.get(), pContainerId);
        this.blockEntity = (UncraftingTableBlockEntity)blockEntity;
        this.level = inventory.player.level();
        this.data = data;
        this.player = inventory.player;
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        ItemStacksResourceHandler inputHandler = this.blockEntity.getInputHandler();
        this.addSlot((Slot)new ResourceHandlerSlot((ResourceHandler)inputHandler, (arg_0, arg_1, arg_2) -> ((ItemStacksResourceHandler)inputHandler).set(arg_0, arg_1, arg_2), 0, 26, 35));
        ItemStacksResourceHandler outputHandler = this.blockEntity.getOutputHandler();
        for (int i = 0; i < this.blockEntity.getOutputHandler().size(); ++i) {
            this.addSlot((Slot)new ResourceHandlerSlot((ResourceHandler)outputHandler, (arg_0, arg_1, arg_2) -> ((ItemStacksResourceHandler)outputHandler).set(arg_0, arg_1, arg_2), i, 98 + 18 * (i % 3), 17 + i / 3 * 18));
        }
        this.addDataSlots(data);
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (!sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 46, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 46) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(pPlayer, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player pPlayer) {
        return UncraftingTableMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)pPlayer, (Block)((Block)UEBlocks.UNCRAFTING_TABLE.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 102 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 160));
        }
    }

    public void removed(Player player) {
        super.removed(player);
        if (!player.level().isClientSide()) {
            ItemStack stack = ((ItemResource)this.blockEntity.getInputHandler().getResource(0)).toStack(this.blockEntity.getInputHandler().getAmountAsInt(0));
            if (!stack.isEmpty()) {
                player.getInventory().placeItemBackInInventory(stack);
                this.blockEntity.getInputHandler().set(0, (Resource)ItemResource.EMPTY, 0);
                this.blockEntity.setChanged();
            }
            for (int i = 0; i < this.blockEntity.getOutputHandler().size(); ++i) {
                ItemStack outputStack = ((ItemResource)this.blockEntity.getOutputHandler().getResource(i)).toStack(this.blockEntity.getOutputHandler().getAmountAsInt(i));
                if (outputStack.isEmpty()) continue;
                player.getInventory().placeItemBackInInventory(outputStack);
                this.blockEntity.getOutputHandler().set(i, (Resource)ItemResource.EMPTY, 0);
                this.blockEntity.setChanged();
            }
        }
    }

    public String getExpType() {
        return this.data.get(1) == 0 ? "Point" : "Level";
    }

    public int getExpAmount() {
        return this.data.get(0);
    }

    public int getStatus() {
        return this.data.get(2);
    }
}

