/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.util;

import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;

public class ModItemStackHandler
extends ItemStacksResourceHandler {
    public ModItemStackHandler(int size) {
        super(NonNullList.withSize((int)size, (Object)ItemStack.EMPTY));
    }

    public ItemStack extractItemWithoutTriggerChanges(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        if (slot < 0 || slot >= this.size()) {
            throw new IllegalStateException("Slot " + slot + " invalid for size " + this.size());
        }
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.EMPTY);
                return existing;
            }
            return existing.copy();
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)existing.copyWithCount(existing.getCount() - toExtract));
        }
        return existing.copyWithCount(toExtract);
    }
}

