/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.compat.rei;

import com.coolerpromc.uncrafteverything.block.UEBlocks;
import com.coolerpromc.uncrafteverything.compat.rei.UncraftingRecipeCategory;
import com.coolerpromc.uncrafteverything.compat.rei.UncraftingRecipeDisplay;
import com.coolerpromc.uncrafteverything.event.UERecipeReceivedEvent;
import com.coolerpromc.uncrafteverything.screen.custom.UncraftingTableScreen;
import com.coolerpromc.uncrafteverything.util.JEIUncraftingTableRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.neoforged.neoforge.common.Tags;

@REIPluginClient
public class UEREIPlugin
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new UncraftingRecipeCategory(), configuration -> configuration.addWorkstations(new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)UEBlocks.UNCRAFTING_TABLE.get()))}));
    }

    public void registerDisplays(DisplayRegistry registry) {
        ArrayList entries = new ArrayList();
        Ingredient shulkerBoxIngredient = Ingredient.of((HolderSet)BuiltInRegistries.ITEM.getOrThrow(Tags.Items.SHULKER_BOXES));
        shulkerBoxIngredient.getValues().forEach(itemStack -> {
            if (!((Item)itemStack.value()).equals(Items.SHULKER_BOX)) {
                entries.add(new JEIUncraftingTableRecipe(((Item)itemStack.value()).getDefaultInstance(), List.of(Ingredient.of((ItemLike)Blocks.SHULKER_BOX), Ingredient.of((ItemLike)DyeItem.byColor((DyeColor)Objects.requireNonNull(((ShulkerBoxBlock)((BlockItem)itemStack.value()).getBlock()).getColor()))))));
            }
        });
        BasicDisplay.registryAccess().lookup(Registries.POTION).stream().flatMap(HolderLookup::listElements).forEach(potion -> {
            if (potion != Potions.WATER) {
                ItemStack tippedArrow = PotionContents.createItemStack((Item)Items.TIPPED_ARROW, (Holder)potion);
                ArrayList<ItemStack> output = new ArrayList<ItemStack>();
                output.add(Items.ARROW.getDefaultInstance());
                output.add(Items.ARROW.getDefaultInstance());
                output.add(Items.ARROW.getDefaultInstance());
                output.add(Items.ARROW.getDefaultInstance());
                output.add(PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)potion));
                output.add(Items.ARROW.getDefaultInstance());
                output.add(Items.ARROW.getDefaultInstance());
                output.add(Items.ARROW.getDefaultInstance());
                output.add(Items.ARROW.getDefaultInstance());
                entries.add(new JEIUncraftingTableRecipe(tippedArrow, output, true));
            }
        });
        BasicDisplay.registryAccess().lookup(Registries.ENCHANTMENT).stream().flatMap(HolderLookup::listElements).forEach(holder -> {
            if (!holder.isBound()) {
                return;
            }
            Enchantment enchantment = (Enchantment)holder.value();
            ItemStack diamondSword = new ItemStack((ItemLike)Items.DIAMOND_SWORD);
            diamondSword.enchant((Holder)holder, enchantment.getMaxLevel());
            ArrayList<ItemStack> output = new ArrayList<ItemStack>();
            output.add(Items.DIAMOND_SWORD.getDefaultInstance());
            output.add(EnchantmentHelper.createBook((EnchantmentInstance)new EnchantmentInstance((Holder)holder, enchantment.getMaxLevel())));
            entries.add(new JEIUncraftingTableRecipe(diamondSword, output, true));
        });
        UERecipeReceivedEvent.recipeMap.values().forEach(recipeHolder -> {
            Recipe patt3$temp;
            Recipe patt2$temp;
            Recipe patt1$temp;
            Recipe patt0$temp = recipeHolder.value();
            if (patt0$temp instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)patt0$temp;
                entries.add(new JEIUncraftingTableRecipe(shapedRecipe.result, shapedRecipe.getIngredients().stream().map(ingredient -> ingredient.orElse(null)).toList()));
            }
            if ((patt1$temp = recipeHolder.value()) instanceof ShapelessRecipe) {
                ShapelessRecipe shapelessRecipe = (ShapelessRecipe)patt1$temp;
                entries.add(new JEIUncraftingTableRecipe(shapelessRecipe.result, shapelessRecipe.ingredients));
            }
            if ((patt2$temp = recipeHolder.value()) instanceof SmithingTransformRecipe) {
                SmithingTransformRecipe smithingTransformRecipe = (SmithingTransformRecipe)patt2$temp;
                NonNullList ingredients = NonNullList.create();
                ingredients.add((Object)smithingTransformRecipe.baseIngredient());
                smithingTransformRecipe.additionIngredient().ifPresent(arg_0 -> ingredients.add(arg_0));
                smithingTransformRecipe.templateIngredient().ifPresent(arg_0 -> ingredients.add(arg_0));
                entries.add(new JEIUncraftingTableRecipe(new ItemStack(smithingTransformRecipe.result.item(), 1, smithingTransformRecipe.result.components()), (List<Ingredient>)ingredients));
            }
            if ((patt3$temp = recipeHolder.value()) instanceof SmithingTrimRecipe) {
                SmithingTrimRecipe smithingTrimRecipe = (SmithingTrimRecipe)patt3$temp;
                RegistryAccess registryAccess = Minecraft.getInstance().level.registryAccess();
                ArrayList<Ingredient> output = new ArrayList<Ingredient>();
                output.add(0, smithingTrimRecipe.baseIngredient());
                output.add(1, (Ingredient)smithingTrimRecipe.additionIngredient().get());
                output.add((Ingredient)smithingTrimRecipe.templateIngredient().get());
                smithingTrimRecipe.baseIngredient().getValues().stream().forEach(itemHolder -> {
                    output.set(0, Ingredient.of((ItemLike)((Item)itemHolder.value()).asItem()));
                    ((Ingredient)smithingTrimRecipe.additionIngredient().get()).getValues().forEach(itemHolder1 -> {
                        output.set(1, Ingredient.of((ItemLike)((ItemLike)itemHolder1.value())));
                        Optional trimMaterialReference = TrimMaterials.getFromIngredient((HolderLookup.Provider)registryAccess, (ItemStack)((Item)((Ingredient)smithingTrimRecipe.additionIngredient().get()).getValues().get(0).value()).getDefaultInstance());
                        if (trimMaterialReference.isPresent()) {
                            ItemStack stack = ((Item)itemHolder1.value()).getDefaultInstance();
                            stack.set(DataComponents.TRIM, (Object)new ArmorTrim((Holder)trimMaterialReference.get(), smithingTrimRecipe.pattern));
                            entries.add(new JEIUncraftingTableRecipe(stack, output));
                        }
                    });
                });
            }
        });
        entries.forEach(jeiUncraftingTableRecipe -> registry.add((Display)new UncraftingRecipeDisplay(List.of(EntryIngredients.of((ItemStack)jeiUncraftingTableRecipe.getInput())), jeiUncraftingTableRecipe.getEntryIngredientOutput())));
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerClickArea(screen -> new Rectangle((screen.width - 176) / 2 + 59, (screen.height - 166) / 2 + 27, 22, 15), UncraftingTableScreen.class, new CategoryIdentifier[]{UncraftingRecipeDisplay.CATEGORY_IDENTIFIER});
    }

    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(UncraftingTableScreen.class, screen -> List.of(new Rectangle(0, 0, screen.getGuiLeft(), screen.height)));
    }
}

