/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.networking;

import com.coolerpromc.uncrafteverything.blockentity.custom.UncraftingTableBlockEntity;
import com.coolerpromc.uncrafteverything.config.FTBQuestProgressionConfig;
import com.coolerpromc.uncrafteverything.config.PerItemExpCostConfig;
import com.coolerpromc.uncrafteverything.config.UncraftEverythingConfig;
import com.coolerpromc.uncrafteverything.networking.RequestConfigPayload;
import com.coolerpromc.uncrafteverything.networking.ResponseConfigPayload;
import com.coolerpromc.uncrafteverything.networking.UEConfigPayload;
import com.coolerpromc.uncrafteverything.networking.UEExpPayload;
import com.coolerpromc.uncrafteverything.networking.UEProgressionPayload;
import com.coolerpromc.uncrafteverything.networking.UncraftingRecipeSelectionDataPayload;
import com.coolerpromc.uncrafteverything.networking.UncraftingRecipeSelectionPayload;
import com.coolerpromc.uncrafteverything.networking.UncraftingTableCraftButtonClickPayload;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static void handleButtonClick(UncraftingTableCraftButtonClickPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            BlockPos pos;
            ServerPlayer player;
            ServerLevel level;
            BlockEntity blockEntity;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer && (blockEntity = (level = (player = (ServerPlayer)patt0$temp).level()).getBlockEntity(pos = payload.blockPos())) instanceof UncraftingTableBlockEntity) {
                UncraftingTableBlockEntity uncraftingTableBlockEntity = (UncraftingTableBlockEntity)blockEntity;
                uncraftingTableBlockEntity.handleUncraftButtonClicked(payload.hasShiftDown());
                blockEntity.setChanged();
                level.sendBlockUpdated(pos, level.getBlockState(pos), level.getBlockState(pos), 3);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"screen.uncrafteverything.disconnected", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void handleRecipeSelection(UncraftingRecipeSelectionPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            BlockPos pos;
            ServerPlayer player;
            ServerLevel level;
            BlockEntity blockEntity;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer && (blockEntity = (level = (player = (ServerPlayer)patt0$temp).level()).getBlockEntity(pos = payload.blockPos())) instanceof UncraftingTableBlockEntity) {
                UncraftingTableBlockEntity uncraftingTableBlockEntity = (UncraftingTableBlockEntity)blockEntity;
                uncraftingTableBlockEntity.handleRecipeSelection(payload.recipe());
                blockEntity.setChanged();
                level.sendBlockUpdated(pos, level.getBlockState(pos), level.getBlockState(pos), 3);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"screen.uncrafteverything.disconnected", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void handleConfig(UEConfigPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                UncraftEverythingConfig config = UncraftEverythingConfig.CONFIG;
                config.restrictionType.set((Object)payload.restrictionType());
                config.restrictions.set(payload.restrictedItems());
                config.allowEnchantedItems.set((Object)payload.allowEnchantedItem());
                config.experienceType.set((Object)payload.experienceType());
                config.experience.set((Object)payload.experience());
                config.allowUnSmithing.set((Object)payload.allowUnsmithing());
                config.allowDamaged.set((Object)payload.allowDamaged());
                config.preventModdedIngredientsFromVanillaItems.set((Object)payload.preventModdedIngredientsFromVanillaItems());
                config.restrictedModIngredients.set(payload.restrictedModIngredients());
                config.enableProgression.set((Object)payload.enableProgression());
                config.onlyAllowDefinedProgression.set((Object)payload.onlyAllowDefinedProgression());
                config.outputEnchantedBook.set((Object)payload.outputEnchantedBook());
                UncraftEverythingConfig.CONFIG_SPEC.save();
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"screen.uncrafteverything.disconnected", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void handleRequestConfig(RequestConfigPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                UncraftEverythingConfig config = UncraftEverythingConfig.CONFIG;
                ResponseConfigPayload configPayload = new ResponseConfigPayload((UncraftEverythingConfig.RestrictionType)((Object)((Object)config.restrictionType.get())), (List)config.restrictions.get(), (Boolean)config.allowEnchantedItems.get(), (UncraftEverythingConfig.ExperienceType)((Object)((Object)config.experienceType.get())), (Integer)config.experience.get(), (Boolean)config.allowUnSmithing.get(), (Boolean)config.allowDamaged.get(), (Boolean)config.preventModdedIngredientsFromVanillaItems.get(), PerItemExpCostConfig.getPerItemExp(), (List)config.restrictedModIngredients.get(), FTBQuestProgressionConfig.getProgressionMap(), (Boolean)config.enableProgression.get(), (Boolean)config.onlyAllowDefinedProgression.get(), (Boolean)config.outputEnchantedBook.get());
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)configPayload, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"screen.uncrafteverything.disconnected", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void handleExpCost(UEExpPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                PerItemExpCostConfig.getPerItemExp().clear();
                PerItemExpCostConfig.getPerItemExp().putAll(payload.perItemExp());
                PerItemExpCostConfig.save();
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"screen.uncrafteverything.disconnected", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void handleProgression(UEProgressionPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player() instanceof ServerPlayer) {
                FTBQuestProgressionConfig.getProgressionMap().clear();
                FTBQuestProgressionConfig.getProgressionMap().putAll(payload.progressionMap());
                FTBQuestProgressionConfig.save();
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"screen.uncrafteverything.disconnected", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void handleRecipeSelectionData(UncraftingRecipeSelectionDataPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            BlockPos pos;
            ServerPlayer player;
            ServerLevel level;
            BlockEntity blockEntity;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer && (blockEntity = (level = (player = (ServerPlayer)patt0$temp).level()).getBlockEntity(pos = payload.blockPos())) instanceof UncraftingTableBlockEntity) {
                UncraftingTableBlockEntity uncraftingTableBlockEntity = (UncraftingTableBlockEntity)blockEntity;
                uncraftingTableBlockEntity.updatePage(payload.page());
                blockEntity.setChanged();
                level.sendBlockUpdated(pos, level.getBlockState(pos), level.getBlockState(pos), 3);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"screen.uncrafteverything.disconnected", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

