/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.screen.custom;

import com.coolerpromc.uncrafteverything.networking.ClientPayloadHandler;
import com.coolerpromc.uncrafteverything.networking.RequestConfigPayload;
import com.coolerpromc.uncrafteverything.networking.UEProgressionPayload;
import com.coolerpromc.uncrafteverything.screen.custom.AbstractScrollableScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import org.jetbrains.annotations.NotNull;

public class FTBQuestsProgressionConfigScreen
extends AbstractScrollableScreen {
    private final Screen parent;
    private final List<Entry> entries = new ArrayList<Entry>();
    private final int ENTRY_HEIGHT = 24;
    private final int ENTRIES_START_Y = 30;
    private final int ENTRIES_END_Y = 200;
    private boolean hasLoadedFromConfig = false;
    private Button addButton;
    private Button cancelButton;
    private Button saveButton;
    private final List<EditBox> scrollableEditBoxes = new ArrayList<EditBox>();
    private final List<Button> scrollableButtons = new ArrayList<Button>();

    public FTBQuestsProgressionConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"screen.uncrafteverything.ftb_quest_progression_config"), 200);
        this.parent = parent;
    }

    protected void init() {
        this.saveCurrentValues();
        this.clearWidgets();
        this.scrollableEditBoxes.clear();
        this.scrollableButtons.clear();
        if (!this.hasLoadedFromConfig) {
            for (Map.Entry<String, String> entry : ClientPayloadHandler.payloadFromServer.ftbQuestProgression().entrySet()) {
                this.entries.add(new Entry(entry.getKey(), entry.getValue()));
            }
            this.hasLoadedFromConfig = true;
        }
        int visibleHeight = 170;
        this.contentHeight = this.entries.size() * 24 + 16;
        int startIndex = (int)(this.scrollAmount / 24.0);
        int endIndex = Math.min(this.entries.size(), startIndex + visibleHeight / 24 + 2);
        for (int i = startIndex; i < endIndex; ++i) {
            Entry entry = this.entries.get(i);
            int y = (int)((double)(30 + i * 24) - this.scrollAmount);
            if (y < 6 || y > 200) continue;
            entry.initWidgets(this.width / 2 - 170, y + 16);
            entry.addToScreen(this);
        }
        this.addButton = Button.builder((Component)Component.translatable((String)"screen.uncrafteverything.add_new_entry"), b -> {
            this.entries.add(new Entry("", ""));
            this.init();
        }).bounds(this.width / 2 - 100, this.height - 53, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.addButton);
        this.cancelButton = Button.builder((Component)Component.translatable((String)"screen.uncrafteverything.cancel"), button -> this.onClose()).bounds(this.width / 2 - this.width / 3 - 10, this.height - 28, this.width / 3, 20).build();
        this.addRenderableWidget((GuiEventListener)this.cancelButton);
        this.saveButton = Button.builder((Component)Component.translatable((String)"screen.uncrafteverything.save"), this::saveButtonPressed).bounds(this.width / 2 + 10, this.height - 28, this.width / 3, 20).build();
        this.addRenderableWidget((GuiEventListener)this.saveButton);
    }

    private void saveButtonPressed(Button button) {
        this.saveCurrentValues();
        HashMap<String, String> newConfig = new HashMap<String, String>();
        for (Entry entry : this.entries) {
            String key = entry.currentKey.trim();
            String val = entry.currentValue.trim();
            if (key.isEmpty() || val.isEmpty()) continue;
            newConfig.put(key, val);
        }
        UEProgressionPayload configPayload = new UEProgressionPayload(newConfig);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)configPayload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new RequestConfigPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.getMinecraft().setScreen(this.parent);
    }

    private void saveCurrentValues() {
        for (Entry entry : this.entries) {
            if (entry.keyBox != null) {
                entry.currentKey = entry.keyBox.getValue();
            }
            if (entry.valueBox == null) continue;
            entry.currentValue = entry.valueBox.getValue();
        }
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        this.init();
        return true;
    }

    @Override
    protected int scrollBarX() {
        return this.width - 6;
    }

    @Override
    protected int scrollBarY() {
        int scrollBarHeight = Math.max(10, (int)((double)((this.height - 90) * (this.height - 90)) / (double)this.contentHeight));
        return (int)(25.0 + this.scrollAmount / (double)this.getMaxScroll() * (double)(this.height - 90 - scrollBarHeight));
    }

    @Override
    protected int scrollerHeight() {
        return Math.max(10, (int)((double)((this.height - 90) * (this.height - 90)) / (double)this.contentHeight));
    }

    @Override
    protected int getMaxScroll() {
        return Math.max(0, this.contentHeight - (this.height - 95));
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderMenuBackground(guiGraphics);
        this.renderBlurredBackground(guiGraphics);
        this.renderSeparator(guiGraphics);
        this.renderScrollbar(guiGraphics, 90);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        int n = this.width / 2;
        Objects.requireNonNull(this.font);
        guiGraphics.drawCenteredString(this.font, this.title, n, (23 - 9) / 2, -1);
        guiGraphics.enableScissor(0, 25, this.width, this.height - 65);
        MutableComponent key = Component.translatable((String)"screen.uncrafteverything.per_item_xp_config.key");
        guiGraphics.drawString(this.font, (Component)key, this.width / 2 - 170 + (150 - this.font.width((FormattedText)key)) / 2, (int)(30.0 - this.scrollAmount), -1, false);
        MutableComponent value = Component.translatable((String)"screen.uncrafteverything.ftb_quest_progression_config.value");
        guiGraphics.drawString(this.font, (Component)value, this.width / 2 - 170 + 160 + (150 - this.font.width((FormattedText)value)) / 2, (int)(30.0 - this.scrollAmount), -1, false);
        MutableComponent del = Component.translatable((String)"screen.uncrafteverything.per_item_xp_config.del");
        guiGraphics.drawString(this.font, (Component)del, this.width / 2 - 170 + 320 + (20 - this.font.width((FormattedText)del)) / 2, (int)(30.0 - this.scrollAmount), -1, false);
        for (EditBox editBox : this.scrollableEditBoxes) {
            editBox.render(guiGraphics, mouseX, mouseY, delta);
        }
        for (Button button : this.scrollableButtons) {
            button.render(guiGraphics, mouseX, mouseY, delta);
        }
        guiGraphics.disableScissor();
        this.renderables.forEach(renderable -> {
            if (renderable instanceof Button && !this.scrollableButtons.contains(renderable)) {
                renderable.render(guiGraphics, mouseX, mouseY, delta);
            }
        });
    }

    @Override
    public boolean mouseClicked(MouseButtonEvent buttonEvent, boolean doubled) {
        boolean inScrollArea;
        int scrollTop = 25;
        int scrollBottom = this.height - 65;
        boolean bl = inScrollArea = buttonEvent.y() >= (double)scrollTop && buttonEvent.y() <= (double)scrollBottom;
        if (!inScrollArea) {
            if (!(this.addButton.isMouseOver(buttonEvent.x(), buttonEvent.y()) || this.cancelButton.isMouseOver(buttonEvent.x(), buttonEvent.y()) || this.saveButton.isMouseOver(buttonEvent.x(), buttonEvent.y()))) {
                return false;
            }
            if (this.addButton.isMouseOver(buttonEvent.x(), buttonEvent.y())) {
                return this.addButton.mouseClicked(buttonEvent, doubled);
            }
            if (this.cancelButton.isMouseOver(buttonEvent.x(), buttonEvent.y())) {
                return this.cancelButton.mouseClicked(buttonEvent, doubled);
            }
            if (this.saveButton.isMouseOver(buttonEvent.x(), buttonEvent.y())) {
                return this.saveButton.mouseClicked(buttonEvent, doubled);
            }
        }
        return super.mouseClicked(buttonEvent, doubled);
    }

    public void onClose() {
        this.getMinecraft().setScreen(this.parent);
    }

    protected void renderSeparator(GuiGraphics guiGraphics) {
        ResourceLocation header = this.getMinecraft().level == null ? Screen.HEADER_SEPARATOR : Screen.INWORLD_HEADER_SEPARATOR;
        ResourceLocation footer = this.getMinecraft().level == null ? Screen.FOOTER_SEPARATOR : Screen.INWORLD_FOOTER_SEPARATOR;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, header, 0, 23, 0.0f, 0.0f, this.width, 2, 32, 2);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, footer, 0, this.height - 65, 0.0f, 0.0f, this.width, 2, 32, 2);
    }

    private class Entry {
        EditBox keyBox;
        EditBox valueBox;
        Button deleteButton;
        String currentKey;
        String currentValue;

        Entry(String key, String value) {
            this.currentKey = key;
            this.currentValue = value;
        }

        void initWidgets(int x, int y) {
            this.keyBox = new EditBox(FTBQuestsProgressionConfigScreen.this.font, x, y, 150, 20, (Component)Component.translatable((String)"screen.uncrafteverything.key"));
            this.keyBox.setValue(this.currentKey);
            this.valueBox = new EditBox(FTBQuestsProgressionConfigScreen.this.font, x + 160, y, 150, 20, (Component)Component.translatable((String)"screen.uncrafteverything.value"));
            this.valueBox.setValue(this.currentValue);
            this.deleteButton = Button.builder((Component)Component.translatable((String)"screen.uncrafteverything.x"), b -> {
                FTBQuestsProgressionConfigScreen.this.entries.remove(this);
                FTBQuestsProgressionConfigScreen.this.init();
            }).bounds(x + 320, y, 20, 20).build();
        }

        void addToScreen(FTBQuestsProgressionConfigScreen screen) {
            screen.addRenderableWidget((GuiEventListener)this.keyBox);
            screen.addRenderableWidget((GuiEventListener)this.valueBox);
            screen.addRenderableWidget((GuiEventListener)this.deleteButton);
            screen.scrollableEditBoxes.add(this.keyBox);
            screen.scrollableEditBoxes.add(this.valueBox);
            screen.scrollableButtons.add(this.deleteButton);
        }
    }
}

